/*
 * Decompiled with CFR 0.152.
 */
package across.util;

import across.data.Param;
import across.data.PossibleReply;
import across.data.interlingua.InterLinguaConclusion;
import across.data.interlingua.InterLinguaPrerequisite;
import across.data.interlingua.InterLinguaReply;
import across.data.interlingua.InterLinguaSentence;
import across.data.interlingua.InterLinguaSentences;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InterLinguaTools {
    private InterLinguaTools() {
    }

    public static List sentencesToStringList(InterLinguaSentences sentences) {
        ArrayList<String> strings = new ArrayList<String>(sentences.getInterLinguaSentence().size());
        for (InterLinguaSentence sentence : sentences.getInterLinguaSentence()) {
            strings.add(InterLinguaTools.sentenceToString(sentence));
        }
        return strings;
    }

    public static String sentenceToString(InterLinguaSentence sentence) {
        StringBuffer bufQuery = new StringBuffer(500);
        List<InterLinguaPrerequisite> prerequisities = sentence.getInterLinguaPrerequisite();
        Iterator<InterLinguaPrerequisite> iter = prerequisities.iterator();
        while (iter.hasNext()) {
            String item = InterLinguaTools.translateLiteral(iter.next());
            bufQuery.append(item);
            if (!iter.hasNext()) continue;
            bufQuery.append(" & ");
        }
        if (sentence.getInterLinguaConclusion() != null) {
            bufQuery.append(" => ");
            bufQuery.append(InterLinguaTools.translateLiteral(sentence.getInterLinguaConclusion()));
        }
        return bufQuery.toString();
    }

    private static String translateLiteral(InterLinguaConclusion literal) {
        return String.valueOf(literal.getName()) + "(" + InterLinguaTools.getToken(literal.getArg1()) + ", " + InterLinguaTools.getToken(literal.getArg2()) + ")";
    }

    private static String translateLiteral(InterLinguaPrerequisite literal) {
        return String.valueOf(literal.getName()) + "(" + InterLinguaTools.getToken(literal.getArg1()) + ", " + InterLinguaTools.getToken(literal.getArg2()) + ")";
    }

    public static InterLinguaConclusion createConclusion(String name, String arg1, String arg2) {
        InterLinguaConclusion preAgent = new InterLinguaConclusion();
        preAgent.setName(name);
        preAgent.setArg1(arg1);
        preAgent.setArg2(arg2);
        return preAgent;
    }

    public static InterLinguaPrerequisite createPrerequisite(String name, String arg1, String arg2) {
        InterLinguaPrerequisite preAgent = new InterLinguaPrerequisite();
        preAgent.setName(name);
        preAgent.setArg1(arg1);
        preAgent.setArg2(arg2);
        return preAgent;
    }

    protected static String getToken(String token) {
        if (token.charAt(0) != '?') {
            StringBuffer bufferPar = new StringBuffer(20);
            bufferPar.append('\"');
            bufferPar.append(token);
            bufferPar.append('\"');
            return bufferPar.toString();
        }
        return token;
    }

    public static String getParamValue(List params, String paramName) {
        for (Param param : params) {
            if (!paramName.equalsIgnoreCase(param.getName())) continue;
            return param.getValue();
        }
        return null;
    }

    public static List translateReply(InterLinguaReply reply) {
        ArrayList<String> retList = new ArrayList<String>(100);
        if (reply.getPossibleReply().isEmpty()) {
            retList.add("Not provable.");
        } else {
            Iterator<PossibleReply> iter = reply.getPossibleReply().iterator();
            while (iter.hasNext()) {
                PossibleReply possReply = iter.next();
                if (possReply.getParam().isEmpty()) {
                    retList.add("True");
                } else {
                    for (Param param : possReply.getParam()) {
                        retList.add(String.valueOf(param.getName()) + " = " + param.getValue());
                    }
                }
                if (!iter.hasNext()) continue;
                retList.add("----------------------------------------");
            }
        }
        return retList;
    }
}

