/*
 * Decompiled with CFR 0.152.
 */
package across.util;

import across.data.Resource;
import java.util.HashMap;
import java.util.Map;

public class GoodsConstants {
    public static final String WATER = "water";
    public static final String GRAIN = "grain";
    public static final String BREAD = "bread";
    public static final String FISH = "fish";
    public static final String SHEEP = "sheep";
    public static final String FLOUR = "flour";
    public static final String DOCTORS = "doctors";
    public static final String MEDICAL_MATERIAL = "medical material";
    public static final String WOUNDED_PERSONS = "wounded person";
    public static final String HEALED_PERSONS = "healed person";
    public static final int NUMBER_OF_GOODS = 10;
    public static final int WATER_PRICE = 1;
    public static final int GRAIN_PRICE = 20;
    public static final int BREAD_PRICE = 3;
    public static final int FISH_PRICE = 8;
    public static final int SHEEP_PRICE = 50;
    public static final int FLOUR_PRICE = 15;
    public static final int DOCTORS_PRICE = 20;
    public static final int HEALED_PERSONS_PRICE = 10;
    public static final int WOUNDED_PERSONS_PRICE = 0;
    public static final int MEDICAL_MATERIAL_PRICE = 10;
    public static final String TYPE_BOXED = "boxed";
    public static final String TYPE_POWDER = "powder";
    public static final String TYPE_LIQUID = "liquid";
    public static final String TYPE_AMBULANCE = "ambulance";
    public static final String TYPE_NOT_MOVEABLE = "not moveable";
    public static final String[] TYPES = new String[]{"boxed", "liquid", "powder", "ambulance", "not moveable"};
    public static final String[] TYPES_EXAMPLES = new String[]{"water", "grain", "fish", "doctors", "wounded person"};

    public static String resolveType(String commodityName) {
        if (commodityName.equalsIgnoreCase(WATER)) {
            return TYPE_LIQUID;
        }
        if (commodityName.equalsIgnoreCase(GRAIN) || commodityName.equalsIgnoreCase(FLOUR)) {
            return TYPE_POWDER;
        }
        if (commodityName.equalsIgnoreCase(DOCTORS) || commodityName.equalsIgnoreCase(HEALED_PERSONS)) {
            return TYPE_AMBULANCE;
        }
        if (commodityName.equalsIgnoreCase(WOUNDED_PERSONS)) {
            return TYPE_NOT_MOVEABLE;
        }
        return TYPE_BOXED;
    }

    public static byte getTypeIndex(String typeName) {
        if (typeName.equalsIgnoreCase(TYPE_BOXED)) {
            return 0;
        }
        if (typeName.equalsIgnoreCase(TYPE_LIQUID)) {
            return 1;
        }
        if (typeName.equalsIgnoreCase(TYPE_AMBULANCE)) {
            return 3;
        }
        if (typeName.equalsIgnoreCase(TYPE_NOT_MOVEABLE)) {
            return 4;
        }
        return 2;
    }

    public static int getCommodityPrice(String commodityName) {
        if (commodityName.equalsIgnoreCase(WATER)) {
            return 1;
        }
        if (commodityName.equalsIgnoreCase(GRAIN)) {
            return 20;
        }
        if (commodityName.equalsIgnoreCase(BREAD)) {
            return 3;
        }
        if (commodityName.equalsIgnoreCase(FISH)) {
            return 8;
        }
        if (commodityName.equalsIgnoreCase(SHEEP)) {
            return 50;
        }
        if (commodityName.equalsIgnoreCase(FLOUR)) {
            return 15;
        }
        if (commodityName.equalsIgnoreCase(DOCTORS)) {
            return 20;
        }
        if (commodityName.equalsIgnoreCase(HEALED_PERSONS)) {
            return 10;
        }
        if (commodityName.equalsIgnoreCase(MEDICAL_MATERIAL)) {
            return 10;
        }
        return 0;
    }

    public static Map<String, Resource> getCargoTypesResourceMap() {
        HashMap<String, Resource> map = new HashMap<String, Resource>();
        int i = 0;
        while (i < TYPES.length) {
            String type = TYPES[i];
            Resource res = new Resource();
            res.setType(type);
            res.setCapacity(0L);
            map.put(type, res);
            ++i;
        }
        return map;
    }
}

