/*
 * Decompiled with CFR 0.152.
 */
package across.simulation.weather;

import across.data.Disaster;
import across.data.DisasterArea;
import across.data.DisasterAreaConfig;
import across.data.DisasterConfig;
import across.data.Effect;
import across.data.Weather;
import across.simulation.weather.WeatherAgentGUI;
import across.util.XMLtools;
import aglobe.container.agent.Agent;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.server.GISServerService;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobex.simulation.global.ServerServerTopicConstants;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.Param;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WeatherAgent
extends Agent
implements MessageConstants,
GISTopicServerListener,
ServerServerTopicConstants {
    public static final String TYPE = "WeatherAgent";
    private GISServerService.Shell gisMaster;
    private LinkedHashMap<String, List<String>> subscribedContainers = new LinkedHashMap();
    private DisasterAreaConfig disasterArea;
    private DisasterConfig disasterConfig;
    private int time = 0;
    public WeatherAgentGUI gui = new WeatherAgentGUI(this);
    private Configuration conf;
    private long lastTimeWeatherUpdated = -1L;
    private long updatePeriod = 1000L;

    @Override
    public void init(AgentInfo a, int initState) {
        super.init(a, initState);
        this.gisMaster = (GISServerService.Shell)this.getContainer().getServiceManager().getService(this, "gis/master");
        if (this.gisMaster == null) {
            this.logger.severe("GISServer service not found!!!");
            this.stop();
            return;
        }
        this.gisMaster.subscribeTopic("SIMULATION_TIME_UPDATE", this);
        this.gisMaster.subscribeTopic("TOPIC_WEATHER_UPDATE_REQUEST", this);
        this.gisMaster.subscribeTopic("CONFIGURATION", this);
        this.gisMaster.subscribeTopic("CONFIGURATION_OBJECT", this);
        this.gisMaster.sendTopicToLocal("CONFIGURATION_REQUEST", null, this.getName());
        this.gui.setTitle(a.getReadableName());
        this.gui.setBounds(0, 0, 400, 280);
        this.gui.setVisible(true);
        this.gui.log("LOGIN:");
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
        this.subscribedContainers.remove(remoteContainerName);
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if ("CONFIGURATION".equalsIgnoreCase(topic)) {
            this.conf = (Configuration)content;
            for (Param par : this.conf.getParam()) {
                if (par.getName().equals("DISASTER_AREA")) {
                    this.gisMaster.sendTopicToLocal("CONFIGURATION_OBJECT_REQUEST", new String[]{par.getValue(), "across.data.DisasterAreaConfig"}, this.getName());
                    continue;
                }
                if (!par.getName().equals("DISASTER_CONFIG")) continue;
                this.gisMaster.sendTopicToLocal("CONFIGURATION_OBJECT_REQUEST", new String[]{par.getValue(), "across.data.DisasterConfig"}, this.getName());
            }
        } else if ("SIMULATION_TIME_UPDATE".equalsIgnoreCase(topic)) {
            long time = Long.parseLong((String)content);
            if (this.lastTimeWeatherUpdated == -1L || time - this.lastTimeWeatherUpdated >= this.updatePeriod) {
                this.lastTimeWeatherUpdated = time;
                this.nextTurn();
            }
        } else if ("CONFIGURATION_OBJECT".equalsIgnoreCase(topic)) {
            if (content instanceof DisasterConfig) {
                this.disasterConfig = (DisasterConfig)content;
            } else if (content instanceof DisasterAreaConfig) {
                this.disasterArea = (DisasterAreaConfig)content;
            }
        } else if (topic.equals("TOPIC_WEATHER_UPDATE_REQUEST")) {
            this.gui.log("Container name: " + remoteContainerName);
            if (!this.subscribedContainers.containsKey(remoteContainerName)) {
                LinkedList<String> areaName = new LinkedList<String>();
                for (DisasterArea area : this.disasterArea.getDisasterArea()) {
                    List<String> areaContainers = area.getContainerName();
                    for (String object : areaContainers) {
                        String contName = object;
                        if (!contName.equalsIgnoreCase(remoteContainerName)) continue;
                        areaName.add(area.getName());
                    }
                }
                this.subscribedContainers.put(remoteContainerName, areaName);
            }
        }
    }

    private void nextTurn() {
        if (this.disasterConfig == null || this.disasterArea == null) {
            return;
        }
        ++this.time;
        this.gui.log("\n******\nTime: " + this.time + "\n******");
        for (Map.Entry<String, List<String>> cName : this.subscribedContainers.entrySet()) {
            List<String> areaName = cName.getValue();
            Weather weather = new Weather();
            weather.getParam().add(XMLtools.makeParam("fish", "1"));
            weather.getParam().add(XMLtools.makeParam("grain", "1"));
            weather.getParam().add(XMLtools.makeParam("sheep", "1"));
            weather.getParam().add(XMLtools.makeParam("water", "1"));
            for (Disaster disaster : this.disasterConfig.getDisaster()) {
                for (String disAr : disaster.getAreaName()) {
                    for (String area : areaName) {
                        int start = (int)Math.floor(Double.parseDouble(disaster.getStart()));
                        int end = (int)Math.floor(Double.parseDouble(disaster.getEnd()));
                        if (!area.equalsIgnoreCase(disAr) || this.time % start > end) continue;
                        this.gui.log("Disaster " + disaster.getName().toUpperCase() + " for location " + cName.getKey());
                        for (Effect paramu : disaster.getEffect()) {
                            for (across.data.Param pa : paramu.getParam()) {
                                for (across.data.Param paW : weather.getParam()) {
                                    if (!paW.getName().equalsIgnoreCase(pa.getName()) || !(Double.parseDouble(pa.getValue()) < Double.parseDouble(paW.getValue()))) continue;
                                    paW.setValue(pa.getValue());
                                }
                            }
                        }
                        for (DisasterArea dArea : this.disasterArea.getDisasterArea()) {
                            if (!dArea.getName().equals(disAr)) continue;
                            for (String dAr : dArea.getContainerName()) {
                                this.gisMaster.sendTopicToLocal("TOPIC_DISASTER_VISIBILITY", new DisasterVisibilityParams(dAr, disaster.getVisibilityRadius(), disaster.getVisibilityFailurePct()));
                                if ((double)this.time == Double.parseDouble(disaster.getStart())) {
                                    this.gisMaster.sendTopic(dAr, "TOPIC_DISASTER_VISIBILITY", disaster.getName().toUpperCase(), "WEATHER_DISASTER_START");
                                    continue;
                                }
                                if ((double)this.time == Double.parseDouble(disaster.getEnd())) {
                                    this.gisMaster.sendTopic(dAr, "TOPIC_DISASTER_VISIBILITY", disaster.getName().toUpperCase(), "WEATHER_DISASTER_END");
                                    continue;
                                }
                                this.gisMaster.sendTopic(dAr, "TOPIC_DISASTER_VISIBILITY", disaster.getName().toUpperCase(), "WEATHER_DISASTER_IS");
                            }
                        }
                    }
                }
            }
            this.gisMaster.sendTopic(cName.getKey(), "TOPIC_WEATHER_UPDATE", weather);
            this.gui.log("Sent restriction for location " + cName.getKey());
            for (Serializable serializable : weather.getParam()) {
                across.data.Param wp = (across.data.Param)serializable;
                this.gui.log("\t" + wp.getName() + " : " + wp.getValue());
            }
        }
    }

    @Override
    public void handleIncomingMessage(Message msg) {
    }

    public void killPressed() {
        this.stop();
    }

    public static class DisasterVisibilityParams {
        String AffectedContainer;
        double VisibilityRadius;
        double VisibilityFailurePct;

        public DisasterVisibilityParams(String affectedContainer, double visibilityRadius, double visibilityFailurePct) {
            this.AffectedContainer = affectedContainer;
            this.VisibilityRadius = visibilityRadius;
            this.VisibilityFailurePct = visibilityFailurePct;
        }

        public String getAffectedContainer() {
            return this.AffectedContainer;
        }

        public double getVisibilityFailurePct() {
            return this.VisibilityFailurePct;
        }

        public double getVisibilityRadius() {
            return this.VisibilityRadius;
        }
    }
}

