/*
 * Decompiled with CFR 0.152.
 */
package across.simulation.objects;

import across.data.simulation.EffectOnSimulationObject;
import across.data.simulation.SimulationObjectDescription;
import aglobe.container.transport.Address;
import aglobe.service.gis.server.GISTopicServerListener;
import aglobe.util.AglobeXMLtools;
import aglobe.visio3D.PlanUpdate;
import aglobe.visio3D.ontology.Chart;
import aglobex.simulation.entitysimulator.ControlLink;
import aglobex.simulation.entitysimulator.EntityBehaviour;
import aglobex.simulation.entitysimulator.EntityState;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.WorldDimension;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;
import aglobex.vecmath.Point3d;
import java.util.LinkedHashMap;

public class ObjectBehaviour
implements EntityBehaviour,
GISTopicServerListener {
    private EntityState myState;
    private double x;
    private double y;
    private double z;
    private ControlLink controlLink;
    private SimulationObjectDescription sod;
    private EntityRecord entityRecord;
    private long lastVisioUpdate = 0L;
    private boolean active = true;
    private long activeTime = 0L;
    private boolean terroristCreated = false;
    private long timeToCreateTer = 50000L;

    @Override
    public void control(Object content, String reason) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void entityCrashed(EntityBehaviour otherObject, long fromTime) {
    }

    @Override
    public PlanUpdate getPlanUpdate(boolean removeOld) {
        return null;
    }

    @Override
    public void init(ControlLink controlLink, EntityRecord entityRecord, WorldDimension worldDimesion) throws Exception {
        this.controlLink = controlLink;
        this.entityRecord = entityRecord;
        this.sod = (SimulationObjectDescription)entityRecord.entityDescriptor.confObjects.get("SIMULATION_OBJECT_DESCRIPTION");
        this.x = this.sod.getX();
        this.y = this.sod.getY();
        this.z = this.sod.getZ();
        Point3d p = new Point3d(this.x, this.y, this.z);
        this.myState = new EntityState();
        this.myState.position = p;
        controlLink.getGISShell().sendTopicToLocal("VISIO_INFO", entityRecord.containerName, entityRecord.containerName);
        controlLink.getGISShell().subscribeTopic("TOPIC_SIMULATION_OBJECT", this);
    }

    @Override
    public EntityState updateEntityState(long timeStep, long currentSimulationTimestamp) {
        this.activeTime += timeStep;
        if (currentSimulationTimestamp - this.lastVisioUpdate >= 1000L) {
            Chart chart = new Chart();
            chart.getContent().add(AglobeXMLtools.makeSimpleBar("Insurgency", this.getColorForNumber(this.sod.getInsurgencyLevel()), (byte)(this.sod.getInsurgencyLevel() * 255 / 100)));
            chart.getContent().add(AglobeXMLtools.makeSimpleBar("Damage", this.getColorForNumber(this.sod.getConstructionDamage()), (byte)(this.sod.getConstructionDamage() * 255 / 100)));
            chart.getContent().add(AglobeXMLtools.makeSimpleBar("Fire", this.getColorForNumber(this.sod.getExtentOfFire()), (byte)(this.sod.getExtentOfFire() * 255 / 100)));
            chart.getContent().add(AglobeXMLtools.makeSimpleBar("Wounded", this.getColorForNumber(this.sod.getNumberOfWounded()), (byte)(this.sod.getNumberOfWounded() * 255 / 100)));
            this.controlLink.getGISShell().sendTopicToLocal("SET_CHART", chart, this.entityRecord.containerName);
            this.lastVisioUpdate = currentSimulationTimestamp;
        }
        if (this.sod.getInsurgencyLevel() >= 30 && this.activeTime >= this.timeToCreateTer && !this.terroristCreated) {
            this.terroristCreated = true;
            String location = this.getCloserLocation();
            if (location != null) {
                this.controlLink.getGISShell().sendTopicToLocal("TOPIC_AGENT", this.newTerrorist(location), "CREATE_AGENT");
            }
        }
        return this.myState;
    }

    private byte getColorForNumber(int number) {
        if (number >= 66) {
            return 1;
        }
        if (number >= 33) {
            return 5;
        }
        return 2;
    }

    @Override
    public void handleLoginTopic(String topic, String remoteContainerName, Address remoteContainerAddress) {
    }

    @Override
    public void handleLogoutTopic(String topic, String remoteContainerName) {
    }

    @Override
    public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
        if (topic.equalsIgnoreCase("TOPIC_SIMULATION_OBJECT")) {
            if (reason.equalsIgnoreCase("SIMULATION_OBJECT_DESCRIPTION") && content.equals(this.entityRecord.containerName)) {
                if (this.active) {
                    this.controlLink.getGISShell().sendTopic(remoteContainerName, "TOPIC_SIMULATION_OBJECT", this.sod, "SIMULATION_OBJECT_DESCRIPTION");
                }
            } else if (reason.equalsIgnoreCase("CONTROL_CHANGE_SIMULATION_OBJECT")) {
                EffectOnSimulationObject eff = (EffectOnSimulationObject)content;
                if (eff.objectName.equals(this.entityRecord.containerName)) {
                    this.active = this.applyEffect(eff);
                    if (!this.active) {
                        System.out.println("+++++++++++++ OBJECT" + this.entityRecord.containerName + " REMOVED ++++++++++++++++++");
                        this.controlLink.destroyEntity();
                    }
                }
            }
        }
    }

    @Override
    public void addEvent(Runnable e) {
        if (!this.active) {
            return;
        }
        this.controlLink.addEvent(e);
    }

    protected boolean applyEffect(EffectOnSimulationObject effect) {
        boolean damage = this.sod.adjustConstructionDamage(effect.constructionDamageDiff);
        boolean fire = this.sod.adjustFireExtent(effect.fireDiff);
        boolean insrg = this.sod.adjustInsurgencyLevel(effect.insurgencyDiff);
        boolean wound = this.sod.adjustNumberOfWounded(effect.woundedDiff);
        return !damage || !fire || !insrg || !wound;
    }

    protected EntityRecord newTerrorist(String location) {
        EntityRecord er = new EntityRecord();
        EntityDescriptor ed = new EntityDescriptor();
        EntityTypeDescriptor etd = new EntityTypeDescriptor();
        etd.typeName = "TERRORIST_DRIVER_ENTITY_TYPE";
        ed.confParamsString = new LinkedHashMap();
        ed.confParamsString.put("ENTITY_START_NODE", location);
        ed.confParamsString.put("ENTITY_VISIO_NAME", "" + System.currentTimeMillis());
        ed.confParamsString.put("ENTITY_VISIO_OBJECT", "CAR");
        ed.confParamsString.put("ENTITY_VISIO_TEXTURE", "TEXTURE_CAR_KABINA_TEXTURE05");
        ed.confParamsString.put("VEHICLE_VELOCITY", "0.100000");
        ed.confParamsString.put("VEHICLE_CONSUMPTION", "23");
        ed.confParamsString.put("VEHICLE_CAPACITY", "1000");
        ed.typeDescriptor = etd;
        er.entityDescriptor = ed;
        return er;
    }

    protected String getCloserLocation() {
        String loc1 = this.sod.getLocation().endLocation;
        String loc2 = this.sod.getLocation().startLocation;
        if (loc1.indexOf("Node") != -1) {
            return loc1;
        }
        if (loc2.indexOf("Node") != -1) {
            return loc2;
        }
        return null;
    }
}

