/*
 * Decompiled with CFR 0.152.
 */
package across.simulation;

import across.data.simulation.SimulationObject;
import across.data.simulation.SimulationObjectDescription;
import across.data.simulation.SimulationObjectsConfiguration;
import aglobe.container.transport.Address;
import aglobe.ontology.ContainerStartup;
import aglobe.service.gis.server.GISTopicServerListenerWithoutLogin;
import aglobex.simulation.entitymanager.ScenarioControl;
import aglobex.simulation.entitymanager.ScenarioPlayer;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.Configuration;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.ontology.entity.EntityTypeDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class AcrossScenarioPlayer
implements ScenarioPlayer {
    private ScenarioControl scenarioControl;
    private SimulationObjectsConfiguration objConf;
    private int indexToSlotArray = 0;
    private List<EntityRecord> obstacleList = new ArrayList<EntityRecord>();
    private Configuration configuration;
    private List<String> removedEntities = new LinkedList<String>();

    @Override
    public void configurationUpdated(Configuration newConfiguration, HashMap<String, String> paramsString, HashMap<String, Double> paramsDouble, HashMap<String, Integer> paramsInteger, HashMap<String, Boolean> paramsBoolean, HashMap<String, Long> paramsLong, HashMap<String, InputStream> files, HashMap<String, Object> objects) {
        this.objConf = (SimulationObjectsConfiguration)objects.get("SIMULATION_OBJECTS_CONFIGURATION");
        this.configuration = newConfiguration;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void endOfScenario(long endTime) {
    }

    @Override
    public void setScenarioControl(ScenarioControl scenarioControl) {
        this.scenarioControl = scenarioControl;
        scenarioControl.getGISShell().subscribeTopic("TOPIC_SIMULATION_OBJECT", new GISTopicServerListenerWithoutLogin(){

            @Override
            public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                if (reason.equalsIgnoreCase("CONTROL_CREATE_SIMULATION_OBJECT")) {
                    SimulationObject sobj = (SimulationObject)content;
                    AcrossScenarioPlayer.this.spawnSimulationObject(sobj);
                }
            }

            @Override
            public void addEvent(Runnable e) {
                AcrossScenarioPlayer.this.scenarioControl.getOwnerAgent().addEvent(e);
            }
        });
        scenarioControl.getGISShell().subscribeTopic("TOPIC_AGENT", new GISTopicServerListenerWithoutLogin(){

            @Override
            public void handleTopic(String topic, Object content, String reason, String remoteContainerName, Address remoteClientAddress) {
                if (reason.equalsIgnoreCase("CREATE_AGENT")) {
                    EntityRecord er = (EntityRecord)content;
                    AcrossScenarioPlayer.this.spawnSimulationAgent(er);
                } else if (reason.equalsIgnoreCase("REMOVE_AGENT")) {
                    AcrossScenarioPlayer.this.removeEntity((String)content);
                }
            }

            @Override
            public void addEvent(Runnable e) {
                AcrossScenarioPlayer.this.scenarioControl.getOwnerAgent().addEvent(e);
            }
        });
    }

    @Override
    public void simulationTimestampUpdated(long time) {
    }

    @Override
    public void startReplay(long startTime) {
    }

    @Override
    public void startScenario(long startTime, boolean fastSimulation) {
        if (this.objConf != null) {
            if (this.objConf.getSimulationObjects() == null) {
                return;
            }
            for (SimulationObject sobj : this.objConf.getSimulationObjects()) {
                this.spawnSimulationObject(sobj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntity(String containerName) {
        List<String> list = this.removedEntities;
        synchronized (list) {
            if (!this.removedEntities.contains(containerName)) {
                this.removedEntities.add(containerName);
                this.scenarioControl.removeEntity(containerName);
            }
        }
    }

    protected void spawnSimulationAgent(EntityRecord er) {
        if (er.entityDescriptor.typeDescriptor.typeName.equals("TERRORIST_DRIVER_ENTITY_TYPE")) {
            Address a;
            EntityRecord terer = this.scenarioControl.getRunningEntityRecord("Terrorist");
            String name = "Terrorist" + this.indexToSlotArray;
            er.address = a = Address.getAgentAddress(this.scenarioControl.getOwnerAgent().getAddress().getHost(), this.scenarioControl.getOwnerAgent().getAddress().getPort(), name, name);
            er.containerName = name;
            er.indexToSlotArray = this.indexToSlotArray++;
            er.platform = terer.platform;
            er.entityDescriptor.typeDescriptor = terer.entityDescriptor.typeDescriptor;
        }
        String agentMain = null;
        if (er.entityDescriptor.typeDescriptor.typeName.equals("TERRORIST_DRIVER_ENTITY_TYPE")) {
            agentMain = "across.agents.terrorists.driver.TerroristDriverAgent";
        }
        ContainerStartup cs = new ContainerStartup();
        cs.addAgent(er.containerName, agentMain, new ArrayList<String>(), new LinkedHashMap<String, String>());
        try {
            this.scenarioControl.crateNewEntity(er, cs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void spawnSimulationObject(SimulationObject so) {
        try {
            EntityRecord er = this.simObjectER(so);
            this.scenarioControl.crateNewEntity(er, null);
            this.obstacleList.add(er);
        }
        catch (Exception e) {
            this.scenarioControl.logSevere("Unable to start object: " + so.getSimulationObjectDescription().getName());
            e.printStackTrace();
        }
    }

    private EntityRecord simObjectER(SimulationObject so) {
        EntityDescriptor ed = new EntityDescriptor();
        ed.typeDescriptor = new EntityTypeDescriptor();
        ed.typeDescriptor.simulationClass = so.getSimulationClass();
        ed.typeDescriptor.typeName = "SIMULATION_OBJECT_TYPE";
        ed.typeDescriptor.crashRange = 0.0;
        SimulationObjectDescription sod = so.getSimulationObjectDescription();
        String objName = sod.getName();
        ed.confParamsString = new LinkedHashMap();
        ed.confParamsString.put("ENTITY_VISIO_NAME", objName);
        ed.confParamsString.put("ENTITY_VISIO_OBJECT", "CAR");
        ed.confParamsString.put("ENTITY_VISIO_TEXTURE", "TEXTURE_CAR_KABINA_TEXTURE05");
        ed.confObjects = new LinkedHashMap();
        ed.confObjects.put("SIMULATION_OBJECT_DESCRIPTION", sod);
        EntityRecord er = new EntityRecord();
        er.entityDescriptor = ed;
        er.containerName = objName;
        er.indexToSlotArray = this.indexToSlotArray++;
        return er;
    }
}

