/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.util.checker;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.util.checker.RestrictionsChecker;
import across.data.Page;
import across.data.Resource;
import across.data.TransportCfp;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;

public class JavaRestrictionsChecker
implements RestrictionsChecker {
    TransporterAgent owner;
    RestrictionsChecker compiledRestrictionsChecker = null;

    public JavaRestrictionsChecker(TransporterAgent owner) {
        this.owner = owner;
    }

    @Override
    public void loadRestrictions(String filePath, AgentInfo agentInfo) {
        String rulesFile = "test/privateJava.txt";
        String importFile = "test/privateJavaImports.txt";
        String className = String.valueOf(this.owner.getName()) + "Restrictions";
        String javaFilePath = "cache/across/transporter/";
        new File(javaFilePath).mkdirs();
        String javaFile = String.valueOf(javaFilePath) + className + ".java";
        try {
            this.createJavaFile(importFile, rulesFile, javaFile, className);
            this.compile(javaFile);
            this.compiledRestrictionsChecker = this.loadClass(className);
        }
        catch (Exception ex) {
            this.owner.getLogger().severe("Cannot initialize JavaRestrictionsChecker: " + ex);
        }
        this.compiledRestrictionsChecker.loadRestrictions(filePath, agentInfo);
    }

    private RestrictionsChecker loadClass(String className) {
        ClassLoader classLoader = new ClassLoader(){

            private byte[] getBytes(String filename) throws IOException {
                File file = new File(filename);
                FileInputStream fin = new FileInputStream(file);
                long len = file.length();
                byte[] raw = new byte[(int)len];
                int r = fin.read(raw);
                if ((long)r != len) {
                    throw new IOException("Can't read all, " + r + " != " + len);
                }
                fin.close();
                return raw;
            }

            public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> clas = null;
                clas = this.findLoadedClass(name);
                String fileStub = name.replace('.', '/');
                String classFilename = "cache/" + fileStub + ".class";
                File classFile = new File(classFilename);
                try {
                    byte[] raw = this.getBytes(classFilename);
                    clas = this.defineClass(name, raw, 0, raw.length);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (clas == null) {
                    clas = this.findSystemClass(name);
                }
                if (resolve && clas != null) {
                    this.resolveClass(clas);
                }
                if (clas == null) {
                    throw new ClassNotFoundException(name);
                }
                return clas;
            }
        };
        Class<?> clas = null;
        RestrictionsChecker rc = null;
        try {
            clas = classLoader.loadClass("across.transporter." + className);
            rc = (RestrictionsChecker)clas.getConstructor(TransporterAgent.class).newInstance(this.owner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rc;
    }

    void createJavaFile(String imports, String rules, String java, String className) throws IOException {
        int len;
        FileInputStream rulesStream = new FileInputStream(rules);
        FileInputStream importsStream = new FileInputStream(imports);
        FileOutputStream out = new FileOutputStream(java);
        ((OutputStream)out).write("package across.transporter;\n \n".getBytes());
        ((OutputStream)out).write("import across.skn.AgentKnowledge;\n".getBytes());
        ((OutputStream)out).write("import aglobe.container.transport.Address;\n".getBytes());
        ((OutputStream)out).write("import across.data.Page;\n".getBytes());
        ((OutputStream)out).write("import across.data.TransportCfp;\n \n".getBytes());
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)importsStream).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).write(("\n public class " + className + " implements RestrictionsChecker{\n").getBytes());
        ((OutputStream)out).write("    TransporterAgent owner;\n".getBytes());
        ((OutputStream)out).write("\n".getBytes());
        ((OutputStream)out).write(("    public " + className + "(TransporterAgent owner) {\n").getBytes());
        ((OutputStream)out).write("        this.owner = owner;\n".getBytes());
        ((OutputStream)out).write("    }\n".getBytes());
        ((OutputStream)out).write("\n".getBytes());
        while ((len = ((InputStream)rulesStream).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)rulesStream).close();
        ((InputStream)importsStream).close();
        ((OutputStream)out).write("\n} \n".getBytes());
        ((OutputStream)out).close();
    }

    private void compile(String javaFile) throws IOException, InterruptedException {
        String command = "javac -classpath ./classes;./lib/JTP/lib/antlr.jar;./lib/JTP/lib/icu4j.jar;./lib/JTP/lib/jakarta-oro-2.0.5.jar;./lib/JTP/lib/jdom.jar;./lib/JTP/lib/jena.jar;./lib/JTP/lib/jtp.jar;./lib/JTP/lib/log4j.jar;./lib/JTP/lib/xercesImpl.jar;./lib/JTP/lib/xmlParserAPIs.jar;./lib/JPL/jpl.jar;./lib/JUnit/junit.jar;./lib/JBCL/jbcl.jar;../aglobe/classes;../aglobe/libs/FileInputTextField.jar;../ontology/libs/jaxb-rt-1.0-ea.jar;../ontology/classes " + javaFile;
        System.out.println("compiling : " + command);
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor();
    }

    @Override
    public boolean acceptAllianceMember(AgentKnowledge member) {
        if (this.compiledRestrictionsChecker == null) {
            throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
        }
        return this.compiledRestrictionsChecker.acceptAllianceMember(member);
    }

    @Override
    public boolean acceptRequestedServices(TransportCfp requestedServices) {
        if (this.compiledRestrictionsChecker == null) {
            throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
        }
        return this.compiledRestrictionsChecker.acceptRequestedServices(requestedServices);
    }

    @Override
    public boolean acceptTeamLeader(Address teamLeader) {
        if (this.compiledRestrictionsChecker == null) {
            throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
        }
        return this.compiledRestrictionsChecker.acceptTeamLeader(teamLeader);
    }

    @Override
    public boolean acceptTeamMember(Address member) {
        if (this.compiledRestrictionsChecker == null) {
            throw new IllegalStateException("JavaRestrictionChecker is not initialized yet.");
        }
        return this.compiledRestrictionsChecker.acceptTeamMember(member);
    }

    @Override
    public void agentPageUpdated(Page page) {
    }

    @Override
    public Collection<String> getAvailableActions(Resource res) {
        return new LinkedList<String>();
    }
}

