/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.util.checker;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.util.checker.RestrictionsChecker;
import across.data.Node;
import across.data.Page;
import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.InterLinguaTools;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import java.util.Collection;
import java.util.LinkedList;

public class DebugRestrictionsChecker
implements RestrictionsChecker {
    TransporterAgent owner;
    int restrictionType = 0;
    String[] alliance = new String[]{"CheetahTransporter", "LlamaTransporter", "EagleTransporter", "WhaleTransporter", "CamelTransporter", "SnakeTransporter", "LionTransporter", "TigerTransporter"};

    public DebugRestrictionsChecker(TransporterAgent owner) {
        this.owner = owner;
    }

    @Override
    public boolean acceptAllianceMember(AgentKnowledge member) {
        String myRegion = this.getMyRegion();
        String memberRegion = this.getAgentRegion(member.getName());
        String memberTribe = this.getAgentTribe(member.getName());
        switch (this.restrictionType) {
            case 0: {
                boolean allOk = true;
                String[] stringArray = this.alliance;
                int n = 0;
                int n2 = stringArray.length;
                while (n < n2) {
                    String allMem = stringArray[n];
                    if (allMem.equals(this.owner.getName())) {
                        boolean bl = allOk = !allOk;
                    }
                    if (allMem.equals(member.address.getName())) {
                        allOk = !allOk;
                    }
                    ++n;
                }
                return allOk;
            }
            case 1: {
                return myRegion.equals(memberRegion);
            }
        }
        return true;
    }

    @Override
    public boolean acceptTeamLeader(Address teamLeader) {
        return true;
    }

    @Override
    public boolean acceptRequestedServices(TransportCfp requestedServices) {
        for (TransportBatch batch : requestedServices.getTransportBatch()) {
            String startTribe = this.getCityTribe(batch.getStart());
            String targetTribe = this.getCityTribe(batch.getTarget());
            String startRegion = this.getCityRegion(batch.getStart());
            String targetRegion = this.getCityRegion(batch.getTarget());
            String myTribe = InterLinguaTools.getParamValue(this.owner.publicParams.getParam(), "tribe");
            String myRegion = InterLinguaTools.getParamValue(this.owner.publicParams.getParam(), "region");
            switch (this.restrictionType) {
                case 0: {
                    if (myTribe.equals("Northlanders") && targetTribe.equals("Southlanders")) {
                        return false;
                    }
                    if (myTribe.equals("Southlanders") && targetTribe.equals("Northlanders")) {
                        return false;
                    }
                    return myRegion.equals("Eastern") || !targetRegion.equals("Eastern");
                }
                case 1: {
                    if (myRegion.equals("Western") && !targetTribe.equals("Southlanders")) {
                        return false;
                    }
                    return myRegion.equals("Western") || !targetTribe.equals("Southlanders");
                }
            }
        }
        return true;
    }

    @Override
    public boolean acceptTeamMember(Address member) {
        String memberTribe = this.getAgentTribe(member.getName());
        String memberRegion = this.getAgentRegion(member.getName());
        String myTribe = InterLinguaTools.getParamValue(this.owner.publicParams.getParam(), "tribe");
        String myRegion = InterLinguaTools.getParamValue(this.owner.publicParams.getParam(), "region");
        switch (this.restrictionType) {
            case 0: {
                if ("HippoTransporter".equals(this.owner.getName())) {
                    return false;
                }
                if (!myTribe.equals("Southlanders") && memberTribe.equals("Southlanders")) {
                    return false;
                }
                return !myTribe.equals("Southlanders") || !memberTribe.equals("Northlanders");
            }
            case 1: {
                if (myRegion.equals("Western") && memberTribe.equals("Southlanders")) {
                    return false;
                }
                if (myRegion.equals("Western") || !memberTribe.equals("Northlanders")) break;
                return false;
            }
        }
        return true;
    }

    @Override
    public void agentPageUpdated(Page page) {
    }

    @Override
    public void loadRestrictions(String filePath, AgentInfo agentInfo) {
        for (AglobeParam item : agentInfo.getAglobeParam()) {
            if (!item.getName().equals("debugRestrictionType")) continue;
            this.restrictionType = Integer.parseInt(item.getValue());
            break;
        }
    }

    private String getMyRegion() {
        return this.getMyParam("region");
    }

    private String getMyParam(String paramName) {
        return InterLinguaTools.getParamValue(this.owner.publicParams.getParam(), paramName);
    }

    private String getAgentLocation(String agentName) {
        return InterLinguaTools.getParamValue(this.owner.getCommunity().getAgent((String)agentName).publicParams.getParam(), "location");
    }

    private String getAgentTribe(String agentName) {
        return this.getCityTribe(this.getAgentLocation(agentName));
    }

    private String getAgentRegion(String agentName) {
        return this.getCityRegion(this.getAgentLocation(agentName));
    }

    private String getCityTribe(String cityName) {
        return this.getCityParam(cityName, "tribe");
    }

    private String getCityRegion(String cityName) {
        return this.getCityParam(cityName, "region");
    }

    private String getCityParam(String cityName, String paramName) {
        for (Node node : this.owner.acrossMapNodes.getNode()) {
            if (!node.getName().equals(cityName)) continue;
            return InterLinguaTools.getParamValue(node.getParam(), paramName);
        }
        return null;
    }

    private String getMyTribe() {
        return this.getMyParam("tribe");
    }

    @Override
    public Collection<String> getAvailableActions(Resource res) {
        return new LinkedList<String>();
    }
}

