/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.util.checker;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.util.checker.RestrictionsChecker;
import across.data.Page;
import across.data.Param;
import across.data.Possibility;
import across.data.PrivateParams;
import across.data.PublicParams;
import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.InterLinguaTools;
import across.util.XMLtools;
import across.util.skn.AgentKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DNFRestrictionsChecker
implements RestrictionsChecker {
    TransporterAgent owner;
    protected PrivateParams privateParams;

    public DNFRestrictionsChecker(TransporterAgent owner) {
        this.owner = owner;
    }

    public void setTransporterPrivateParams(PrivateParams pp) {
        this.privateParams = pp;
    }

    @Override
    public void loadRestrictions(String filePath, AgentInfo agentInfo) {
        this.owner.setupSemiPrivateFromPrivate();
        this.owner.gui.setPrivate(this.privateParams);
    }

    @Override
    public boolean acceptTeamLeader(Address teamLeader) {
        AgentKnowledge ak = this.owner.community.getAgent(teamLeader.getName());
        if (!teamLeader.equals(this.owner.getAddress())) {
            if (ak != null) {
                return DNFRestrictionsChecker.checkRestrictions(ak.publicParams.getParam(), this.privateParams.getCoalitionLeaderRestrictions().getPossibility());
            }
            this.owner.getLogger().info("Unknown agent wants to be coalition leader: " + this.owner.getName() + "->" + teamLeader);
            return false;
        }
        return true;
    }

    public static boolean checkRestrictions(List params, List possibilities) {
        for (Possibility possibility : possibilities) {
            boolean posMatches = true;
            for (Param param : possibility.getPositive().getParam()) {
                String name = param.getName();
                String value = param.getValue();
                if (value.equalsIgnoreCase(InterLinguaTools.getParamValue(params, name))) continue;
                posMatches = false;
                break;
            }
            if (!posMatches) continue;
            boolean negMatches = true;
            for (Param param : possibility.getNegative().getParam()) {
                String name = param.getName();
                String value = param.getValue();
                if (!value.equalsIgnoreCase(InterLinguaTools.getParamValue(params, name))) continue;
                negMatches = false;
                break;
            }
            if (!negMatches) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptTeamMember(Address member) {
        AgentKnowledge ak = this.owner.community.getAgent(member.getName());
        if (!member.equals(this.owner.getAddress())) {
            if (ak != null) {
                if (ak.publicParams == null) {
                    System.out.println("@@@ SUSPITIOUS: ak!=null, but publicParams==null -> publicParams unknown: DON'T ACCEPT AS TEAM MEMBER");
                    return false;
                }
                return DNFRestrictionsChecker.checkRestrictions(ak.publicParams.getParam(), this.privateParams.getCoalitionRestrictions().getPossibility());
            }
            this.owner.getLogger().info("Unknown agent wants to be coalition member: " + this.owner.getName() + "->" + member);
            return false;
        }
        return true;
    }

    @Override
    public boolean acceptAllianceMember(AgentKnowledge member) {
        PublicParams pi = member.publicParams;
        if (pi != null) {
            List<Param> p = pi.getParam();
            List<Possibility> pos = this.privateParams.getAllianceRestrictions().getPossibility();
            return DNFRestrictionsChecker.checkRestrictions(p, pos);
        }
        this.owner.getLogger().warning(String.valueOf(this.owner.getName()) + ": Public info not available for agent: " + member.address.getName());
        return false;
    }

    @Override
    public boolean acceptRequestedServices(TransportCfp requestedServices) {
        for (TransportBatch tb : requestedServices.getTransportBatch()) {
            LinkedList<Param> servicesProps = new LinkedList<Param>();
            servicesProps.add(XMLtools.makeParam("start", tb.getStart()));
            servicesProps.add(XMLtools.makeParam("target", tb.getTarget()));
            servicesProps.add(XMLtools.makeParam("comodityName", tb.getComodityName()));
            if (DNFRestrictionsChecker.checkRestrictions(servicesProps, this.privateParams.getCoalitionGoalRestrictions().getPossibility())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void agentPageUpdated(Page page) {
    }

    @Override
    public Collection<String> getAvailableActions(Resource res) {
        return new LinkedList<String>();
    }
}

