/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.util;

import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.GoodsConstants;
import java.util.Collection;
import java.util.Map;

public class TransporterUtils {
    public static Collection getRequestedResources(TransportCfp cfp, double securityCoeficient) {
        Map<String, Resource> capacities = GoodsConstants.getCargoTypesResourceMap();
        for (TransportBatch batch : cfp.getTransportBatch()) {
            Resource res = capacities.get(GoodsConstants.resolveType(batch.getComodityName()));
            res.setCapacity(res.getCapacity() + Math.round((double)batch.getCount() * securityCoeficient));
            res.setLastLocation(batch.getStart());
            res.setNextLocation(batch.getTarget());
            res.setLastLocationTime(batch.getStartTime());
            res.setAvailabilityTime(batch.getTargetTime());
        }
        return capacities.values();
    }
}

