/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.task;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.task.CNPTransportBidAnswer;
import across.agents.transporter.task.RequestMergeAllianceTask;
import across.agents.transporter.task.RequstJoinAllianceParticipantTask;
import across.agents.transporter.task.TransportAcceptedTask;
import across.data.AdvTeamProposal;
import across.data.Batch;
import across.data.CooperationResult;
import across.data.Page;
import across.data.Pages;
import across.data.Proposal;
import across.data.RequestList;
import across.data.SemiPrivateParams;
import across.data.TeamProposal;
import across.data.TransportCfp;
import across.data.TransportRequest;
import across.util.skn.AcrossCoalitionKnowledge;
import across.util.skn.AcrossCoalitionLeaderKnowledge;
import across.util.skn.AcrossCoalitionMemberKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobex.protocol.queryif.QueryIfParticipantTask;
import aglobex.protocol.queryref.QueryRefParticipantTask;
import aglobex.protocol.subscribe.SubscribeParticipantTask;
import java.util.HashSet;
import java.util.LinkedList;

public class TransporterIdleTask
extends Task {
    protected TransporterAgent myAgent;
    private HashSet<String> uniqueMessages = new HashSet();

    public TransporterIdleTask(TransporterAgent _myAgent) {
        super(_myAgent);
        this.myAgent = _myAgent;
    }

    @Override
    protected void handleIncomingMessage(Message msg) {
        String protocol = msg.getProtocol();
        if ("REQUEST".equalsIgnoreCase(protocol)) {
            this.handleRequestProtocol(msg);
        } else if ("INFORM".equalsIgnoreCase(protocol)) {
            this.handleInformProtocol(msg);
        } else if ("QUERY".equalsIgnoreCase(protocol)) {
            this.handleQueryProtocol(msg);
        } else if ("CONTRACT-NET".equalsIgnoreCase(protocol)) {
            this.handleCNPProtocol(msg);
        } else if ("SUBSCRIBE".equalsIgnoreCase(protocol)) {
            this.handleSubscribeProtocol(msg);
        } else {
            this.myAgent.getLogger().warning("!!!! unexpected message:" + msg);
            this.sendNotUnderstood(msg, "!!!! unexpected message:");
        }
    }

    private void handleSubscribeProtocol(Message msg) {
        if (msg.getSender() == this.myAgent.getAddress()) {
            return;
        }
        if ("PUBLIC_INFO_REQUEST".equals(msg.getContent())) {
            SubscribeParticipantTask task = new SubscribeParticipantTask(this.myAgent, msg, false){

                @Override
                protected void processSubscribe(Message subscribeMessage) {
                    Page pg = new Page();
                    pg.setName(TransporterIdleTask.this.myAgent.getAddress().getName());
                    pg.setAddress(TransporterIdleTask.this.myAgent.getAddress());
                    pg.setPublicParams(TransporterIdleTask.this.myAgent.publicParams);
                    this.informResult(pg);
                }
            };
            task.start();
            this.myAgent.publicSubscribers.add(task);
        } else if (msg.getContent() instanceof SemiPrivateParams) {
            AllianceKnowledge ak = this.myAgent.community.getAlliance(this.myAgent.myAlliance);
            AgentKnowledge senkn = this.myAgent.community.getAgent(msg.getSender().getName());
            if (ak != null && senkn != null && ak.containsMember(senkn)) {
                SubscribeParticipantTask task = new SubscribeParticipantTask(this.myAgent, msg, false){

                    @Override
                    protected void processSubscribe(Message subscribeMessage) {
                        AgentKnowledge senkn = TransporterIdleTask.this.myAgent.community.getAgent(subscribeMessage.getSender().getName());
                        if (senkn.semiPrivateParams == null) {
                            TransporterIdleTask.this.myAgent.subscribeAndSendSemiPrivateInfo(senkn.address);
                        }
                        TransporterIdleTask.this.myAgent.updateSemiPrivate(subscribeMessage.getSender(), (SemiPrivateParams)subscribeMessage.getContent());
                        this.informResult(TransporterIdleTask.this.myAgent.semiPrivateParams);
                    }

                    @Override
                    public void informResult(Object result) {
                        AllianceKnowledge ak = TransporterIdleTask.this.myAgent.community.getAlliance(TransporterIdleTask.this.myAgent.myAlliance);
                        AgentKnowledge senkn = TransporterIdleTask.this.myAgent.community.getAgent(this.subscribeMessage.getSender().getName());
                        if (ak != null && senkn != null && ak.containsMember(senkn)) {
                            super.informResult(result);
                        }
                    }
                };
                task.start();
                this.myAgent.semiPrivateSubscribers.add(task);
            }
        } else {
            this.handleGeneralSubscribe(msg);
        }
    }

    protected void handleGeneralSubscribe(Message msg) {
        this.sendNotUnderstood(msg, "Wrong Performative or Content");
    }

    public void handleCNPProtocol(Message msg) {
        if (!"CONTRACT-NET".equalsIgnoreCase(msg.getProtocol())) {
            return;
        }
        String performative = msg.getPerformative();
        Object content = msg.getContent();
        if ("CFP".equalsIgnoreCase(performative) && content instanceof TransportCfp) {
            if (!this.myAgent.receivedCFP(msg, null)) {
                new CNPTransportBidAnswer(this.myAgent, 50000, msg);
            }
        } else {
            this.handleGeneralCNP(msg);
        }
    }

    protected void handleGeneralCNP(Message msg) {
        this.sendNotUnderstood(msg, "Wrong Performative or Content");
    }

    private void handleRequestProtocol(Message msg) {
        Object content = msg.getContent();
        if (msg.getPerformative().equalsIgnoreCase("INFORM-DONE") && msg.getContent() instanceof RequestList) {
            RequestList rl = (RequestList)content;
            AcrossCoalitionKnowledge c = this.myAgent.community.getCoalition(rl.getRequestid());
            if (c != null) {
                c.transportCompleted(rl);
            } else {
                this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + ": Task completion for unknown coalition by driver: " + msg.getSender() + " Task: " + rl);
            }
        } else if (msg.getPerformative().equalsIgnoreCase("INFORM-DONE") && msg.getContent() instanceof Batch) {
            if (this.uniqueMessages.contains(msg.getConversationID())) {
                return;
            }
            this.uniqueMessages.add(msg.getConversationID());
            Batch batch = (Batch)content;
            AcrossCoalitionKnowledge c = this.myAgent.community.getCoalition(msg.getReason());
            if (c != null) {
                c.transportCompleted(batch);
            } else {
                this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + ": Task completion for unknown coalition by driver: " + msg.getSender() + " Task: " + batch);
            }
        } else if (msg.getPerformative().equalsIgnoreCase("FAILURE") && content instanceof RequestList) {
            RequestList rl = (RequestList)content;
            if (rl.getRequestTime() == -1L) {
                rl.setDeliveryLocation(rl.getDeliveryAddress().getName());
                msg.setContent(rl);
            }
            Message fail = Message.newInstance("FAILURE", this.myAgent.getAddress(), rl.getDeliveryAddress());
            fail.setProtocol("REQUEST");
            fail.setContent(rl);
            try {
                this.sendMessage(fail);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            AcrossCoalitionKnowledge c = this.myAgent.community.getCoalition(rl.getRequestid());
            if (c != null) {
                c.transportFailed(rl);
            } else {
                this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + ": Task failure for unknown coalition by driver: " + msg.getSender() + " Task: " + rl);
            }
        } else if (!msg.getPerformative().equalsIgnoreCase("AGREE")) {
            if (msg.getPerformative().equalsIgnoreCase("REQUEST")) {
                if (content instanceof TransportRequest) {
                    new TransportAcceptedTask(this.myAgent, msg, false);
                } else if (content instanceof Page) {
                    RequstJoinAllianceParticipantTask task = new RequstJoinAllianceParticipantTask(this.myAgent, msg);
                    task.start();
                } else if (content instanceof String) {
                    AllianceKnowledge ak = this.myAgent.community.getAlliance((String)content);
                    Message m = msg.getReply();
                    if (this.myAgent.allianceAcceptable(ak)) {
                        m.setPerformative("INFORM-DONE");
                    } else {
                        m.setPerformative("INFORM-RESULT");
                    }
                    try {
                        this.sendMessage(m);
                    }
                    catch (InvisibleContainerException invisibleContainerException) {}
                } else if (content instanceof Pages) {
                    new RequestMergeAllianceTask(this.myAgent, msg);
                } else if (content instanceof Address) {
                    Address kickedAllianceMember = (Address)content;
                    if (this.myAgent.getAddress().equals(kickedAllianceMember)) {
                        AllianceKnowledge ak = this.myAgent.community.getAlliance(this.myAgent.myAlliance);
                        ak.removeMember(this.myAgent.community.getOwnerAgentKnowledge());
                        this.myAgent.community.getOwnerAgentKnowledge().alliance = null;
                        this.myAgent.createNewAlliance();
                        this.myAgent.gisShell.submitTopicToServer("VISIO_ACTION", Byte.toString((byte)74), this.myAgent.getAddress().toString());
                    } else {
                        AgentKnowledge knowledgeAboutKickedAgent = this.myAgent.community.getAgent(kickedAllianceMember.getName());
                        this.myAgent.community.getOwnerAgentKnowledge().alliance.removeMember(knowledgeAboutKickedAgent);
                    }
                } else if (content instanceof AdvTeamProposal) {
                    this.myAgent.receivedAdvTeamRequest(msg);
                } else {
                    this.handleGeneralRequest(msg);
                }
            } else {
                this.handleGeneralRequest(msg);
            }
        }
    }

    protected void handleGeneralRequest(Message msg) {
        this.sendNotUnderstood(msg, "Unexpected performative in request protocol");
    }

    private void handleInformProtocol(Message msg) {
        if (!"INFORM".equalsIgnoreCase(msg.getProtocol())) {
            return;
        }
        String performative = msg.getPerformative();
        Object content = msg.getContent();
        if ("INFORM-RESULT".equalsIgnoreCase(performative) && content instanceof CooperationResult) {
            CooperationResult cooperationResult = (CooperationResult)content;
            AcrossCoalitionMemberKnowledge coalition = (AcrossCoalitionMemberKnowledge)this.myAgent.community.getCoalition(cooperationResult.getRequestid());
            if (coalition != null) {
                coalition.handleCoalitionTerminated(cooperationResult);
            } else {
                this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + ": Task result for unknown coalition from leader: " + msg.getSender() + " Task: " + cooperationResult.getRequestid());
            }
        } else if ("INFORM-DONE".equalsIgnoreCase(performative) && content instanceof Batch && msg.getReason() != null) {
            AcrossCoalitionLeaderKnowledge coalition = (AcrossCoalitionLeaderKnowledge)this.myAgent.community.getCoalition(msg.getReason());
            if (coalition != null) {
                coalition.transportCompleted((Batch)content);
            } else {
                this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + ": Task result (OK) for unknown coalition received from member: " + msg.getSender() + " Task: " + content);
            }
        } else if ("FAILURE".equalsIgnoreCase(performative) && content instanceof Batch && msg.getReason() != null) {
            AcrossCoalitionLeaderKnowledge coalition = (AcrossCoalitionLeaderKnowledge)this.myAgent.community.getCoalition(msg.getReason());
            if (coalition != null) {
                coalition.transportFailed((Batch)content);
            } else {
                this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + ": Task result (Failure) for unknown coalition received from member: " + msg.getSender() + " Task: " + content);
            }
        } else {
            this.handleGeneralInform(msg);
        }
    }

    protected void handleGeneralInform(Message msg) {
        this.myAgent.getLogger().warning(String.valueOf(this.myAgent.getName()) + "INFORM message with unexpected performative or structure received.\n" + msg);
    }

    protected void handleQueryProtocol(Message msg) {
        String performative = msg.getPerformative();
        Object content = msg.getContent();
        if ("QUERY-IF".equalsIgnoreCase(performative) && content instanceof Message) {
            if (this.myAgent.acceptAllianceMember((Message)content, msg.getSender())) {
                this.informTrue(msg);
            } else {
                this.informFalse(msg);
            }
        } else if ("QUERY-IF".equalsIgnoreCase(performative) && content instanceof Address) {
            QueryIfParticipantTask qiit = new QueryIfParticipantTask(this.myAgent, msg, false){

                @Override
                protected void processQuery(Message queryMessage) {
                    Address candidate = (Address)queryMessage.getContent();
                    AgentKnowledge konwledgeAboutCandidate = TransporterIdleTask.this.myAgent.community.getAgent(candidate.getName());
                    if (konwledgeAboutCandidate.isTrusted() == AgentKnowledge.TrustDecision.DISTRUSTED) {
                        this.informTrue();
                        TransporterIdleTask.this.myAgent.gisShell.submitTopicToServer("VISIO_ACTION", Byte.toString((byte)72), TransporterIdleTask.this.myAgent.getAddress().toString());
                    } else {
                        this.informFalse();
                        TransporterIdleTask.this.myAgent.gisShell.submitTopicToServer("VISIO_ACTION", Byte.toString((byte)73), TransporterIdleTask.this.myAgent.getAddress().toString());
                    }
                }
            };
            qiit.start();
        } else if ("QUERY-REF".equalsIgnoreCase(performative) && content instanceof TeamProposal) {
            QueryRefParticipantTask partTask = new QueryRefParticipantTask(this.myAgent, msg, false){

                @Override
                protected void processQuery(Message queryMessage) {
                    if (!(queryMessage.getContent() instanceof TeamProposal)) {
                        this.refuse();
                        return;
                    }
                    Proposal proposal = TransporterIdleTask.this.myAgent.createTeamMemberProposal((TeamProposal)queryMessage.getContent());
                    LinkedList<Object> data = new LinkedList<Object>();
                    data.add(proposal);
                    data.add(queryMessage.getContent());
                    data.add(TransporterIdleTask.this.myAgent.getName());
                    TransporterIdleTask.this.myAgent.gisShell.submitTopic("TEAM_MEMBER_PROPOSAL", data);
                    TransporterIdleTask.this.myAgent.gui.addMyProposal(proposal);
                    if (proposal != null) {
                        this.informResult(proposal);
                    } else {
                        this.refuse();
                    }
                    this.cancelTask();
                }
            };
            partTask.start();
        } else if ("QUERY-REF".equalsIgnoreCase(performative) && content instanceof AdvTeamProposal) {
            this.myAgent.receivedAdvTeamProposal(msg);
        } else {
            this.handleGeneralQuery(msg);
            return;
        }
    }

    protected void handleGeneralQuery(Message msg) {
        this.sendNotUnderstood(msg, "bad performative or content, QUERY_REF or QUERY_IF expected");
    }

    protected void informResult(Message queryMessage, Object result) {
        Message re = queryMessage.getReply();
        re.setPerformative("INFORM-RESULT");
        re.setContent(result);
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
    }

    protected void informTrue(Message queryMessage) {
        Message re = queryMessage.getReply();
        re.setPerformative("INFORM-T/F");
        re.setContent("TRUE");
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
    }

    protected void informFalse(Message queryMessage) {
        Message re = queryMessage.getReply();
        re.setPerformative("INFORM-T/F");
        re.setContent("FALSE");
        try {
            this.sendMessage(re);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
    }
}

