/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.task;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.task.CNPTransportBidAnswer;
import across.agents.transporter.task.PropComparator;
import across.agents.transporter.task.TransportRequestTask;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.Resource;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportOrder;
import across.data.TransportRequest;
import across.data.Waypoint;
import across.util.GoodsConstants;
import across.util.ListBatchTools;
import across.util.skn.AcrossCoalitionMemberKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.CoalitionKnowledge;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.protocol.queryref.QueryRefInitiatorTask;
import aglobex.protocol.request.RequestParticipantTask;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TransportAcceptedTask
extends RequestParticipantTask {
    TransporterAgent myAgent;
    long expectedReplies = 0L;
    long replied = 0L;
    SortedMap props = new TreeMap(new PropComparator());

    public TransportAcceptedTask(TransporterAgent owner, Message requestMessage, boolean autostart) {
        super(owner, requestMessage, autostart);
        this.myAgent = owner;
        this.start();
    }

    @Override
    protected void processRequest(Message requestMessage) {
        Proposal prop;
        Object content = requestMessage.getContent();
        assert (content instanceof TransportRequest) : content.getClass().getName();
        this.agree();
        TransportRequest tr = (TransportRequest)content;
        AcrossCoalitionMemberKnowledge cmkn = new AcrossCoalitionMemberKnowledge(tr, CoalitionKnowledge.Strategy.FLAT, this.myAgent.community);
        if (this.myAgent.community.appendCoalition(tr.getTransportCfp().getRequestid(), cmkn)) {
            try {
                FileOutputStream out = new FileOutputStream(String.valueOf(CNPTransportBidAnswer.coalitionPath) + this.myAgent.getName(), true);
                PrintStream p = new PrintStream(out);
                long coalMemCount = tr.getTeamMember().size();
                p.println("member of " + tr.getTransportCfp().getRequestid() + " time: " + this.myAgent.getTime() + " count: " + coalMemCount);
                p.close();
            }
            catch (Exception out) {
                // empty catch block
            }
        }
        if ((prop = tr.getProposal()) != null) {
            AgentKnowledge dr;
            TransportCfp tcfp = tr.getTransportCfp();
            final LinkedList<TransportBatch> tBatches = new LinkedList<TransportBatch>();
            Map<String, Resource> resNeed = GoodsConstants.getCargoTypesResourceMap();
            block2: for (TransportBatch tb : tcfp.getTransportBatch()) {
                for (ItemCoverage tic : prop.getItemCoverage()) {
                    if (tic.getItemid() != tb.getBatchid() || !(tic.getCoverage() > 0.0) || tb.getCount() <= 0L) continue;
                    long cap = (long)Math.floor(tic.getCoverage() * (double)tb.getCount());
                    tBatches.add(ListBatchTools.copyTransportBatch(tb, cap));
                    Resource res = resNeed.get(GoodsConstants.resolveType(tb.getComodityName()));
                    res.setCapacity(res.getCapacity() + cap);
                    continue block2;
                }
            }
            final String start = tcfp.getTransportBatch().get(0).getStart();
            final Address startAddress = tcfp.getTransportBatch().get(0).getStartAddress();
            String t = tcfp.getTransportBatch().get(0).getTarget();
            final Address targetAddress = tcfp.getTransportBatch().get(0).getTargetAddress();
            boolean f = false;
            if (Math.random() < this.myAgent.fraudProbability) {
                t = this.myAgent.getContainer().getContainerName();
                f = true;
            }
            final boolean fraud = f;
            final String target = t;
            TransportOrder to = TransportAcceptedTask.prepareSimpleTransportOrder(tBatches, start, startAddress, target, targetAddress, prop.getRequestid(), this.myAgent);
            for (Resource res : this.myAgent.privateParams.getResource()) {
                dr = this.myAgent.community.getAgent(res.getResid());
                if (dr == null || resNeed.get(res.getType()).getCapacity() <= 0L) continue;
                ++this.expectedReplies;
            }
            for (Resource res : this.myAgent.privateParams.getResource()) {
                dr = this.myAgent.community.getAgent(res.getResid());
                if (dr == null) continue;
                Address drAdd = dr.address;
                if (resNeed.get(res.getType()).getCapacity() <= 0L) continue;
                new QueryRefInitiatorTask(this.myAgent, drAdd, to, false){

                    @Override
                    protected void informResult(Object result) {
                        TransportAcceptedTask.this.props.put(result, this.participant);
                        this.replied();
                    }

                    @Override
                    protected void queryRefused() {
                        this.replied();
                    }

                    @Override
                    protected void timeout() {
                        this.replied();
                    }

                    protected void replied() {
                        ++TransportAcceptedTask.this.replied;
                        this.cancelTask();
                        if (TransportAcceptedTask.this.replied == TransportAcceptedTask.this.expectedReplies) {
                            TransportAcceptedTask.this.evaluateDriverReplies(tBatches, start, startAddress, target, targetAddress, prop.getRequestid(), fraud);
                        }
                    }
                }.start();
            }
            if (0L == this.expectedReplies) {
                this.failure("No resource Available.");
                this.myAgent.getLogger().info(String.valueOf(this.myAgent.getName()) + ": No driver available when some expected.");
            }
        }
    }

    private void evaluateDriverReplies(List tBatches, String start, Address startAddress, String target, Address targetAddress, String locationReqId, boolean fraud) {
        LinkedList<String> data = new LinkedList<String>();
        data.add(locationReqId);
        for (Map.Entry entry : this.props.entrySet()) {
            Address addr = (Address)entry.getValue();
            String resId = addr.getName();
            data.add(resId);
            long capacity = 0L;
            Resource driverRes = null;
            for (Resource car : this.myAgent.privateParams.getResource()) {
                if (!resId.equalsIgnoreCase(car.getResid())) continue;
                capacity = car.getCapacity();
                driverRes = car;
                break;
            }
            if (capacity == 0L) continue;
            TransportOrder to = !fraud ? TransportAcceptedTask.prepareSimpleTransportOrder(null, start, startAddress, target, targetAddress, locationReqId, this.myAgent) : TransportAcceptedTask.prepareFraudSimpleTransportOrder(null, start, startAddress, target, targetAddress, locationReqId, this.myAgent);
            boolean isBatchSet = false;
            int i = 0;
            while (i < tBatches.size()) {
                if (capacity == 0L) break;
                TransportBatch tb = (TransportBatch)tBatches.get(i);
                String batchType = GoodsConstants.resolveType(tb.getComodityName());
                if (batchType.equals(driverRes.getType())) {
                    Batch batchStart = new Batch();
                    batchStart.setBatchid(tb.getBatchid());
                    batchStart.setComodityName(tb.getComodityName());
                    batchStart.setDeliveryTime(tb.getStartTime());
                    Batch batchTarget = new Batch();
                    batchTarget.setBatchid(tb.getBatchid());
                    batchTarget.setComodityName(tb.getComodityName());
                    batchTarget.setDeliveryTime(tb.getTargetTime());
                    if (capacity >= tb.getCount()) {
                        batchStart.setCount(tb.getCount());
                        batchTarget.setCount(-tb.getCount());
                        capacity -= tb.getCount();
                        tBatches.remove(tb);
                        --i;
                    } else {
                        tb.setCount(tb.getCount() - capacity);
                        batchStart.setCount(capacity);
                        batchTarget.setCount(-capacity);
                        capacity = 0L;
                    }
                    isBatchSet = true;
                    to.getWaypoint().get(0).getRequestList().get(0).getBatch().add(batchStart);
                    to.getWaypoint().get(1).getRequestList().get(0).getBatch().add(batchTarget);
                }
                ++i;
            }
            if (!isBatchSet) continue;
            TransportRequestTask trt = new TransportRequestTask(this.myAgent, addr, (Object)to);
            trt.start();
            driverRes.setAvailabilityTime(Long.MAX_VALUE);
        }
        this.informDone();
        this.myAgent.gisShell.submitTopicToServer("VISIO_ACTION", Byte.toString((byte)21), this.myAgent.getAddress().toString());
        this.myAgent.setupSemiPrivateFromPrivate();
        this.myAgent.broadcastSemiPrivateToAlliance();
    }

    public static TransportOrder prepareFraudSimpleTransportOrder(List tBatches, String start, Address startAddress, String target, Address targetAddress, String locationReqId, TransporterAgent myAgent) {
        TransportOrder to = TransportAcceptedTask.prepareSimpleTransportOrder(tBatches, start, startAddress, target, targetAddress, locationReqId, myAgent);
        List<Waypoint> waypoints = to.getWaypoint();
        Waypoint targetwp = waypoints.get(1);
        List<RequestList> targetList = targetwp.getRequestList();
        for (RequestList rl : targetList) {
            rl.setRequestTime(-1L);
        }
        return to;
    }

    public static TransportOrder prepareSimpleTransportOrder(List<TransportBatch> tBatches, String start, Address startAddress, String target, Address targetAddress, String locationReqId, TransporterAgent myAgent) {
        TransportOrder to = new TransportOrder();
        Waypoint wpStart = new Waypoint(start);
        Waypoint wpTarget = new Waypoint(target);
        RequestList rlStart = new RequestList();
        RequestList rlTarget = new RequestList();
        rlStart.setRequestid(locationReqId);
        rlStart.setRequestTime(myAgent.getTime());
        rlStart.setDeliveryLocation(start);
        rlStart.setDeliveryAddress(startAddress);
        rlTarget.setRequestid(locationReqId);
        rlTarget.setRequestTime(myAgent.getTime());
        rlTarget.setDeliveryLocation(target);
        rlTarget.setDeliveryAddress(targetAddress);
        wpStart.getRequestList().add(rlStart);
        wpTarget.getRequestList().add(rlTarget);
        to.getWaypoint().add(wpStart);
        to.getWaypoint().add(wpTarget);
        if (tBatches != null) {
            for (TransportBatch tb : tBatches) {
                Batch batchStart = new Batch();
                batchStart.setBatchid(tb.getBatchid());
                batchStart.setComodityName(tb.getComodityName());
                batchStart.setDeliveryTime(tb.getStartTime());
                batchStart.setCount(tb.getCount());
                Batch batchTarget = new Batch();
                batchTarget.setBatchid(tb.getBatchid());
                batchTarget.setComodityName(tb.getComodityName());
                batchTarget.setDeliveryTime(tb.getTargetTime());
                batchTarget.setCount(-tb.getCount());
                rlStart.getBatch().add(batchStart);
                rlTarget.getBatch().add(batchTarget);
            }
        }
        return to;
    }
}

