/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.task;

import across.agents.transporter.TransporterAgent;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.protocol.queryif.QueryIfInitiatorTask;
import aglobex.protocol.request.RequestParticipantTask;

public class RequstJoinAllianceParticipantTask
extends RequestParticipantTask {
    protected TransporterAgent myAgent;
    int votingAgents;
    int positiveVotes;
    int negativeVotes;

    public RequstJoinAllianceParticipantTask(TransporterAgent myAgent, Message msg) {
        super(myAgent, msg, false);
        this.myAgent = myAgent;
        this.requestMessage = msg;
    }

    @Override
    protected void processRequest(Message requestMessage) {
        this.votingAgents = this.myAgent.getAllianceMembers().size();
        if (!this.myAgent.acceptAllianceMember(requestMessage, this.myAgent.getAddress())) {
            this.refuse();
            this.cancelTask();
            return;
        }
        if (this.votingAgents == 0) {
            this.informDone();
            this.cancelTask();
            return;
        }
        for (Address address : this.myAgent.getAllianceMembers()) {
            new QueryIfInitiatorTask(this.myAgent, address, requestMessage){

                @Override
                protected void informTrue() {
                    ++RequstJoinAllianceParticipantTask.this.positiveVotes;
                    RequstJoinAllianceParticipantTask.this.checkAllVotes();
                    this.cancelTask();
                }

                @Override
                protected void informFalse() {
                    ++RequstJoinAllianceParticipantTask.this.negativeVotes;
                    RequstJoinAllianceParticipantTask.this.checkAllVotes();
                    this.cancelTask();
                }
            };
        }
    }

    protected void checkAllVotes() {
        if (this.positiveVotes + this.negativeVotes == this.votingAgents) {
            if (this.negativeVotes == 0) {
                this.informDone();
            } else {
                assert (this.negativeVotes > 0) : this.negativeVotes;
                this.refuse();
            }
            this.cancelTask();
        }
    }
}

