/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.task;

import across.agents.transporter.TransporterAgent;
import across.data.Pages;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobex.protocol.request.RequestInitiatorTask;
import aglobex.protocol.request.RequestParticipantTask;
import java.util.Collection;

public class RequestMergeAllianceTask
extends RequestParticipantTask {
    String otherAllianceName = null;
    TransporterAgent owner;
    long replied = 0L;
    long expectedReplies = 0L;
    boolean refused = false;

    public RequestMergeAllianceTask(TransporterAgent owner, Message reqMessage) {
        super(owner, reqMessage, false);
        this.owner = owner;
        this.processRequest(reqMessage);
    }

    @Override
    protected void processRequest(Message requestMessage) {
        Pages pgs = (Pages)requestMessage.getContent();
        if (pgs.getPage().size() > 0) {
            String aname = TransporterAgent.getAlliance(pgs.getPage().get(0));
            if (!this.owner.allianceAcceptable(this.owner.community.getAlliance(aname))) {
                this.refuse();
                this.cancelTask();
                return;
            }
            Collection<Address> amis = this.owner.community.getOwnerAgentKnowledge().alliance.getAllAgentsAddress(this.owner.getAddress());
            for (Address address : amis) {
                RequestInitiatorTask tsk = new RequestInitiatorTask(this.owner, address, aname, false){

                    @Override
                    protected void informDone() {
                        ++RequestMergeAllianceTask.this.replied;
                    }

                    @Override
                    protected void informResult(Object result) {
                        ++RequestMergeAllianceTask.this.replied;
                        RequestMergeAllianceTask.this.memberRefused(this.participant);
                    }

                    @Override
                    protected void requestRefused() {
                        ++RequestMergeAllianceTask.this.replied;
                        RequestMergeAllianceTask.this.memberRefused(this.participant);
                    }
                };
                tsk.start();
            }
        } else {
            Message m = requestMessage.getReply();
            m.setPerformative("REFUSE");
            try {
                this.sendMessage(m);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
        }
    }

    protected void replied() {
        ++this.replied;
        if (this.replied == this.expectedReplies) {
            this.allAnswered();
        }
    }

    protected void memberRefused(Address participant) {
        if (!this.refused) {
            this.refused = true;
            this.refuse();
            this.cancelTask();
        }
    }

    protected void allAnswered() {
        if (this.refused) {
            this.refuse();
        } else {
            this.informDone();
        }
        this.cancelTask();
    }
}

