/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.task;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.task.CNPTransportBidAnswer;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobex.simulation.protocol.cnp.CNPInitiatorTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CNPTransportSubcontractTask
extends CNPInitiatorTask {
    TransporterAgent owner;
    CNPTransportBidAnswer primaryContractTask;
    TransportCfp subcontractCfp;
    TransportCfp fromLocationCfp;
    Proposal primaryContractProposal;
    Map<Address, Object> acceptedParticipants;
    Proposal bestProposal = null;
    protected GISClientService.Shell gisShell;
    TeamProposal primaryTeamProposal;
    Proposal myProposal;
    HashMap subcontractCoverageRatio = new HashMap();
    public static final int TIMEOUT = 10000;

    public CNPTransportSubcontractTask(TransporterAgent owner, CNPTransportBidAnswer primaryContractTask, Collection participants, Proposal primaryContractProposal, TransportCfp fromLocationCfp, int timeout, TeamProposal primaryTeamProposal, Proposal myProposal) {
        super(owner, participants, null, timeout, null, false);
        this.owner = owner;
        this.primaryContractTask = primaryContractTask;
        this.primaryContractProposal = primaryContractProposal;
        this.fromLocationCfp = fromLocationCfp;
        this.acceptedParticipants = null;
        this.subcontractCfp = this.prepareSubcontractTransportCfp(fromLocationCfp, primaryContractProposal);
        this.gisShell = owner.gisShell;
        this.primaryTeamProposal = primaryTeamProposal;
        this.myProposal = myProposal;
        owner.getLogger().info("----- " + owner.getName() + " sending subcontract CFP to: " + ((LinkedList)this.participants).toString());
        this.sendCfp(this.subcontractCfp, this.accTimeout, null);
    }

    public TransportCfp prepareSubcontractTransportCfp(TransportCfp primaryContractCfp, Proposal coveredByOwnAlliProposal) {
        TransportCfp cfp = new TransportCfp();
        cfp.setRequestid(this.prepareSubcontractRequestId(primaryContractCfp.getRequestid()));
        cfp.setRequestTime(primaryContractCfp.getRequestTime());
        HashMap<Long, Long> totalPrimaryCounts = new HashMap<Long, Long>();
        HashMap<Long, Long> totalSubcontractCounts = new HashMap<Long, Long>();
        block0: for (ItemCoverage itemCoverage : coveredByOwnAlliProposal.getItemCoverage()) {
            for (TransportBatch tb : primaryContractCfp.getTransportBatch()) {
                if (itemCoverage.getItemid() != tb.getBatchid()) continue;
                TransportBatch tbNew = new TransportBatch();
                tbNew.setBatchid(tb.getBatchid());
                tbNew.setComodityName(tb.getComodityName());
                tbNew.setCount(tb.getCount() - (long)Math.floor((double)tb.getCount() * itemCoverage.getCoverage()));
                Long itemPrimaryCount = new Long(tb.getCount());
                Long itemSubcontractCount = new Long(tb.getCount() - (long)Math.floor((double)tb.getCount() * itemCoverage.getCoverage()));
                Long itemTotalPrimaryCount = (Long)totalPrimaryCounts.get(new Long(tb.getBatchid()));
                if (itemTotalPrimaryCount != null) {
                    itemTotalPrimaryCount = itemTotalPrimaryCount + itemPrimaryCount;
                } else {
                    totalPrimaryCounts.put(new Long(tb.getBatchid()), itemPrimaryCount);
                }
                Long itemTotalSubcontractCount = (Long)totalSubcontractCounts.get(new Long(itemCoverage.getItemid()));
                if (itemTotalSubcontractCount != null) {
                    itemTotalSubcontractCount = itemTotalSubcontractCount + itemSubcontractCount;
                } else {
                    totalSubcontractCounts.put(new Long(itemCoverage.getItemid()), itemSubcontractCount);
                }
                tbNew.setStart(tb.getStart());
                tbNew.setStartAddress(tb.getStartAddress());
                tbNew.setTargetAddress(tb.getTargetAddress());
                tbNew.setTarget(tb.getTarget());
                tbNew.setStartTime(tb.getStartTime());
                tbNew.setTargetTime(tb.getTargetTime());
                cfp.getTransportBatch().add(tbNew);
                continue block0;
            }
        }
        for (Long itemCoverageKey : totalPrimaryCounts.keySet()) {
            Long thisItemSubcontractCount = (Long)totalSubcontractCounts.get(itemCoverageKey);
            Long thisItemPrimaryCount = (Long)totalPrimaryCounts.get(itemCoverageKey);
            this.subcontractCoverageRatio.put(itemCoverageKey, new Double((double)thisItemSubcontractCount.longValue() / (double)thisItemPrimaryCount.longValue()));
        }
        if (cfp.getTransportBatch().isEmpty()) {
            return null;
        }
        return cfp;
    }

    protected List evaluateReplies() {
        LinkedList<Address> selected = new LinkedList<Address>();
        Message bestOffer = null;
        double bestCoverage = 0.0;
        long bestPrice = Long.MAX_VALUE;
        for (Message m : this.receivedOffers.values()) {
            this.owner.getLogger().info("##--## content of message is of type: " + m.toString());
            if (!m.getPerformative().equalsIgnoreCase("PROPOSAL")) continue;
            try {
                Proposal prop = (Proposal)m.getContent();
                if (prop == null) continue;
                long price = prop.getTotalPrice();
                double coverage = 0.0;
                long total = 0L;
                ListIterator<TransportBatch> i = this.subcontractCfp.getTransportBatch().listIterator();
                block3: while (i.hasNext()) {
                    TransportBatch tb = i.next();
                    total += tb.getCount();
                    for (ItemCoverage ic : prop.getItemCoverage()) {
                        if (ic.getItemid() != tb.getBatchid()) continue;
                        coverage += (double)tb.getCount() * ic.getCoverage();
                        continue block3;
                    }
                }
                coverage = 0L != total ? (coverage /= (double)total) : 1.0;
                if (!(coverage > bestCoverage) && (coverage != bestCoverage || price >= bestPrice)) continue;
                bestOffer = m;
                bestPrice = price;
                bestCoverage = coverage;
            }
            catch (ClassCastException e) {
                this.owner.getLogger().severe("Unexpected content type in cfp answer - proposal expected. Message:\n " + m);
            }
        }
        if (bestOffer != null) {
            selected.add(bestOffer.getSender());
            this.bestProposal = (Proposal)bestOffer.getContent();
            LinkedList<Object> data = new LinkedList<Object>();
            data.add(this.subcontractCfp);
            data.add(bestOffer.getSender().getName());
            this.gisShell.submitTopic("BEST_LEADER", data);
        }
        return selected;
    }

    @Override
    protected boolean evaluateAcceptReply(Message m) {
        if (!m.getPerformative().equalsIgnoreCase("FAILURE")) {
            m.getPerformative().equalsIgnoreCase("INFORM-DONE");
        }
        return true;
    }

    @Override
    protected void evaluateAcceptTimeout() {
    }

    @Override
    protected void handleReplies() {
        this.status = 2;
        this.acceptedParticipants = this.evaluateRepliesWithContent();
        System.out.println("@@@@@ accepted subcontract participants - size(): " + this.acceptedParticipants.size());
        Proposal mergedProposal = null;
        if (this.bestProposal != null) {
            mergedProposal = this.mergeProposals();
            this.owner.getLogger().info("----- merging proposals");
            this.primaryContractTask.sendMergedProposal(mergedProposal);
            LinkedList<Object> data = new LinkedList<Object>();
            data.add(mergedProposal);
            data.add(this.fromLocationCfp);
            data.add(this.owner.getName());
            data.add(this.myProposal);
            data.add(this.primaryTeamProposal);
            this.owner.gisShell.submitTopic("TEAM_LEADER_PROPOSAL", data);
        } else {
            this.owner.getLogger().info("----- cannot merge proposals, using primary contract proposal");
            mergedProposal = this.primaryContractProposal;
            LinkedList<Object> data = new LinkedList<Object>();
            data.add(mergedProposal);
            data.add(this.fromLocationCfp);
            data.add(this.owner.getName());
            data.add(this.myProposal);
            data.add(this.primaryTeamProposal);
            this.owner.gisShell.submitTopic("TEAM_LEADER_PROPOSAL", data);
            this.primaryContractTask.sendMergedProposal(mergedProposal);
        }
    }

    protected void proposalAcceptedByLocation() {
        if (this.acceptedParticipants == null || this.acceptedParticipants.isEmpty()) {
            this.owner.getLogger().info("SUSPITIOUS: participants==null OR no participant of subcontract choosen as the best");
        }
        this.sendAnswersToParticipants(this.acceptedParticipants);
    }

    protected void proposalRefusedByLocation() {
        this.sendAnswersToParticipants(new LinkedHashMap<Address, Object>());
    }

    protected Proposal mergeProposals() {
        Proposal mergedProposal = new Proposal();
        mergedProposal.setRequestid(this.primaryContractProposal.getRequestid());
        long mergedProposalPrice = this.primaryContractProposal.getTotalPrice() + this.bestProposal.getTotalPrice();
        long mergedProposalTime = Math.max(this.primaryContractProposal.getProposalTime(), this.bestProposal.getProposalTime());
        mergedProposal.setProposalTime(mergedProposalTime);
        mergedProposal.setTotalPrice(mergedProposalPrice);
        if (this.bestProposal != null) {
            this.owner.getLogger().info("----- subcontract bestProposal (" + this.owner.getName() + "): " + this.bestProposal.toString());
        }
        for (ItemCoverage subcontractItemCoverage : this.bestProposal.getItemCoverage()) {
            boolean itemCoverageFound = false;
            for (ItemCoverage primaryItemCoverage : this.primaryContractProposal.getItemCoverage()) {
                if (primaryItemCoverage.getItemid() != subcontractItemCoverage.getItemid()) continue;
                itemCoverageFound = true;
                ItemCoverage newItemCoverage = new ItemCoverage();
                newItemCoverage.setLocation(primaryItemCoverage.getLocation());
                newItemCoverage.setItemid(primaryItemCoverage.getItemid());
                Double itemRatio = (Double)this.subcontractCoverageRatio.get(new Long(newItemCoverage.getItemid()));
                if (itemRatio != null) {
                    newItemCoverage.setCoverage(primaryItemCoverage.getCoverage() + itemRatio * subcontractItemCoverage.getCoverage());
                    if (newItemCoverage.getCoverage() > 0.8) {
                        System.out.println("BUG 01");
                    }
                } else {
                    newItemCoverage.setCoverage(primaryItemCoverage.getCoverage());
                    if (newItemCoverage.getCoverage() > 0.8) {
                        System.out.println("BUG 02");
                    }
                    System.out.println("VYPIS");
                }
                mergedProposal.getItemCoverage().add(newItemCoverage);
            }
            if (itemCoverageFound) continue;
            ItemCoverage newItemCoverage = new ItemCoverage();
            newItemCoverage.setLocation(subcontractItemCoverage.getLocation());
            newItemCoverage.setItemid(subcontractItemCoverage.getItemid());
            newItemCoverage.setCoverage(subcontractItemCoverage.getCoverage());
            mergedProposal.getItemCoverage().add(newItemCoverage);
        }
        for (ItemCoverage ic : mergedProposal.getItemCoverage()) {
            if (!(ic.getCoverage() > 1.0)) continue;
            System.out.println("BUG");
        }
        return mergedProposal;
    }

    protected String prepareSubcontractRequestId(String primaryContractRequestId) {
        String subcontractRequestId = primaryContractRequestId.concat("-" + this.owner.getName());
        return subcontractRequestId;
    }
}

