/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.task;

import across.agents.transporter.TransporterAgent;
import across.agents.transporter.task.CNPTransportSubcontractTask;
import across.agents.transporter.util.TransporterUtils;
import across.data.CoalitionDescription;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.Resource;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.data.TransportRequest;
import across.util.GoodsConstants;
import across.util.ListBatchTools;
import across.util.skn.AcrossCoalitionLeaderKnowledge;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;
import across.util.skn.CoalitionKnowledge;
import across.util.skn.ServiceKnowledge;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;

public class CNPTransportBidAnswer
extends CNPParticipantTask {
    protected TransporterAgent owner;
    public static String coalitionPath = "logs" + File.separator;
    public static final int TIMEOUT = 50000;
    public static final int TEAM_QUERY_TIMEOUT = 6000;
    public static final double SUFFICIENT_COVERAGE = 1.0;
    protected GISClientService.Shell gisShell;
    protected CNPTransportSubcontractTask subcontractTask;
    Map createdTeam;
    Map proposedTeam;
    double coverage = 0.0;
    private TransportCfp transportCfpField;
    int totalReplies;
    int replied = 0;
    TeamProposal myTeamProposal;

    public CNPTransportBidAnswer(TransporterAgent owner, int msec, Message cfpMessage) {
        super(owner, msec, cfpMessage, false);
        this.owner = owner;
        this.subcontractTask = null;
        if (this.isCfpFromLocation()) {
            this.prepareProposal();
        } else if (owner.subcontractAllowed && owner.restrictionsChecker.acceptTeamLeader(cfpMessage.getSender())) {
            this.prepareProposal();
        } else {
            this.sendRefuse();
        }
        this.gisShell = owner.gisShell;
    }

    public CNPTransportBidAnswer(TransporterAgent owner, int msec, TransportCfp tcfp) {
        super(owner, msec);
        this.owner = owner;
        this.transportCfpField = tcfp;
        this.start();
        this.gisShell = owner.gisShell;
    }

    @Override
    protected void prepareProposal() {
        try {
            TransportCfp cfp = this.cfpMessage != null ? (TransportCfp)this.cfpMessage.getContent() : this.transportCfpField;
            this.proposedTeam = this.getPossibleTeam(cfp);
            this.totalReplies = this.proposedTeam.size();
            if (this.totalReplies != 0) {
                this.createdTeam = new HashMap();
                for (Address address : this.proposedTeam.keySet()) {
                    TeamProposal teamProposal = new TeamProposal();
                    teamProposal.setTeamLeader(this.owner.getAddress());
                    teamProposal.getTeamMember().addAll(this.proposedTeam.keySet());
                    teamProposal.setTransportCfp(cfp);
                    teamProposal.setRequestedServices((TransportCfp)this.proposedTeam.get(address));
                    this.myTeamProposal = teamProposal;
                    if (!address.equals(this.owner.getAddress())) {
                        boolean willRefuse = false;
                        continue;
                    }
                    Proposal p = this.owner.createTeamMemberProposal(teamProposal);
                    if (p != null) {
                        this.createdTeam.put(this.owner.getAddress(), p);
                    }
                    ++this.replied;
                    if (this.replied != this.totalReplies) continue;
                    this.evaluateTeamProposal(cfp, this.createdTeam);
                }
            } else {
                this.sendRefuse();
            }
        }
        catch (ClassCastException e) {
            this.owner.getLogger().severe("CNPTransportBidAnswer: Unexpected cfp message content.");
            this.sendNotUnderstood(this.cfpMessage, "CNPTransportBidAnswer: Unexpected cfp message content.");
            e.printStackTrace();
        }
    }

    protected void evaluateTeamProposal(TransportCfp cfp, Map createdTeam) {
        Proposal myProposal = (Proposal)createdTeam.get(this.owner.getAddress());
        Proposal proposal = new Proposal();
        proposal.setRequestid(cfp.getRequestid());
        proposal.setProposalTime(this.owner.getTime());
        proposal.setTotalPrice(10L);
        for (Address member : createdTeam.keySet()) {
            Proposal memberProposal = (Proposal)createdTeam.get(member);
            if (memberProposal == null) continue;
            proposal.setProposalTime(Math.max(proposal.getProposalTime(), memberProposal.getProposalTime()));
            proposal.setTotalPrice(proposal.getTotalPrice() + memberProposal.getTotalPrice());
        }
        double sumCovered = 0.0;
        double sumToCover = 0.0;
        for (TransportBatch item : cfp.getTransportBatch()) {
            ItemCoverage itemCoverage = new ItemCoverage();
            itemCoverage.setItemid(item.getBatchid());
            double covered = 0.0;
            block2: for (Address member : createdTeam.keySet()) {
                Proposal prop = (Proposal)createdTeam.get(member);
                TransportCfp memberCfp = (TransportCfp)this.proposedTeam.get(member);
                if (prop == null) continue;
                for (ItemCoverage mic : prop.getItemCoverage()) {
                    if (mic.getItemid() != item.getBatchid()) continue;
                    for (TransportBatch memberBatch : memberCfp.getTransportBatch()) {
                        if (memberBatch.getBatchid() != item.getBatchid()) continue;
                        covered += mic.getCoverage() * (double)memberBatch.getCount() / (double)item.getCount();
                        continue block2;
                    }
                    continue block2;
                }
            }
            covered = Math.min(covered, 1.0);
            sumToCover += (double)item.getCount();
            sumCovered += covered * (double)item.getCount();
            if (0L != item.getCount()) {
                itemCoverage.setCoverage(covered);
            } else {
                itemCoverage.setCoverage(1.0);
            }
            proposal.getItemCoverage().add(itemCoverage);
        }
        double totalCoverage = this.calculateTotalCoverage(cfp, proposal);
        if (this.owner.subcontractAllowed && this.isCfpFromLocation() && totalCoverage < 1.0) {
            Collection<Object> subcontractParticipants = this.getPossibleOtherAlliancesParticipants();
            if (!(subcontractParticipants = this.owner.community.removeAgentsFromSameCoalition((Collection<Address>)subcontractParticipants)).isEmpty()) {
                this.subcontractTask = new CNPTransportSubcontractTask(this.owner, this, subcontractParticipants, proposal, cfp, 10000, this.myTeamProposal, myProposal);
                return;
            }
        }
        if (sumCovered > 0.0 || sumToCover == 0.0) {
            LinkedList<Object> data = new LinkedList<Object>();
            data.add(proposal);
            data.add(cfp);
            data.add(this.owner.getName());
            data.add(myProposal);
            data.add(this.myTeamProposal);
            this.owner.gisShell.submitTopic("TEAM_LEADER_PROPOSAL", data);
            this.sendProposal(proposal);
        } else {
            this.sendRefuse();
        }
    }

    @Override
    protected void proposalAccepted(Message acceptMessage) {
        if (this.owner.subcontractAllowed && this.subcontractTask != null) {
            this.subcontractTask.proposalAcceptedByLocation();
        }
        TransportCfp cfp = this.transportCfpField == null ? (TransportCfp)this.cfpMessage.getContent() : this.transportCfpField;
        LinkedList<String> members = new LinkedList<String>();
        Iterator j = this.createdTeam.keySet().iterator();
        while (j.hasNext()) {
            members.add(((Address)j.next()).getName());
        }
        CoalitionDescription cd = new CoalitionDescription();
        cd.setCoalitionLeader(this.owner.getName());
        cd.getCoalitionMember().addAll(members);
        cd.setTaskDegree("DEGREE ***");
        cd.setTaskDisaster("DISASTER ***");
        cd.setTaskLocation("LOCATION ***");
        cd.setTaskName(String.valueOf(cfp.getRequestid()) + "'s coalition");
        LinkedList<Object> l = new LinkedList<Object>();
        l.add(cfp.getRequestid());
        l.add(cd);
        this.gisShell.submitTopic("NEW_COALITION", l);
        LinkedList<Object> data = new LinkedList<Object>();
        data.add(cfp);
        data.add(this.owner.getName());
        this.gisShell.submitTopic("BEST_LEADER", data);
        AcrossCoalitionLeaderKnowledge ckn = new AcrossCoalitionLeaderKnowledge(cfp, (Proposal)this.submitedProposal, CoalitionKnowledge.Strategy.FLAT, this.owner.community);
        Iterator i = this.createdTeam.keySet().iterator();
        LinkedList<Address> teamMembers = new LinkedList<Address>();
        teamMembers.addAll(this.createdTeam.keySet());
        if (!teamMembers.contains(this.owner.getAddress())) {
            teamMembers.add(this.owner.getAddress());
        }
        boolean leaderExec = false;
        while (i.hasNext()) {
            Address address = (Address)i.next();
            TransportRequest tr = new TransportRequest();
            tr.setProposal((Proposal)this.createdTeam.get(address));
            TransportCfp transportCfp = (TransportCfp)this.proposedTeam.get(address);
            tr.setTransportCfp(transportCfp);
            tr.setTeamLeader(this.owner.getAddress());
            tr.getTeamMember().addAll(teamMembers);
            Message requestMsg = Message.newInstance("REQUEST", this.owner.getAddress(), address);
            requestMsg.setProtocol("REQUEST");
            requestMsg.setContent(tr);
            try {
                this.owner.sendMessage(requestMsg);
                ckn.appendMember(this.owner.community.getAgent(address.getName()), tr);
                if (address != this.owner.getAddress()) continue;
                leaderExec = true;
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
        }
        if (ckn.getAllMembersCount() > 0L || leaderExec) {
            this.owner.community.appendCoalition(cfp.getRequestid(), ckn);
            try {
                FileOutputStream out = new FileOutputStream(String.valueOf(coalitionPath) + this.owner.getName(), true);
                PrintStream p = new PrintStream(out);
                long allMembersCount = ckn.getAllMembersCount();
                p.println("leader of " + l.get(0) + " time: " + this.owner.getTime() + " count: " + teamMembers.size());
                p.close();
            }
            catch (Exception out) {
                // empty catch block
            }
            if (this.owner.isRenegade && !leaderExec) {
                LinkedList<String> bdata = new LinkedList<String>();
                bdata.add(cfp.getRequestid());
            }
        }
        try {
            this.sendDone(null);
        }
        catch (InvisibleContainerException invisibleContainerException) {
            // empty catch block
        }
        this.cancelTask();
    }

    @Override
    protected void proposalRefused(Message refuseMessage) {
        if (this.owner.subcontractAllowed && this.subcontractTask != null) {
            this.subcontractTask.proposalRefusedByLocation();
        }
    }

    protected List getTeamMembersFromAlliance(AllianceKnowledge alliance) {
        AbstractList availableMembers = alliance != null ? new ArrayList<Address>(alliance.getAllAgentsAddress(this.owner.getAddress())) : new LinkedList<Address>();
        availableMembers.add(this.owner.getAddress());
        return availableMembers;
    }

    protected Map getPossibleTeam(TransportCfp cfp) {
        Collection requestedResources = TransporterUtils.getRequestedResources(cfp, 1.0);
        TreeSet<AgentQuality> usableAlliMembers = new TreeSet<AgentQuality>();
        AllianceKnowledge alliance = this.owner.community.getAlliance(this.owner.myAlliance);
        List availableMembers = this.getTeamMembersFromAlliance(alliance);
        for (Address alliMember : availableMembers) {
            double alliMemberQuality;
            if (!this.owner.restrictionsChecker.acceptTeamMember(alliMember) || !(0.0 < (alliMemberQuality = this.owner.getCoalitionMemberQuality(cfp, requestedResources, alliMember)))) continue;
            AgentQuality aq = new AgentQuality(alliMember, alliMemberQuality);
            usableAlliMembers.add(aq);
        }
        HashMap<Address, TransportCfp> foundTeam = new HashMap<Address, TransportCfp>();
        LinkedList<TransportBatch> unsatisfiedCfpBatches = new LinkedList<TransportBatch>();
        for (TransportBatch tb : cfp.getTransportBatch()) {
            unsatisfiedCfpBatches.add(ListBatchTools.copyTransportBatch(tb));
        }
        for (AgentQuality aQ : usableAlliMembers) {
            Address agent = aQ.address;
            List reqBatches = this.decreaseRequestedResources(cfp, requestedResources, unsatisfiedCfpBatches, agent);
            if (reqBatches.size() > 0) {
                TransportCfp requested = new TransportCfp();
                requested.setRequestTime(cfp.getRequestTime());
                requested.setRequestid(cfp.getRequestid());
                requested.getTransportBatch().addAll(reqBatches);
                foundTeam.put(agent, requested);
            }
            if (unsatisfiedCfpBatches.isEmpty() || unsatisfiedCfpBatches.isEmpty()) break;
        }
        return foundTeam;
    }

    public void log(String text) {
        if ("anttransporter".equalsIgnoreCase(this.owner.getName())) {
            this.owner.getLogger().warning(text);
        }
    }

    private long getCapacity(Collection resourceList) {
        long capacity = 0L;
        if (resourceList != null) {
            for (Resource resource : resourceList) {
                capacity += resource.getCapacity();
            }
        }
        return capacity;
    }

    protected List decreaseRequestedResources(TransportCfp cfp, Collection requestedResources, List unsatisfiedCfpBatches, Address agent) {
        ArrayList<TransportBatch> usedResources = new ArrayList<TransportBatch>(cfp.getTransportBatch().size());
        Map<String, Resource> agentResources = GoodsConstants.getCargoTypesResourceMap();
        for (Resource resource : requestedResources) {
            long capacity;
            if (0L >= resource.getCapacity() || 0L >= (capacity = this.owner.getAgentResource(agent, resource.getType()))) continue;
            Resource res = agentResources.get(resource.getType());
            res.setCapacity(capacity);
        }
        Iterator it = unsatisfiedCfpBatches.iterator();
        while (it.hasNext()) {
            long usableCapacity;
            TransportBatch tb = (TransportBatch)it.next();
            long rescapacity = agentResources.get(GoodsConstants.resolveType(tb.getComodityName())).getCapacity();
            if (0L >= rescapacity || (usableCapacity = Math.min(rescapacity, tb.getCount())) <= tb.getCount() / 20L) continue;
            usedResources.add(ListBatchTools.copyTransportBatch(tb, usableCapacity));
            tb.setCount(tb.getCount() - usableCapacity);
            if (0L == tb.getCount()) {
                it.remove();
            }
            agentResources.get(GoodsConstants.resolveType(tb.getComodityName())).setCapacity(rescapacity - usableCapacity);
        }
        return usedResources;
    }

    private double calculateTotalCoverage(TransportCfp cfp, Proposal proposal) {
        long total = 0L;
        double totalCoverage = 0.0;
        ListIterator<TransportBatch> i = cfp.getTransportBatch().listIterator();
        block0: while (i.hasNext()) {
            TransportBatch tb = i.next();
            total += tb.getCount();
            for (ItemCoverage ic : proposal.getItemCoverage()) {
                if (ic.getItemid() != tb.getBatchid()) continue;
                totalCoverage += (double)tb.getCount() * ic.getCoverage();
                continue block0;
            }
        }
        totalCoverage = 0L != total ? (totalCoverage /= (double)total) : 1.0;
        return totalCoverage;
    }

    private List getPossibleOtherAlliancesParticipants() {
        ServiceKnowledge servKnow = this.owner.community.getService("Transporter");
        if (servKnow == null) {
            return new LinkedList();
        }
        LinkedList<Address> possibleParticipants = new LinkedList<Address>();
        for (AgentKnowledge aki : servKnow.getAllAccessibleAgents(this.owner.getAddress())) {
            if (aki.address == null || !this.owner.restrictionsChecker.acceptTeamMember(aki.address)) continue;
            AllianceKnowledge alliance = this.owner.community.getAlliance(this.owner.myAlliance);
            boolean isMemberOfMyAlli = false;
            for (AgentKnowledge akii : alliance.getAllMembers()) {
                if (!akii.address.equals(aki.address)) continue;
                isMemberOfMyAlli = true;
                break;
            }
            if (isMemberOfMyAlli) continue;
            possibleParticipants.add(aki.address);
        }
        return possibleParticipants;
    }

    void sendMergedProposal(Proposal mergedProposal) {
        this.sendProposal(mergedProposal);
    }

    private boolean isCfpFromLocation() {
        String requestId = ((TransportCfp)this.cfpMessage.getContent()).getRequestid();
        return requestId.split("-").length <= 2;
    }

    protected class AgentQuality
    implements Comparable {
        Address address;
        double quality;

        public AgentQuality(Address address, double quality) {
            this.address = address;
            this.quality = quality;
        }

        public int compareTo(Object o) {
            double qDif = this.quality - ((AgentQuality)o).quality;
            if (qDif == 0.0) {
                return this.address.toString().compareTo(((AgentQuality)o).address.toString());
            }
            return (int)(qDif * 10000.0);
        }

        public boolean equals(Object o) {
            double qDif = this.quality - ((AgentQuality)o).quality;
            if (qDif == 0.0) {
                return this.address.toString().equals(((AgentQuality)o).address.toString());
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.quality * 10000.0) + this.address.hashCode();
        }
    }
}

