/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter.gui;

import across.agents.transporter.TransporterAgent;
import across.data.AllianceRestrictions;
import across.data.CoalitionLeaderRestrictions;
import across.data.CoalitionRestrictions;
import across.data.ItemCoverage;
import across.data.Param;
import across.data.Possibility;
import across.data.PrivateParams;
import across.data.Proposal;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.util.skn.CommunityKnowledge;
import aglobe.container.Store;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TransporterAgentGUI
extends JFrame {
    private final Store store;
    private static final String STORE_WINDOW_X = "gui/win_x";
    private static final String STORE_WINDOW_Y = "gui/win_y";
    private static final String STORE_WINDOW_WIDTH = "gui/win_width";
    private static final String STORE_WINDOW_HEIGHT = "gui/win_height";
    private final int proposalsInTree = 20;
    private LinkedList proposalNodes = new LinkedList();
    private int proposalsOnScreen = 0;
    private int totalProposals = 0;
    private TransporterAgent owner = null;
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JScrollPane jScrollPane3 = new JScrollPane();
    private JScrollPane jScrollPane4 = new JScrollPane();
    private JScrollPane jScrollPane5 = new JScrollPane();
    private JScrollPane jScrollPane6 = new JScrollPane();
    private JScrollPane jScrollPaneAlliances = new JScrollPane();
    private JScrollPane coalitionPane = new JScrollPane();
    private DefaultTableModel publicTableModel = new DefaultTableModel();
    private JTable publicTable = new JTable();
    private DefaultTableModel semiTableModel = new DefaultTableModel();
    private JTable semiTable = new JTable();
    private DefaultTableModel privateTableModel = new DefaultTableModel();
    private DefaultTreeModel alliTreeModel;
    private DefaultTreeModel myAllianceTreeModel;
    private DefaultTreeModel serviceProvidersTreeModel;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("all");
    private DefaultTreeModel myModel = new DefaultTreeModel(this.rootNode);
    JTree jTree1 = new JTree();
    JTree jTree3 = new JTree();
    JTree jTree4 = new JTree();
    JTree jTree2 = new JTree();
    JTree jTreeProposals = new JTree();
    JTextArea jTextCoalitions = new JTextArea();
    private Object lock1 = new Object();
    private Object lock2 = new Object();
    private Object lock3 = new Object();
    private HashMap allPages = new HashMap();
    private DefaultMutableTreeNode proposalsRootNode = new DefaultMutableTreeNode("Proposals");
    private DefaultTreeModel proposalsTreeModel = new DefaultTreeModel(this.proposalsRootNode);

    public TransporterAgentGUI(TransporterAgent _owner, CommunityKnowledge community) throws HeadlessException {
        this.owner = _owner;
        this.store = this.owner.getContainer().getAgentStore(this.owner.getName());
        try {
            this.alliTreeModel = community.getAlliancesTreeModel();
            this.myAllianceTreeModel = community.getMyAllianceTreeModel();
            this.serviceProvidersTreeModel = community.getServiceProvidersTreeModel();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jTabbedPane1.setMinimumSize(new Dimension(29, 16));
        this.jTabbedPane1.setToolTipText("");
        this.publicTable.setAutoResizeMode(4);
        this.publicTable.setModel(this.publicTableModel);
        this.semiTable.setAutoResizeMode(4);
        this.semiTable.setModel(this.semiTableModel);
        this.jTree1.setMinimumSize(new Dimension(0, 0));
        this.jTree1.setModel(null);
        this.jTreeProposals.setModel(this.proposalsTreeModel);
        this.jTreeProposals.expandRow(0);
        this.jTreeProposals.setRootVisible(false);
        this.jTree2.setRequestFocusEnabled(true);
        this.jTree2.setModel(this.serviceProvidersTreeModel);
        this.jTree2.expandRow(0);
        this.jTree3.setRequestFocusEnabled(true);
        this.jTree3.setModel(this.alliTreeModel);
        this.jTree3.expandRow(0);
        this.jTree4.setRequestFocusEnabled(true);
        this.jTree4.setModel(this.myAllianceTreeModel);
        this.jTree4.expandRow(0);
        this.jTabbedPane1.add((Component)this.jScrollPane3, "Public");
        this.jTabbedPane1.add((Component)this.jScrollPane4, "Semi");
        this.jTabbedPane1.add((Component)this.jScrollPane2, "Private");
        this.jTabbedPane1.add((Component)this.jScrollPaneAlliances, "Alliances");
        this.jTabbedPane1.add((Component)this.jScrollPane1, "Known service prowiders");
        this.jTabbedPane1.add((Component)this.jScrollPane6, "Alliance members");
        this.jTabbedPane1.add((Component)this.jScrollPane5, "Proposals");
        this.jScrollPaneAlliances.getViewport().add((Component)this.jTree3, null);
        this.jScrollPane6.getViewport().add((Component)this.jTree4, null);
        this.jScrollPane1.getViewport().add((Component)this.jTree2, null);
        this.jScrollPane4.getViewport().add((Component)this.semiTable, null);
        this.jScrollPane3.getViewport().add((Component)this.publicTable, null);
        this.jScrollPane2.getViewport().add((Component)this.jTree1, null);
        this.jScrollPane5.getViewport().add((Component)this.jTreeProposals, null);
        this.getContentPane().add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.coalitionPane, "Coalitions");
        this.coalitionPane.getViewport().add(this.jTextCoalitions);
    }

    public void setPublic(PublicParams pp) {
        this.setPublicTableModel(pp);
    }

    public void setSemi(SemiPrivateParams spp) {
        this.setSemiTableModel(spp);
    }

    public void setPrivate(PrivateParams pp) {
        this.setPrivateTableModel(pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPublicTableModel(PublicParams pp) {
        Object object = this.lock2;
        synchronized (object) {
            List<Param> namesValues = pp.getParam();
            int size = namesValues.size();
            final String[] names = new String[size];
            final String[] values = new String[size];
            int i = 0;
            while (i < size) {
                Param p = namesValues.get(i);
                names[i] = p.getName();
                values[i] = p.getValue();
                ++i;
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = TransporterAgentGUI.this.lock2;
                    synchronized (object) {
                        TransporterAgentGUI.this.publicTableModel = new DefaultTableModel();
                        TransporterAgentGUI.this.publicTable.setModel(TransporterAgentGUI.this.publicTableModel);
                        TransporterAgentGUI.this.publicTableModel.addColumn((Object)"PARAMETER", names);
                        TransporterAgentGUI.this.publicTableModel.addColumn((Object)"VALUE", values);
                        TransporterAgentGUI.this.publicTable.getColumnModel().getColumn(0).setPreferredWidth(100);
                        TransporterAgentGUI.this.publicTable.getColumnModel().getColumn(1).setPreferredWidth(200);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSemiTableModel(SemiPrivateParams spp) {
        Object object = this.lock3;
        synchronized (object) {
            List<Param> semi = spp.getParam();
            List<Resource> resource = spp.getResource();
            int size = semi.size() + resource.size();
            final String[] names = new String[size];
            final String[] values = new String[size];
            int j = 0;
            for (Param p : semi) {
                names[j] = p.getName();
                values[j] = p.getValue();
                ++j;
            }
            for (Resource r : resource) {
                names[j] = r.getType();
                values[j] = String.valueOf(r.getCapacity());
                ++j;
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = TransporterAgentGUI.this.lock3;
                    synchronized (object) {
                        TransporterAgentGUI.this.semiTableModel = new DefaultTableModel();
                        TransporterAgentGUI.this.semiTable.setModel(TransporterAgentGUI.this.semiTableModel);
                        TransporterAgentGUI.this.semiTableModel.addColumn((Object)"PARAMETER", names);
                        TransporterAgentGUI.this.semiTableModel.addColumn((Object)"VALUE", values);
                        TransporterAgentGUI.this.semiTable.getColumnModel().getColumn(0).setPreferredWidth(100);
                        TransporterAgentGUI.this.semiTable.getColumnModel().getColumn(1).setPreferredWidth(200);
                    }
                }
            });
        }
    }

    private void setPrivateTableModel(PrivateParams pp) {
        this.myModel.setRoot(this.rootNode);
        this.jTree1.setModel(this.myModel);
        DefaultMutableTreeNode restrictionsNode = new DefaultMutableTreeNode("Restrictions");
        this.rootNode.add(restrictionsNode);
        DefaultMutableTreeNode allianceRestrictionsNode = new DefaultMutableTreeNode("Alliance restrictions");
        restrictionsNode.add(allianceRestrictionsNode);
        DefaultMutableTreeNode coalitionRestrictionsNode = new DefaultMutableTreeNode("Coalition restrictions");
        restrictionsNode.add(coalitionRestrictionsNode);
        DefaultMutableTreeNode coalitionLeaderRestrictionsNode = new DefaultMutableTreeNode("Coalition leader restrictions");
        restrictionsNode.add(coalitionLeaderRestrictionsNode);
        AllianceRestrictions restrictionsA = pp.getAllianceRestrictions();
        this.addPossibilitiesToTree(allianceRestrictionsNode, restrictionsA.getPossibility());
        CoalitionRestrictions restrictionsC = pp.getCoalitionRestrictions();
        this.addPossibilitiesToTree(coalitionRestrictionsNode, restrictionsC.getPossibility());
        CoalitionLeaderRestrictions restrictionsL = pp.getCoalitionLeaderRestrictions();
        this.addPossibilitiesToTree(coalitionLeaderRestrictionsNode, restrictionsL.getPossibility());
        DefaultMutableTreeNode resourcesNode = new DefaultMutableTreeNode("Resources");
        this.rootNode.add(resourcesNode);
        this.addResourcesToTree(resourcesNode, pp.getResource());
        this.jTree1.expandRow(0);
        this.jTree1.setRootVisible(false);
    }

    private void addResourcesToTree(DefaultMutableTreeNode myRoot, List resources) {
        for (Resource r : resources) {
            DefaultMutableTreeNode resourceNode = new DefaultMutableTreeNode(String.valueOf(r.getType()) + " = " + r.getCapacity());
            myRoot.add(resourceNode);
        }
    }

    private void addPossibilitiesToTree(DefaultMutableTreeNode myRoot, List possibilities) {
        DefaultMutableTreeNode positiveNode = new DefaultMutableTreeNode("positive");
        DefaultMutableTreeNode negativeNode = new DefaultMutableTreeNode("negative");
        myRoot.add(negativeNode);
        myRoot.add(positiveNode);
        for (Possibility possible : possibilities) {
            DefaultMutableTreeNode newNode;
            List<Param> positive = possible.getPositive().getParam();
            List<Param> negative = possible.getNegative().getParam();
            for (Param p : positive) {
                newNode = new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue());
                positiveNode.add(newNode);
            }
            for (Param p : negative) {
                newNode = new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue());
                negativeNode.add(newNode);
            }
        }
    }

    private void addPublicParamsToTree(DefaultMutableTreeNode myRoot, List params) {
        for (Param p : params) {
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(String.valueOf(p.getName()) + " = " + p.getValue());
            myRoot.add(newNode);
        }
    }

    public void addMyProposal(Proposal proposal) {
        if (proposal != null) {
            ++this.totalProposals;
            DefaultMutableTreeNode newProposalNode = new DefaultMutableTreeNode("my proposal num. " + this.totalProposals);
            newProposalNode.add(new DefaultMutableTreeNode("Price: " + proposal.getTotalPrice()));
            newProposalNode.add(new DefaultMutableTreeNode("Proposal time: " + proposal.getProposalTime()));
            newProposalNode.add(new DefaultMutableTreeNode("RequestID: " + proposal.getRequestid()));
            DefaultMutableTreeNode newCoverage = new DefaultMutableTreeNode("coverage");
            newProposalNode.add(newCoverage);
            for (ItemCoverage c : proposal.getItemCoverage()) {
                DefaultMutableTreeNode coverNode = new DefaultMutableTreeNode(String.valueOf(c.getItemid()) + " = " + c.getCoverage() * 100.0 + "%");
                newCoverage.add(coverNode);
            }
            this.proposalsRootNode.add(newProposalNode);
            this.proposalNodes.addLast(newProposalNode);
            ++this.proposalsOnScreen;
            if (this.proposalsOnScreen > 20) {
                --this.proposalsOnScreen;
                DefaultMutableTreeNode oldNode = (DefaultMutableTreeNode)this.proposalNodes.getFirst();
                this.proposalsRootNode.remove(oldNode);
                this.proposalNodes.removeFirst();
            }
            this.proposalsTreeModel.reload(this.proposalsRootNode);
        }
    }

    @Override
    public void setVisible(boolean parm1) {
        if (!parm1) {
            Point p = this.getLocation();
            this.store.putInt(STORE_WINDOW_X, p.x);
            this.store.putInt(STORE_WINDOW_Y, p.y);
            Dimension d = this.getSize();
            this.store.putInt(STORE_WINDOW_WIDTH, d.width);
            this.store.putInt(STORE_WINDOW_HEIGHT, d.height);
        } else if (this.store.exist(STORE_WINDOW_X)) {
            Point loc = this.getLocation();
            int x = this.store.getInt(STORE_WINDOW_X, loc.x);
            int y = this.store.getInt(STORE_WINDOW_Y, loc.y);
            this.setLocation(x, y);
            Dimension d = this.getPreferredSize();
            int w = this.store.getInt(STORE_WINDOW_WIDTH, d.width);
            int h = this.store.getInt(STORE_WINDOW_HEIGHT, d.height);
            this.setSize(w, h);
        }
        super.setVisible(parm1);
    }

    public void setRenegade() {
        this.jTabbedPane1.setBackground(Color.red);
        this.setTitle(String.valueOf(this.getTitle()) + " - renegade");
    }

    public void setDefaulter() {
        this.jTabbedPane1.setBackground(Color.blue);
        this.setTitle(String.valueOf(this.getTitle()) + " - defaluter");
    }

    public void addColaition(String coalition) {
        this.jTextCoalitions.append(String.valueOf(coalition) + "\n");
    }
}

