/*
 * Decompiled with CFR 0.152.
 */
package across.agents.transporter;

import across.agents.transporter.gui.TransporterAgentGUI;
import across.agents.transporter.task.TransporterIdleTask;
import across.agents.transporter.util.checker.DebugRestrictionsChecker;
import across.agents.transporter.util.checker.RestrictionsChecker;
import across.data.AcrossMapNodes;
import across.data.ItemCoverage;
import across.data.Page;
import across.data.Param;
import across.data.PrivateParams;
import across.data.Proposal;
import across.data.PublicParams;
import across.data.Resource;
import across.data.SemiPrivateParams;
import across.data.TeamProposal;
import across.data.TransportBatch;
import across.data.TransportCfp;
import across.util.GoodsConstants;
import across.util.InterLinguaTools;
import across.util.skn.AgentKnowledge;
import across.util.skn.AllianceKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.ServiceKnowledge;
import across.util.skn.listeners.NewAgentRegisteredListener;
import across.util.skn.update.UpdateListener;
import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.protocol.request.RequestInitiatorTask;
import aglobex.protocol.subscribe.SubscribeInitiatorTask;
import aglobex.protocol.subscribe.SubscribeParticipantTask;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;
import aglobex.simulation.protocol.cnp.CNPTaskOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TransporterAgent
extends CMAgent
implements CNPTaskOwner,
GISTopicListener,
NewAgentRegisteredListener,
ClientServerTopicConstants {
    public static final String TYPE = "Transporter";
    public RestrictionsChecker restrictionsChecker;
    public boolean isRenegade = false;
    public double fraudProbability = 0.0;
    public PublicParams publicParams;
    public SemiPrivateParams semiPrivateParams;
    public PrivateParams privateParams;
    public String myAlliance = null;
    public String myDriversAlliance;
    public GISClientService.Shell gisShell;
    protected DirectoryService.Shell dsShell;
    protected long currentTime = 0L;
    public CommunityKnowledge community = new CommunityKnowledge(this);
    public TransporterAgentGUI gui;
    public Collection<SubscribeParticipantTask> publicSubscribers = new LinkedList<SubscribeParticipantTask>();
    public Collection<SubscribeParticipantTask> semiPrivateSubscribers = new ArrayList<SubscribeParticipantTask>();
    public Map<String, SubscribeParticipantTask> reputationObservationSubscribers = new LinkedHashMap<String, SubscribeParticipantTask>();
    public Map<String, SubscribeParticipantTask> reputationValuesSubscribers = new LinkedHashMap<String, SubscribeParticipantTask>();
    public AcrossMapNodes acrossMapNodes = null;
    public boolean subcontractAllowed = false;
    private long changeCount = 4L;
    protected EntityDescriptor entityDescriptor;
    protected String location;

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        if (this.gisShell == null) {
            this.logSevere("GISSevice unavailiable!");
            this.stop();
            return;
        }
        this.dsShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.gisShell == null) {
            this.logSevere("DirectorySevice unavailiable!");
            this.stop();
            return;
        }
        this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
        this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
        this.myDriversAlliance = String.valueOf(this.getName()) + "_DRIVERS";
        this.gui = new TransporterAgentGUI(this, this.community);
        this.gui.setTitle(ai.getReadableName());
        this.gui.setBounds(0, 0, 400, 300);
        this.setIdleTask(new TransporterIdleTask(this));
    }

    protected void setupRestrictionChecker() {
        this.restrictionsChecker = new DebugRestrictionsChecker(this);
    }

    protected void directoryRegisterAndSubscribe() {
        this.community.subscribeNewAgentRegisteredListener(this);
        UpdateListener ulist = new UpdateListener(this.community, this);
        if (this.dsShell != null && this.gisShell != null) {
            ArrayList<String> transporters = new ArrayList<String>();
            transporters.add(TYPE);
            try {
                this.dsShell.register((ElementaryEntity)this, transporters);
                this.dsShell.subscribe(ulist, TYPE);
                this.dsShell.subscribe(ulist, "Location");
                this.dsShell.subscribe(ulist, "Driver");
            }
            catch (DirectoryException e) {
                this.logger.severe("Directory Service exception during registration.: " + e + e.getMessage() + e.getStackTrace());
            }
        } else {
            this.logger.severe("Directory Service not found on container: " + this.getContainer().getContainerName());
        }
    }

    private void updateMyPublicInfo() {
        if (this.publicParams == null) {
            this.logSevere("Null public parameters at: " + this.getName());
            return;
        }
        this.gui.setPublic(this.publicParams);
        Page page = new Page();
        page.setName(this.getAddress().getName());
        page.setAddress(this.getAddress());
        page.setPublicParams(this.publicParams);
        page.getPublicParams().setType(TYPE);
        this.community.agentPageUpdated(this.getAddress(), this.publicParams, this.getContainer().getContainerName());
        this.restrictionsChecker.agentPageUpdated(page);
        for (SubscribeParticipantTask spt : this.semiPrivateSubscribers) {
            spt.informResult(page);
        }
        this.gisShell.submitTopic("PAGE_UPDATE", page);
        this.gisShell.submitTopic("VISIO_INFO", "<c00FF00>" + this.getContainer().getContainerName(), null);
    }

    private void handleConfiguration() {
        if (this.entityDescriptor == null) {
            this.logSevere("Cannot configure transporter");
            throw new RuntimeException("Cannot configure transporter");
        }
        this.setupRestrictionChecker();
        this.privateParams = (PrivateParams)this.entityDescriptor.confObjects.get("TRANSPORTER_PRIVATE_PARAMS");
        this.publicParams = (PublicParams)this.entityDescriptor.confObjects.get("TRANSPORTER_PUBLIC_PARAMS");
        this.location = this.entityDescriptor.confParamsString.get("ENTITY_START_NODE");
        this.setupSemiPrivateFromPrivate();
        this.gui.setPublic(this.publicParams);
        this.acrossMapNodes = (AcrossMapNodes)this.entityDescriptor.typeDescriptor.userObjects.get("MAP_NODES");
        for (Param param : this.publicParams.getParam()) {
            if (!"TRANSPORTER_SUBCONTRACT_ALLOWED".equalsIgnoreCase(param.getName())) continue;
            this.subcontractAllowed = Boolean.valueOf(param.getValue());
        }
        this.community.agentPageUpdated(this.getAddress(), this.publicParams, this.getContainer().getContainerName());
        AgentKnowledge ak = this.community.getOwnerAgentKnowledge();
        if (ak != null) {
            ak.updateSemiPrivateParams(this.semiPrivateParams);
        }
        this.createNewAlliance();
        this.scheduleEvent(new Runnable(){

            @Override
            public void run() {
                TransporterAgent.this.startTaskChangeAlliance();
            }
        }, (long)(2000.0 * Math.random() + 2000.0));
        this.directoryRegisterAndSubscribe();
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION")) {
            if (content instanceof EntityDescriptor) {
                this.entityDescriptor = (EntityDescriptor)content;
                this.handleConfiguration();
            }
        } else if (topic.equalsIgnoreCase("SIMULATION_TIME_UPDATE_1_SECOND")) {
            this.updateMyPublicInfo();
            this.currentTime = Long.parseLong((String)content);
        } else {
            this.logSevere("Unexpected topic: " + topic);
        }
    }

    @Override
    public void handleNewAgentRegistered(AgentKnowledge agent) {
        for (ServiceKnowledge serviceKnowledge : agent.servicesProvided) {
            if ("Driver".equalsIgnoreCase(serviceKnowledge.serviceName)) {
                for (Resource resource : this.privateParams.getResource()) {
                    if (!agent.address.getName().equalsIgnoreCase(resource.getResid())) continue;
                    SubscribeInitiatorTask task = new SubscribeInitiatorTask(this, agent.address, (Object)this.location, false){
                        boolean agreed;
                        AgentKnowledge ak;
                        {
                            this.agreed = false;
                            this.ak = null;
                        }

                        @Override
                        protected void subscribeInformResult(Object object) {
                            if (!this.agreed) {
                                this.subscribeAgreed();
                            }
                            if (this.ak != null && this.ak.alliance != null && this.ak.alliance.getName().equalsIgnoreCase(TransporterAgent.this.myDriversAlliance)) {
                                Resource car = null;
                                for (Resource carRes : TransporterAgent.this.privateParams.getResource()) {
                                    if (!carRes.getResid().equalsIgnoreCase(this.participant.getName())) continue;
                                    car = carRes;
                                    break;
                                }
                                if (car != null) {
                                    car.setAvailabilityTime(TransporterAgent.this.currentTime);
                                    car.setLastLocation((String)object);
                                    TransporterAgent.this.setupSemiPrivateFromPrivate();
                                    TransporterAgent.this.broadcastSemiPrivateToAlliance();
                                }
                            } else {
                                TransporterAgent.this.logger.severe(" ++++ Received information from driver, unused. Transporter: " + this.getAddress().getName() + " driver: " + this.participant + " loc: " + object);
                            }
                        }

                        @Override
                        protected void subscribeAgreed() {
                            AgentKnowledge driver = TransporterAgent.this.community.agents.get(this.participant.getName());
                            if (driver != null) {
                                driver.enterAlliance(TransporterAgent.this.myDriversAlliance);
                                this.ak = TransporterAgent.this.community.getAgent(this.participant.getName());
                                this.agreed = true;
                            }
                        }

                        @Override
                        protected void subscribeRefused() {
                            TransporterAgent.this.logger.severe("Driver " + this.subscribeContent + " has refused my subscribe.");
                        }
                    };
                    task.start();
                }
                continue;
            }
            if (!TYPE.equalsIgnoreCase(serviceKnowledge.serviceName) || this.getAddress().equals(agent.address)) continue;
            SubscribeInitiatorTask task = new SubscribeInitiatorTask(this, agent.address, (Object)"PUBLIC_INFO_REQUEST", false){

                @Override
                protected void subscribeInformResult(Object object) {
                    Page page = (Page)object;
                    TransporterAgent.this.community.agentPageUpdated(page.getAddress(), page.getPublicParams());
                    TransporterAgent.this.restrictionsChecker.agentPageUpdated(page);
                }

                @Override
                protected void subscribeAgreed() {
                }

                @Override
                protected void subscribeRefused() {
                    TransporterAgent.this.logger.severe("Transporter " + this.subscribeContent + " has refused my subscribe.");
                }
            };
            task.start();
        }
    }

    public void setupSemiPrivateFromPrivate() {
        Collection<String> availableActions;
        this.semiPrivateParams = new SemiPrivateParams();
        Map<String, Resource> resbytype = GoodsConstants.getCargoTypesResourceMap();
        for (Resource res : this.privateParams.getResource()) {
            Resource newRes;
            availableActions = this.restrictionsChecker.getAvailableActions(res);
            if (availableActions != null && availableActions.size() > 0) {
                res.getAvailableAction().addAll(availableActions);
            }
            if ((newRes = resbytype.get(res.getType())) != null) {
                if (res.getAvailabilityTime() > this.currentTime) continue;
                newRes.setCapacity(newRes.getCapacity() + res.getCapacity());
                continue;
            }
            this.logger.warning("Unknown resource type in private params: " + res.getType());
        }
        for (Resource resource : resbytype.values()) {
            if (0L >= resource.getCapacity()) continue;
            resource.setResid(String.valueOf(this.getName()) + resource.getType());
            availableActions = this.restrictionsChecker.getAvailableActions(resource);
            if (availableActions != null && availableActions.size() > 0) {
                resource.getAvailableAction().addAll(availableActions);
            }
            this.semiPrivateParams.getResource().add(resource);
        }
        this.gui.setSemi(this.semiPrivateParams);
    }

    protected void setAlliance(String alliance) {
        this.logger.fine(String.valueOf(this.getName()) + " new alliance ->" + alliance);
        this.myAlliance = alliance;
        boolean changed = false;
        for (Param param : this.publicParams.getParam()) {
            if (!"TRANSPORTER_PARAM_ALLIANCE_NAME".equalsIgnoreCase(param.getName())) continue;
            param.setValue(alliance);
            changed = true;
        }
        if (!changed) {
            Param newParam = new Param();
            newParam.setName("TRANSPORTER_PARAM_ALLIANCE_NAME");
            newParam.setValue(alliance);
            this.publicParams.getParam().add(newParam);
        }
        this.community.setAlliance(alliance);
        this.updateMyPublicInfo();
    }

    public static String getAlliance(Page page) {
        return TransporterAgent.getPageValue(page, "TRANSPORTER_PARAM_ALLIANCE_NAME");
    }

    public static String getPageValue(Page page, String paramName) {
        return InterLinguaTools.getParamValue(page.getPublicParams().getParam(), paramName);
    }

    protected boolean isAllianceLeader() {
        return this.myAlliance.startsWith(this.getAddress().getName());
    }

    protected void startTaskChangeAlliance() {
        if (this.changeCount <= 0L) {
            return;
        }
        --this.changeCount;
        AllianceKnowledge ak = this.community.getAlliance(this.myAlliance);
        if (ak == null || ak.getAllMembersCount() == 1L) {
            LinkedList<Address> possibleAlliances = this.findAlliances();
            this.tryToJoinAlliances(possibleAlliances);
        }
    }

    protected void tryToJoinAlliances(List possibleAlliances) {
        Page content = this.createJoinAllianceContent();
        if (possibleAlliances.size() > 0) {
            Address a = (Address)possibleAlliances.remove(0);
            if (!this.myAlliance.equalsIgnoreCase(this.community.getAgent((String)a.getName()).alliance.getName())) {
                SeqRequestInitiatorTask task = new SeqRequestInitiatorTask(this, a, content, false, possibleAlliances);
                task.start();
            } else {
                this.scheduleEvent(new Runnable(){

                    @Override
                    public void run() {
                        TransporterAgent.this.startTaskChangeAlliance();
                    }
                }, (long)(2000.0 * Math.random() + 2000.0));
            }
        }
    }

    public void createNewAlliance() {
        String newAllianceName = String.valueOf(this.getAddress().getName()) + "`s alliance";
        this.setAlliance(newAllianceName);
    }

    protected Page createJoinAllianceContent() {
        Page pg = new Page();
        pg.setName(this.getAddress().getName());
        pg.setAddress(this.getAddress());
        pg.setPublicParams(this.publicParams);
        return pg;
    }

    protected LinkedList<Address> findAlliances() {
        TreeMap<String, Address> acceptableAlliances = new TreeMap<String, Address>();
        for (AllianceKnowledge ak : this.community.alliances.values()) {
            if (ak.getName().equalsIgnoreCase(this.myDriversAlliance) || !this.allianceAcceptable(ak)) continue;
            acceptableAlliances.put(ak.getName(), ((AgentKnowledge)ak.pickRandomMember()).address);
        }
        return new LinkedList<Address>(acceptableAlliances.values());
    }

    public boolean allianceAcceptable(AllianceKnowledge ak) {
        if (ak != null) {
            for (AgentKnowledge member : ak.getAllMembers()) {
                if (this.restrictionsChecker.acceptAllianceMember(member)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean acceptAllianceMember(Message queryMessage, Address intermediary) {
        Page content = (Page)queryMessage.getContent();
        this.community.agentPageUpdated(content.getAddress(), content.getPublicParams());
        AgentKnowledge ak = this.community.getAgent(queryMessage.getSender().getName());
        if (ak != null) {
            return this.restrictionsChecker.acceptAllianceMember(ak);
        }
        return false;
    }

    public void updateSemiPrivate(Address agent, SemiPrivateParams params) {
        AgentKnowledge ak = this.community.getAgent(agent.getName());
        if (ak != null) {
            ak.updateSemiPrivateParams(params);
        }
    }

    public Collection<Address> getAllianceMembers() {
        AllianceKnowledge ak = this.community.alliances.get(this.myAlliance);
        if (ak != null) {
            return ak.getAllAgentsAddress(this.getAddress());
        }
        return new LinkedList<Address>();
    }

    public void broadcastSemiPrivateToAlliance() {
        for (SubscribeParticipantTask spt : this.semiPrivateSubscribers) {
            spt.informResult(this.semiPrivateParams);
        }
    }

    public void subscribeAndSendSemiPrivateInfo(Address address) {
        if (address != this.getAddress()) {
            SubscribeInitiatorTask task = new SubscribeInitiatorTask(this, address, this.semiPrivateParams, false){

                @Override
                protected void subscribeInformResult(Object result) {
                    if (result instanceof SemiPrivateParams) {
                        TransporterAgent.this.updateSemiPrivate(this.participant, (SemiPrivateParams)result);
                    } else {
                        TransporterAgent.this.logger.warning("Bad response type for semiPrivate subscribe: " + result);
                    }
                }
            };
            task.start();
        }
    }

    public boolean acceptTeam(TeamProposal teamProposal) {
        List<Address> teamMembers = teamProposal.getTeamMember();
        boolean aLeader = this.restrictionsChecker.acceptTeamLeader(teamProposal.getTeamLeader());
        boolean aProp = this.restrictionsChecker.acceptRequestedServices(teamProposal.getRequestedServices());
        if (aLeader && aProp) {
            for (Address member : teamMembers) {
                if (this.restrictionsChecker.acceptTeamMember(member)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double getCoalitionMemberQuality(TransportCfp cfp, Collection<Resource> requestedResources, Address member) {
        long sumReq = 0L;
        double quality = 0.0;
        if (requestedResources.size() > 0) {
            for (Resource resource : requestedResources) {
                long requestedCapacity = resource.getCapacity();
                if (requestedCapacity <= 0L) continue;
                sumReq += requestedCapacity;
                long agentCapacity = this.getAgentResource(member, resource.getType());
                quality += (double)Math.min(agentCapacity, requestedCapacity);
            }
            if (0L < sumReq) {
                quality /= (double)sumReq;
            }
        }
        return quality;
    }

    public long getAgentResource(Address agent, String resourceType) {
        SemiPrivateParams semiP;
        if (this.getAddress() == agent) {
            semiP = this.semiPrivateParams;
        } else {
            AgentKnowledge ak = this.community.getAgent(agent.getName());
            semiP = ak.semiPrivateParams;
        }
        if (semiP != null) {
            for (Resource resource : semiP.getResource()) {
                if (!resource.getType().equals(resourceType)) continue;
                return resource.getCapacity();
            }
        }
        return 0L;
    }

    public Proposal createTeamMemberProposal(TeamProposal teamProposal) {
        if (!this.acceptTeam(teamProposal)) {
            return null;
        }
        TransportCfp requestedResources = teamProposal.getRequestedServices();
        Proposal proposal = new Proposal();
        proposal.setProposalTime(this.currentTime);
        proposal.setRequestid(requestedResources.getRequestid());
        proposal.setTotalPrice(0L);
        List<ItemCoverage> itemCoverage = proposal.getItemCoverage();
        Map<String, Resource> agentResources = GoodsConstants.getCargoTypesResourceMap();
        for (Resource res : this.semiPrivateParams.getResource()) {
            agentResources.get(res.getType()).setCapacity(this.getAvailableResource(res.getType(), this.currentTime));
        }
        for (TransportBatch item : requestedResources.getTransportBatch()) {
            if (0L >= item.getCount()) continue;
            ItemCoverage coverage = new ItemCoverage();
            coverage.setItemid(item.getBatchid());
            long capacity = agentResources.get(GoodsConstants.resolveType(item.getComodityName())).getCapacity();
            long usedcap = Math.min(capacity, item.getCount());
            if (0L >= usedcap) continue;
            coverage.setCoverage((double)item.getCount() / (double)usedcap);
            itemCoverage.add(coverage);
            long price = this.computePrice(item, coverage);
            proposal.setTotalPrice(proposal.getTotalPrice() + price);
            agentResources.get(GoodsConstants.resolveType(item.getComodityName())).setCapacity(capacity - usedcap);
        }
        if (0L < proposal.getTotalPrice()) {
            return proposal;
        }
        return null;
    }

    protected long computePrice(TransportBatch item, ItemCoverage coverage) {
        return Math.round((double)item.getCount() * coverage.getCoverage() * 2.0 + 10.0);
    }

    protected long getAvailableResource(String cargoType, long startTime) {
        long result = 0L;
        for (Resource res : this.privateParams.getResource()) {
            if (!res.getType().equalsIgnoreCase(cargoType) || res.getAvailabilityTime() > startTime) continue;
            result += res.getCapacity();
        }
        return result;
    }

    public boolean receivedCFP(Message msg, CNPParticipantTask goodsRequestTask) {
        return false;
    }

    public long getTime() {
        return this.currentTime;
    }

    public CommunityKnowledge getCommunity() {
        return this.community;
    }

    public void receivedAdvTeamProposal(Message msg) {
        this.sendNotUnderstood(msg, "Capability not present AdvTeamProposal content not understood.");
    }

    public void receivedAdvTeamRequest(Message msg) {
        this.sendNotUnderstood(msg, "Capability not present AdvTeamProposal content not understood.");
    }

    class SeqRequestInitiatorTask
    extends RequestInitiatorTask {
        List addressListforTheNext;

        public SeqRequestInitiatorTask(CMAgent owner, Address participant, Object content, boolean start, List addressListforTheNext) {
            super(owner, participant, content, false);
            this.addressListforTheNext = addressListforTheNext;
            TransporterAgent.this.logger.fine(String.valueOf(TransporterAgent.this.getName()) + " alliance entry request sent to: " + participant.getName());
            if (start) {
                this.start();
            }
        }

        @Override
        protected void informDone() {
            AgentKnowledge particip = TransporterAgent.this.community.getAgent(this.participant.getName());
            AllianceKnowledge allik = particip.alliance;
            TransporterAgent.this.setAlliance(allik.getName());
            AllianceKnowledge alk = TransporterAgent.this.community.getAlliance(TransporterAgent.this.myAlliance);
            if (alk != null) {
                for (AgentKnowledge ak : alk.getAllMembers()) {
                    TransporterAgent.this.subscribeAndSendSemiPrivateInfo(ak.address);
                }
            }
            this.cancelTask();
        }

        @Override
        protected void informResult(Object result) {
            this.cancelTask();
            if (this.addressListforTheNext.size() > 0) {
                Address a = (Address)this.addressListforTheNext.remove(0);
                new SeqRequestInitiatorTask(TransporterAgent.this, a, this.content, true, this.addressListforTheNext);
            } else {
                TransporterAgent.this.scheduleEvent(new Runnable(){

                    @Override
                    public void run() {
                        TransporterAgent.this.startTaskChangeAlliance();
                    }
                }, (long)(2000.0 * Math.random() + 2000.0));
                TransporterAgent.this.logger.info(String.valueOf(TransporterAgent.this.getName()) + " rescheduling alliance entry, none found.");
            }
        }
    }
}

