/*
 * Decompiled with CFR 0.152.
 */
package across.agents.terrorists.driver;

import across.agents.terrorists.driver.TerDriverMovement;
import across.agents.terrorists.driver.util.ObstacleAdder;
import across.data.simulation.SimulationObject;
import across.data.simulation.SimulationObjectDescription;
import across.data.simulation.SimulationObjectLocation;
import aglobe.container.agent.Agent;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.SensorDescription;
import aglobex.simulation.ontology.entity.EntityDescriptor;

public class TerroristDriverAgent
extends Agent
implements ClientServerTopicConstants,
GISTopicListener,
DirectoryListener {
    protected GISClientService.Shell gisShell;
    protected DirectoryService.Shell dirShell;
    protected double velocity;
    protected double consumption;
    protected TerDriverMovement myMovement = new TerDriverMovement(this);
    private ObstacleAdder obstacleAdder = new ObstacleAdder(1000L, 20000L, 50);
    private int obstacleCounter = 0;

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.gisShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
            this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
            this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
            this.gisShell.subscribeTopic("SENSORY_DATA", this);
        } else {
            this.logSevere("Unable to locate GIS!");
            this.stop();
        }
        this.dirShell.subscribe(this, "EmergencyCentre");
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message");
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION")) {
            if (content instanceof EntityDescriptor) {
                this.handleConfiguration((EntityDescriptor)content);
            }
        } else if (topic.equalsIgnoreCase("ENTITY_CONTROL")) {
            this.myMovement.handleMovementTopic(content, reason);
            if (!this.myMovement.isOnRoute()) {
                this.myMovement.goToRandomLocation();
            }
        } else if (topic.equalsIgnoreCase("SIMULATION_TIME_UPDATE_1_SECOND")) {
            this.obstacleAdder.simulationTick();
            if (this.obstacleAdder.isReadyToAddObstacle() && this.addObstacle()) {
                this.obstacleAdder.obstacleAdded();
            }
            if (!this.myMovement.isOnRoute()) {
                this.myMovement.goToRandomLocation();
            }
        }
    }

    protected void handleConfiguration(EntityDescriptor ed) {
        this.velocity = Double.parseDouble(ed.confParamsString.get("VEHICLE_VELOCITY"));
        this.consumption = Double.parseDouble(ed.confParamsString.get("VEHICLE_CONSUMPTION"));
        this.myMovement.handleConfiguration(ed, this.velocity, this.consumption);
        SensorDescription sd = new SensorDescription();
        double range = ed.typeDescriptor.userParamsDouble.get("DRIVER_SENSOR_RANGE");
        AglobeParam rangeParam = new AglobeParam();
        rangeParam.setValue(Double.toString(range));
        sd.setSensorType("spherical");
        sd.getAglobeParam().add(rangeParam);
        this.gisShell.submitTopicToServer("REGISTER_SENSOR", sd);
        this.myMovement.goToRandomLocation();
        String visioInfo = "<b>" + this.getName();
        this.gisShell.submitTopicToServer("VISIO_INFO", visioInfo);
    }

    protected boolean addObstacle() {
        SimulationObject so = new SimulationObject();
        double[] position = this.myMovement.getPosition();
        if (position == null) {
            return false;
        }
        so.setSimulationClass("across.simulation.objects.ObjectBehaviour");
        SimulationObjectDescription sod = new SimulationObjectDescription();
        sod.setX(position[0]);
        sod.setY(position[1]);
        sod.setZ(new Double(0.0));
        sod.setName("BusCrash" + this.getName().substring("Terrorist".length()) + this.obstacleCounter);
        ++this.obstacleCounter;
        sod.setObjectType("ROAD_OBSTACLE");
        sod.setExtentOfFire(0);
        sod.setInsurgencyLevel(50);
        sod.setNumberOfWounded(10);
        sod.setConstructionDamage(0);
        so.setSimulationObjectDescription(sod);
        SimulationObjectLocation sol = new SimulationObjectLocation();
        sol.setStartLocation(this.myMovement.actualLoc);
        if (this.myMovement.headingTo == null) {
            sol.setEndLocation(this.myMovement.actualLoc);
        } else {
            sol.setEndLocation(this.myMovement.headingTo);
        }
        sod.setLocation(sol);
        this.gisShell.submitTopicToServer("TOPIC_SIMULATION_OBJECT", so, "CONTROL_CREATE_SIMULATION_OBJECT");
        this.gisShell.submitTopicToServer("VISIO_ACTION", "51", this.getAddress().toString());
        return true;
    }

    @Override
    public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }
}

