/*
 * Decompiled with CFR 0.152.
 */
package across.agents.pathfinding.tester;

import across.agents.driver.data.RoadInfo;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.agents.pathfinding.tester.PathfindingTesterAgent;
import across.data.AcrossMapArcs;
import across.data.AcrossMapDistances;
import across.data.AcrossMapNodes;
import across.data.Arc;
import across.data.Node;
import across.data.Waypoint;
import across.util.pathfinding.AStarModPathfinding;
import across.util.pathfinding.DijkstraPathfinding;
import across.util.pathfinding.Pathfinding;
import across.util.pathfinding.RoadEvaluator;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import java.util.LinkedList;
import java.util.List;

public class PathfindingTesterMovement {
    protected PathfindingTesterAgent owner;
    protected Pathfinding pathfinding;
    protected AcrossMapArcs arcsOfMap;
    protected LinkedList<String> locNames = new LinkedList();
    protected RoadInfo[][] roads;
    protected String actualLoc;
    protected LinkedList<Waypoint> waypoints = new LinkedList();
    protected double[] position;
    protected Arc currentArc;

    public PathfindingTesterMovement(PathfindingTesterAgent owner) {
        this.owner = owner;
    }

    public void handleConfiguration(EntityDescriptor ed, final double velocity, final double consumption) {
        this.actualLoc = ed.confParamsString.get("ENTITY_START_NODE");
        AcrossMapNodes amn = (AcrossMapNodes)ed.typeDescriptor.userObjects.get("MAP_NODES");
        this.arcsOfMap = (AcrossMapArcs)ed.typeDescriptor.userObjects.get("MAP_ARCS");
        AcrossMapDistances amd = (AcrossMapDistances)ed.typeDescriptor.userObjects.get("MAP_DISTANCES");
        this.locNames.clear();
        for (Node node : amn.getNode()) {
            this.locNames.add(node.getName());
        }
        long tick = System.nanoTime();
        long militick = System.currentTimeMillis();
        this.roads = new RoadInfo[this.locNames.size()][this.locNames.size()];
        for (Arc arc : this.arcsOfMap.getArc()) {
            RoadInfo roadInfo;
            int fromIndex = this.locNames.indexOf(arc.getFrom());
            int toIndex = this.locNames.indexOf(arc.getTo());
            double time = 10.0 * arc.getLength() / velocity;
            double price = 1.0 / arc.getQuality() * arc.getLength() * consumption / 100.0;
            this.roads[fromIndex][toIndex] = roadInfo = new RoadInfo(time, price);
            this.roads[toIndex][fromIndex] = roadInfo;
        }
        this.pathfinding = new DijkstraPathfinding(this.locNames, this.roads);
        System.out.print("InitTime = " + (System.currentTimeMillis() - militick) + " milis " + (System.nanoTime() - tick) + "nanos \n");
        tick = System.nanoTime();
        militick = System.currentTimeMillis();
        long[][] averageTime = new long[this.locNames.size()][2];
        int rep = 5;
        int i = 1;
        while (i <= rep) {
            int j = 0;
            for (String locName : this.locNames) {
                Route route = this.pathfinding.planRoute("Jakarta", locName, 1.0, 0.0);
                long[] lArray = averageTime[j];
                lArray[0] = lArray[0] + (System.nanoTime() - tick);
                ++j;
                tick = System.nanoTime();
                militick = System.currentTimeMillis();
            }
            ++i;
        }
        RoadEvaluator re = new RoadEvaluator(){

            @Override
            public double getPrice(Arc arc) {
                return 1.0 / arc.getQuality() * arc.getLength() * consumption / 100.0;
            }

            @Override
            public double getTime(Arc arc) {
                return 10.0 * arc.getLength() / velocity;
            }
        };
        tick = System.nanoTime();
        militick = System.currentTimeMillis();
        this.pathfinding = new AStarModPathfinding(amn.getNode(), this.arcsOfMap.getArc(), amd.getDistance(), re, new LinkedList<Arc>());
        System.out.print("InitTime = " + (System.currentTimeMillis() - militick) + " milis " + (System.nanoTime() - tick) + "nanos \n");
        tick = System.nanoTime();
        militick = System.currentTimeMillis();
        int i2 = 1;
        while (i2 <= rep) {
            int j = 0;
            for (String locName : this.locNames) {
                Route route = this.pathfinding.planRoute("Jakarta", locName, 1.0, 0.0);
                long[] lArray = averageTime[j];
                lArray[1] = lArray[1] + (System.nanoTime() - tick);
                ++j;
                tick = System.nanoTime();
                militick = System.currentTimeMillis();
            }
            ++i2;
        }
        long profitPerNode = 0L;
        long diff = 0L;
        int i3 = 0;
        while (i3 < this.locNames.size()) {
            diff = averageTime[i3][0] / (long)rep - averageTime[i3][1] / (long)rep;
            System.out.print(String.valueOf(this.locNames.get(i3)) + " Dijkstra: " + averageTime[i3][0] / (long)rep + " AStar: " + averageTime[i3][1] / (long)rep + " difference: " + diff + "\n");
            profitPerNode += diff;
            ++i3;
        }
        System.out.print(profitPerNode / (long)this.locNames.size());
    }

    protected Route planRoute(List<Waypoint> wpList, boolean byPrice) {
        Route route = new Route();
        String startPoint = this.waypoints.size() == 0 ? new String(this.actualLoc) : new String(this.waypoints.getLast().getLocationName());
        double taskTime = 0.0;
        double taskPrice = 0.0;
        for (Waypoint wp : wpList) {
            Route oneRoute = byPrice ? this.pathfinding.planRoute(startPoint, wp.getLocationName(), 0.0, 1.0) : this.pathfinding.planRoute(startPoint, wp.getLocationName(), 1.0, 0.0);
            if (oneRoute == null) continue;
            taskTime += oneRoute.getRouteInfo().routeTime;
            taskPrice += oneRoute.getRouteInfo().routePrice;
            startPoint = wp.getLocationName();
            route.addWaypoints(oneRoute.getWaypoints());
            route.addWaypoint(wp);
        }
        route.setRouteInfo(new RouteInfo(taskTime, taskPrice));
        return route;
    }
}

