/*
 * Decompiled with CFR 0.152.
 */
package across.agents.pathfinding.tester;

import across.agents.pathfinding.tester.PathfindingTesterMovement;
import aglobe.container.agent.Agent;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;

public class PathfindingTesterAgent
extends Agent
implements ClientServerTopicConstants,
GISTopicListener {
    protected GISClientService.Shell gisShell;
    protected double velocity;
    protected double consumption;
    protected PathfindingTesterMovement myMovement = new PathfindingTesterMovement(this);

    @Override
    protected void handleIncomingMessage(Message m) {
        this.logWarning("Unexpected message");
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION") && content instanceof EntityDescriptor) {
            this.handleConfiguration((EntityDescriptor)content);
        }
    }

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        if (this.gisShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
        } else {
            this.logSevere("Unable to locate GIS!");
            this.stop();
        }
    }

    protected void handleConfiguration(EntityDescriptor ed) {
        this.velocity = Double.parseDouble(ed.confParamsString.get("VEHICLE_VELOCITY"));
        this.consumption = Double.parseDouble(ed.confParamsString.get("VEHICLE_CONSUMPTION"));
        this.myMovement.handleConfiguration(ed, this.velocity, this.consumption);
        String visioInfo = "<b>" + this.getName();
        this.gisShell.submitTopicToServer("VISIO_INFO", visioInfo);
    }
}

