/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.task;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.NegativeStockException;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.task.CNPTransportManagerTask;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TransportCfp;
import across.util.GoodsConstants;
import across.util.skn.ServiceKnowledge;
import aglobe.container.task.ConversationUnit;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.util.Logger;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;
import aglobex.simulation.protocol.cnp.CNPTaskOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;

public class LocProposeGoodsTask
extends CNPParticipantTask {
    protected RequestList rl = null;
    public static final int TIMEOUT = 25000;
    private int minLotSize;

    public LocProposeGoodsTask(CNPTaskOwner owner, int msec, Message cfpMessage) {
        super((ConversationUnit)owner, msec, cfpMessage);
    }

    public void setMinLotSize(int minLotSize) {
        this.minLotSize = minLotSize;
    }

    @Override
    protected void prepareProposal() {
        block6: {
            try {
                long proposalprice = 100L;
                if (this.rl == null) {
                    long time;
                    Proposal prop;
                    this.rl = (RequestList)this.cfpMessage.getContent();
                    if (this.owner instanceof LocationAgent && (proposalprice = (prop = LocProposeGoodsTask.prepareProposalFromRequestListAndStock(this.rl, time = ((LocationAgent)this.owner).getCurrentTime(), proposalprice, ((LocationAgent)this.owner).books, this.getAddress().getContainerName(), this.minLotSize)).getTotalPrice()) > 0L) {
                        try {
                            ((LocationAgent)this.owner).books.registerProposedGoods(this.rl, prop);
                        }
                        catch (NegativeStockException e) {
                            Logger.logSevere(String.valueOf(this.getAddress().getName()) + "Goods are not available for proposal");
                            e.printStackTrace();
                        }
                        prop.setTotalPrice(proposalprice);
                        this.sendProposal(prop);
                        return;
                    }
                    this.sendRefuse();
                    ((LocationAgent)this.owner).gisShell.submitTopic("LOCATION_REFUSE", this.cfpMessage);
                    break block6;
                }
                this.sendNotUnderstood(this.cfpMessage, "Second request as a reply in existing conversation.");
            }
            catch (ClassCastException e) {
                Logger.logSevere("Bad CFP format;content type.: " + this.cfpMessage);
                e.printStackTrace();
            }
        }
    }

    public static Proposal prepareProposalFromRequestListAndStock(RequestList rl, long time, long startPrice, StockOfferDemand books, String containerName, int minLotSize) {
        Proposal prop = new Proposal();
        prop.setRequestid(rl.getRequestid());
        prop.setProposalTime(time);
        ListIterator<Batch> batchit = rl.getBatch().listIterator();
        long propPrice = 0L;
        while (batchit.hasNext()) {
            Batch batch = batchit.next();
            long sr = books.getAvailableStock(batch.getComodityName());
            if (sr <= (long)minLotSize) continue;
            long requestcount = batch.getCount();
            long avcount = Math.min(requestcount, sr);
            propPrice = avcount * (long)GoodsConstants.getCommodityPrice(batch.getComodityName());
            ItemCoverage ic = new ItemCoverage();
            ic.setItemid(batch.getBatchid());
            ic.setLocation(containerName);
            ic.setCoverage((double)avcount / (double)requestcount);
            prop.getItemCoverage().add(ic);
        }
        if (propPrice > 0L) {
            prop.setTotalPrice(startPrice + propPrice);
        } else {
            prop.setTotalPrice(0L);
        }
        return prop;
    }

    @Override
    protected void proposalAccepted(Message acceptMessage) {
        if (this.cfpMessage != null && this.submitedProposal != null) {
            RequestList req = (RequestList)this.cfpMessage.getContent();
            LocationAgent lowner = (LocationAgent)this.owner;
            Message m = acceptMessage.getReply();
            m.setPerformative("INFORM-DONE");
            try {
                this.sendMessage(m);
            }
            catch (InvisibleContainerException invisibleContainerException) {
                // empty catch block
            }
            if (req.getDeliveryLocation().equalsIgnoreCase(lowner.getContainer().getContainerName())) {
                CNPTransportManagerTask.requestLocalBatchLoading(lowner, req, (Proposal)this.submitedProposal, this.cfpMessage.getSender());
            } else {
                this.prepareTransport(req, lowner);
            }
        } else {
            Logger.logSevere(" *** " + this.getAddress().getName() + " Acceptance occured in the task before the list was initialized ?." + this.rl + " \n " + acceptMessage + "\n" + this.cfpMessage + "\nProposal: " + this.submitedProposal);
        }
        this.cancelTask();
    }

    protected void prepareTransport(RequestList req, LocationAgent lowner) {
        ((LocationAgent)this.owner).gisShell.submitTopicToServer("ACCEPTATTION_RECEIVED", this.cfpMessage);
        TransportCfp tcfp = CNPTransportManagerTask.prepareOutboundTransportCfp(this.cfpMessage, (Proposal)this.submitedProposal, ((LocationAgent)this.owner).getCurrentTime(), req.getDeliveryLocation(), lowner);
        if (tcfp != null) {
            ServiceKnowledge providers = (ServiceKnowledge)lowner.community.getServices().get("Transporter");
            Collection<Address> accessibleProviders = providers != null ? providers.getAccessibleProviders(null) : new ArrayList<Address>(0);
            new CNPTransportManagerTask(lowner, accessibleProviders, tcfp, req, (Proposal)this.submitedProposal, 17000, this);
            if (accessibleProviders.size() > 0) {
                ((LocationAgent)this.owner).gisShell.submitTopicToServer("VISIO_ACTION", Byte.toString((byte)12), this.getAddress().toString());
            }
        }
    }

    @Override
    protected void proposalRefused(Message refuseMessage) {
        try {
            if (this.cfpMessage != null && this.submitedProposal != null) {
                ((LocationAgent)this.owner).books.reservedGoodsRefused((RequestList)this.cfpMessage.getContent(), (Proposal)this.submitedProposal);
            } else {
                Logger.logSevere(" *** " + this.getAddress().getName() + " Refusal occured in the task before the list was initialized ?." + this.rl + " \n " + refuseMessage + "\nProposal: " + this.submitedProposal);
            }
        }
        catch (NegativeStockException e) {
            Logger.logSevere("Reserved goods not available for cancel when proposal was refused." + this.rl + " \n " + refuseMessage);
        }
    }

    void taskDone(Object content) throws InvisibleContainerException {
        if (!this.isCancelled()) {
            this.sendDone(content);
        }
    }

    void taskFailure(Object content) throws InvisibleContainerException {
        if (!this.isCancelled()) {
            this.sendFailure(content);
        }
    }
}

