/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.task;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.StoreRec;
import across.agents.location.task.LocProposeGoodsTask;
import across.agents.location.task.LocSubscribeParticipantTask;
import across.data.Batch;
import across.data.Page;
import across.data.RequestList;
import aglobe.container.task.Task;
import aglobe.ontology.Message;
import aglobex.protocol.request.RequestParticipantTask;
import aglobex.protocol.subscribe.SubscribeParticipantTask;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LocIdleTask
extends Task {
    protected LocationAgent owner;
    private HashMap<Long, LinkedHashMap<LocSubscribeParticipantTask, Batch>> timeouts;
    public static final String LOC_TIMEOUT = "Location timeout";

    public LocIdleTask(LocationAgent owner) {
        super(owner);
        this.owner = owner;
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        if ("SUBSCRIBE".equalsIgnoreCase(m.getProtocol())) {
            this.handleSubscribeProtocol(m);
        }
        if (m.getPerformative().equalsIgnoreCase("CFP")) {
            if (m.getContent() instanceof RequestList) {
                this.answerCNP(m);
            } else {
                this.handleGeneralCFP(m);
            }
        } else if (m.getPerformative().equalsIgnoreCase("REQUEST")) {
            if (m.getContent() instanceof Batch) {
                final Batch b = (Batch)m.getContent();
                long batchCount = b.getCount();
                if (batchCount < 0L) {
                    this.owner.gisShell.submitTopic("BATCH_LOADED_ON_LOCATION", (Batch)m.getContent());
                    System.out.println(String.valueOf(this.owner.getName()) + " LOAD ON LOCATION: " + b);
                    RequestParticipantTask task = new RequestParticipantTask(this.owner, m, false){

                        @Override
                        protected void processRequest(Message requestMessage) {
                            this.informDone();
                            this.cancelTask();
                        }
                    };
                    task.start();
                    b.setCount(-batchCount);
                    try {
                        this.owner.books.goodsReceived(b);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.owner.getLogger().warning(e.toString());
                    }
                } else if (batchCount > 0L) {
                    System.out.println(String.valueOf(this.owner.getName()) + " UNLOAD FROM LOCATION");
                    RequestParticipantTask task = new RequestParticipantTask(this.owner, m, false){

                        @Override
                        protected void processRequest(Message requestMessage) {
                            double successRate = LocIdleTask.this.owner.books.goodsUnload(b, 1.0, false);
                            if (successRate >= 1.0) {
                                LocIdleTask.this.owner.books.goodsUnload(b, 1.0, true);
                                LocIdleTask.this.owner.gisShell.submitTopic("BATCH_UNLOADED_FROM_LOCATION", b);
                                System.out.println(String.valueOf(LocIdleTask.this.owner.getName()) + " RECEIVE REQUEST - SENDING INFORM DONE" + b + "success rate" + successRate);
                                this.informDone();
                            } else {
                                System.out.println(String.valueOf(LocIdleTask.this.owner.getName()) + " RECEIVE REQUEST - SENDING FAILURE " + b + "success rate" + successRate);
                                this.failure(new Double(successRate));
                            }
                            this.cancelTask();
                        }
                    };
                    task.start();
                }
            } else {
                this.handleGeneralRequest(m);
            }
        } else if (m.getPerformative().equalsIgnoreCase("FAILURE") && m.getContent() instanceof RequestList) {
            this.handleAttackNotification(m);
        }
        this.owner.gui.setAll(this.owner.books);
    }

    private void handleSubscribeProtocol(Message msg) {
        if (msg.getSender() == this.owner.getAddress()) {
            return;
        }
        if ("PUBLIC_INFO_REQUEST".equals(msg.getContent())) {
            SubscribeParticipantTask task = new SubscribeParticipantTask(this.owner, msg, false){

                @Override
                protected void processSubscribe(Message subscribeMessage) {
                    Page pg = new Page();
                    pg.setName(this.owner.getAddress().getName());
                    pg.setAddress(this.owner.getAddress());
                    pg.setPublicParams(((LocationAgent)this.owner).page.getPublicParams());
                    this.informResult(pg);
                }
            };
            task.start();
        }
    }

    protected void handleAttackNotification(Message m) {
        RequestList r = (RequestList)m.getContent();
        for (Batch batch : r.getBatch()) {
            for (StoreRec sr : this.owner.books.getGoodsExpected()) {
                if (sr.getCommodity().compareTo(batch.getComodityName()) != 0) continue;
                sr.increase(batch);
            }
        }
    }

    private void handleGeneralCFP(Message m) {
        this.owner.logWarning(String.valueOf(this.owner.getName()) + " HANDLE GENERAL REQUEST");
    }

    protected void handleGeneralRequest(Message m) {
        this.owner.logWarning(String.valueOf(this.owner.getName()) + " HANDLE GENERAL REQUEST");
    }

    protected void answerCNP(Message m) {
        new LocProposeGoodsTask(this.owner, 25000, m);
    }

    public void handleTimeout() {
        LinkedHashMap<LocSubscribeParticipantTask, Batch> list;
        if (this.timeouts != null && (list = this.timeouts.get(this.owner.getCurrentTime())) != null) {
            for (Map.Entry<LocSubscribeParticipantTask, Batch> e : list.entrySet()) {
                LocSubscribeParticipantTask task = e.getKey();
                Batch batch = e.getValue();
                task.timeout(batch);
            }
            this.timeouts.remove(this.owner.getCurrentTime());
        }
    }

    protected boolean registerTimeout(Batch batch, LocSubscribeParticipantTask task) {
        LinkedHashMap<LocSubscribeParticipantTask, Batch> list;
        Long time;
        if (this.owner.getName().equals("Bandung")) {
            System.out.println(String.valueOf(this.owner.getName()) + " Registering timeout: " + batch);
        }
        if ((time = new Long(batch.getDeliveryTime())) <= this.owner.getCurrentTime()) {
            task.timeout(batch);
            return false;
        }
        if (this.timeouts == null) {
            this.timeouts = new HashMap();
            if (this.owner.getName().equals("Bandung")) {
                System.out.println(String.valueOf(this.owner.getName()) + " Registering timeout - creating new timeouts ");
            }
        }
        if ((list = this.timeouts.get(batch.getDeliveryTime())) == null) {
            list = new LinkedHashMap();
            if (this.owner.getName().equals("Bandung")) {
                System.out.println(String.valueOf(this.owner.getName()) + " Registering timeout - creating new list ");
            }
        } else {
            Batch b = list.get(task);
            if (b != null) {
                this.owner.getLogger().warning("Location: more timeout registration error");
            }
        }
        list.put(task, batch);
        this.timeouts.put(time, list);
        return true;
    }

    protected void deregisterTimeout(Batch batch, LocSubscribeParticipantTask task) {
        LinkedHashMap<LocSubscribeParticipantTask, Batch> list;
        if (this.timeouts != null && (list = this.timeouts.get(batch.getDeliveryTime())) != null) {
            list.remove(task);
        }
    }
}

