/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.task;

import across.agents.location.LocationAgent;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.util.Logger;
import aglobex.simulation.protocol.cnp.CNPInitiatorTask;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class LocAcquireGoodsTask
extends CNPInitiatorTask {
    RequestList cfpContent;
    HashMap<Address, Proposal> selectedProposalMap = new HashMap();
    protected GISClientService.Shell gisShell;
    public static final int TIMEOUT = 20000;

    public LocAcquireGoodsTask(LocationAgent cu, Collection<Address> participants, RequestList cfpContent, int timeout) {
        super(cu, participants, cfpContent, timeout, null, false);
        this.cfpContent = cfpContent;
        this.gisShell = cu.gisShell;
        LinkedList<Object> data = new LinkedList<Object>();
        data.add(cfpContent);
        data.add(participants);
        data.add(this.getAddress().getName());
        this.gisShell.submitTopic("LOCATION_CFP_AND_PARTICIPANTS", data);
        this.start();
    }

    public LocAcquireGoodsTask(LocationAgent cu, Collection<Address> participants, RequestList cfpContent, int timeout, String reason) {
        super(cu, participants, cfpContent, timeout, reason, false);
        this.cfpContent = cfpContent;
        this.gisShell = cu.gisShell;
        LinkedList<Object> data = new LinkedList<Object>();
        data.add(cfpContent);
        data.add(participants);
        data.add(this.getAddress().getName());
        this.gisShell.submitTopic("LOCATION_CFP_AND_PARTICIPANTS", data);
        this.start();
    }

    @Override
    protected List<Address> evaluateReplies() {
        TreeSet<ProposalWithUtil> sortedProposals = new TreeSet<ProposalWithUtil>();
        for (Message m : this.receivedOffers.values()) {
            if (!m.getPerformative().equalsIgnoreCase("PROPOSAL")) continue;
            try {
                Proposal prop = (Proposal)m.getContent();
                LinkedList<Object> data = new LinkedList<Object>();
                data.add(prop);
                data.add(m.getSender().getName());
                this.gisShell.submitTopic("LOCATION_RECEIVED_OFFER", data);
                double utility = 0.0;
                block3: for (Batch tb : this.cfpContent.getBatch()) {
                    for (ItemCoverage ic : prop.getItemCoverage()) {
                        if (ic.getItemid() != tb.getBatchid()) continue;
                        long available = Math.max(((LocationAgent)this.towner).books.getPrivateAndAvailableStock(tb.getComodityName()), 1L);
                        long demand = Math.max(((LocationAgent)this.towner).books.getDemand(tb.getComodityName()), 1L);
                        utility += (double)demand / (double)available * ic.getCoverage() * ic.getCoverage();
                        continue block3;
                    }
                }
                if (utility == 0.0) continue;
                double utilityPrice = 1000.0 / utility;
                sortedProposals.add(new ProposalWithUtil(m, utilityPrice));
            }
            catch (ClassCastException e) {
                Logger.logSevere("CFP answer Proposal recieved with wrong content - Proposal expected. From: " + m.getSender());
                this.sendNotUnderstood(m, "Wrong Content.");
            }
        }
        LinkedList<Address> selected = new LinkedList<Address>();
        long[] bookedCount = new long[this.cfpContent.getBatch().size()];
        Arrays.fill(bookedCount, 0L);
        for (ProposalWithUtil pwu : sortedProposals) {
            Message m = pwu.propMsg;
            Proposal prop = (Proposal)m.getContent();
            boolean isPossible = true;
            int i = 0;
            for (Batch tb : this.cfpContent.getBatch()) {
                for (ItemCoverage ic : prop.getItemCoverage()) {
                    if (ic.getItemid() != tb.getBatchid()) continue;
                    if (!((double)bookedCount[i] + (double)tb.getCount() * ic.getCoverage() > (double)tb.getCount() * 1.2)) break;
                    isPossible = false;
                    break;
                }
                if (!isPossible) break;
                ++i;
            }
            if (!isPossible) continue;
            int i2 = 0;
            for (Batch tb : this.cfpContent.getBatch()) {
                for (ItemCoverage ic : prop.getItemCoverage()) {
                    if (ic.getItemid() != tb.getBatchid()) continue;
                    int n = i2;
                    bookedCount[n] = (long)((double)bookedCount[n] + (double)tb.getCount() * ic.getCoverage());
                    break;
                }
                ++i2;
            }
            selected.add(m.getSender());
            this.gisShell.submitTopic("LOCATION_WINNER", m);
            this.selectedProposalMap.put(m.getSender(), prop);
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean evaluateAcceptReply(Message m) {
        if (!m.getPerformative().equalsIgnoreCase("FAILURE") && m.getPerformative().equalsIgnoreCase("INFORM-DONE")) {
            Proposal originalProposal = this.selectedProposalMap.get(m.getSender());
            if (this.participants.contains(m.getSender())) {
                if (m.getContent() != null) {
                    Proposal loadedGoods = (Proposal)m.getContent();
                    ((LocationAgent)this.towner).books.goodsAcquired(this.cfpContent, originalProposal, loadedGoods);
                } else {
                    ((LocationAgent)this.towner).books.goodsAcquired(this.cfpContent, originalProposal);
                }
            } else {
                Logger.logSevere("Done recieved from refused CFP participant: " + m + "\nParticipants: " + this.participants);
            }
        }
        Collection collection = this.participants;
        synchronized (collection) {
            block9: {
                this.participants.remove(m.getSender());
                if (this.participants.size() != 0) break block9;
                return false;
            }
            return true;
        }
    }

    @Override
    protected void evaluateAcceptTimeout() {
    }

    private class ProposalWithUtil
    implements Comparable {
        Message propMsg;
        double utilityPrice;

        public ProposalWithUtil(Message propMsg, double utilityPrice) {
            this.propMsg = propMsg;
            this.utilityPrice = utilityPrice;
        }

        public int compareTo(Object o) {
            double uDif = this.utilityPrice - ((ProposalWithUtil)o).utilityPrice;
            if (uDif == 0.0) {
                return this.propMsg.getSender().toString().compareTo(((ProposalWithUtil)o).propMsg.getSender().toString());
            }
            return (int)(uDif * 10000.0);
        }

        public boolean equals(Object o) {
            double uDif = this.utilityPrice - ((ProposalWithUtil)o).utilityPrice;
            if (uDif == 0.0) {
                return this.propMsg.getSender().toString().equals(((ProposalWithUtil)o).propMsg.getSender().toString());
            }
            return false;
        }
    }
}

