/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.task;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.NegativeStockException;
import across.agents.location.task.LocIdleTask;
import across.agents.location.task.LocProposeGoodsTask;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import across.data.TransportBatch;
import across.data.TransportCfp;
import aglobe.container.task.ConversationUnit;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AglobeParams;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.util.AglobeXMLtools;
import aglobex.simulation.protocol.cnp.CNPInitiatorTask;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class CNPTransportManagerTask
extends CNPInitiatorTask {
    LocationAgent owner;
    TransportCfp cfp;
    RequestList goodsCfp;
    Proposal goodsProposal;
    LocProposeGoodsTask creatorLocProposeGoodsTask;
    LocIdleTask idleTask;
    public static final int TIMEOUT = 17000;

    public CNPTransportManagerTask(LocationAgent owner, Collection participants, TransportCfp cfpContent, RequestList goods, Proposal goodsProposal, int timeout, LocIdleTask locIdleTask) {
        super(owner, participants, cfpContent, timeout, null, false);
        this.owner = owner;
        this.cfp = cfpContent;
        this.cfp.setRequestid(String.valueOf(this.cfp.getRequestid()) + "-" + owner.getName());
        this.goodsCfp = goods;
        this.idleTask = locIdleTask;
        this.goodsProposal = goodsProposal;
        this.start();
    }

    public CNPTransportManagerTask(LocationAgent owner, Collection participants, TransportCfp cfpContent, RequestList goods, Proposal goodsProposal, int timeout, LocProposeGoodsTask creatorLocProposeGoodsTask) {
        super(owner, participants, cfpContent, timeout, null, false);
        this.owner = owner;
        this.cfp = cfpContent;
        this.cfp.setRequestid(String.valueOf(this.cfp.getRequestid()) + "-" + owner.getName());
        this.goodsCfp = goods;
        this.creatorLocProposeGoodsTask = creatorLocProposeGoodsTask;
        this.goodsProposal = goodsProposal;
        this.start();
    }

    protected List evaluateReplies() {
        LinkedList<Address> selected = new LinkedList<Address>();
        Message bestOffer = null;
        double bestCoverage = 0.0;
        long bestPrice = Long.MAX_VALUE;
        for (Message m : this.receivedOffers.values()) {
            if (!m.getPerformative().equalsIgnoreCase("PROPOSAL")) continue;
            try {
                Proposal prop = (Proposal)m.getContent();
                if (prop == null) continue;
                long price = prop.getTotalPrice();
                double coverage = 0.0;
                long total = 0L;
                ListIterator<TransportBatch> i = this.cfp.getTransportBatch().listIterator();
                block13: while (i.hasNext()) {
                    TransportBatch tb = i.next();
                    total += tb.getCount();
                    for (ItemCoverage ic : prop.getItemCoverage()) {
                        if (ic.getItemid() != tb.getBatchid()) continue;
                        coverage += (double)tb.getCount() * ic.getCoverage();
                        continue block13;
                    }
                }
                coverage = 0L != total ? (coverage /= (double)total) : 1.0;
                if (!(coverage > bestCoverage) && (coverage != bestCoverage || price >= bestPrice)) continue;
                bestOffer = m;
                bestPrice = price;
                bestCoverage = coverage;
            }
            catch (ClassCastException e) {
                this.owner.getLogger().severe("Unexpected content type in cfp answer - proposal expected. Message:\n " + m);
            }
        }
        if (bestOffer != null) {
            selected.add(bestOffer.getSender());
            GISClientService.Shell gisShell = this.owner.gisShell;
            try {
                this.owner.books.reservedGoodsAccepted(this.goodsCfp, this.goodsProposal, (Proposal)bestOffer.getContent());
            }
            catch (NegativeStockException e) {
                this.owner.getLogger().severe("Reserved goods not available for change when proposal was accepted." + this.goodsCfp + " \n " + this.goodsProposal);
                try {
                    if (this.creatorLocProposeGoodsTask != null) {
                        this.creatorLocProposeGoodsTask.taskFailure(bestOffer.getContent());
                    }
                }
                catch (InvisibleContainerException e1) {
                    this.owner.getLogger().severe("Error: FAILURE message not sent to the client as areply to: " + this.goodsProposal);
                }
            }
        } else {
            try {
                if (this.creatorLocProposeGoodsTask != null) {
                    this.creatorLocProposeGoodsTask.taskFailure(null);
                }
            }
            catch (InvisibleContainerException gisShell) {
                // empty catch block
            }
            try {
                this.owner.books.reservedGoodsRefused(this.goodsCfp, this.goodsProposal);
            }
            catch (NegativeStockException gisShell) {
                // empty catch block
            }
            return selected;
        }
        try {
            if (this.creatorLocProposeGoodsTask != null) {
                this.creatorLocProposeGoodsTask.taskDone(bestOffer.getContent());
            }
        }
        catch (InvisibleContainerException gisShell) {
            // empty catch block
        }
        AglobeParams logParams = new AglobeParams();
        logParams.getAglobeParam().add(AglobeXMLtools.makeAglobeParam("name", this.owner.getName()));
        logParams.getAglobeParam().add(AglobeXMLtools.makeAglobeParam("CFP best coverage", Double.toString(bestCoverage)));
        this.owner.gisShell.submitTopicToServer("TEST_DATA", logParams);
        return selected;
    }

    @Override
    protected boolean evaluateAcceptReply(Message m) {
        if (!m.getPerformative().equalsIgnoreCase("FAILURE")) {
            m.getPerformative().equalsIgnoreCase("INFORM-DONE");
        }
        return true;
    }

    @Override
    protected void evaluateAcceptTimeout() {
    }

    public static TransportCfp prepareInboundTransportCfp(RequestList goodsCfp, Message acceptedGoodsProposal, long time, String targetLocation, LocationAgent owner) {
        TransportCfp cfp = new TransportCfp();
        cfp.setRequestid(goodsCfp.getRequestid());
        cfp.setRequestTime(time);
        block2: for (Batch b : goodsCfp.getBatch()) {
            for (ItemCoverage ic : ((Proposal)acceptedGoodsProposal.getContent()).getItemCoverage()) {
                if (ic.getItemid() != b.getBatchid() || !(ic.getCoverage() > 0.0)) continue;
                if (!ic.getLocation().equalsIgnoreCase(targetLocation)) {
                    TransportBatch tb = new TransportBatch();
                    tb.setBatchid(b.getBatchid());
                    tb.setComodityName(b.getComodityName());
                    tb.setCount((long)Math.floor((double)b.getCount() * ic.getCoverage()));
                    tb.setStart(ic.getLocation());
                    tb.setStartAddress(acceptedGoodsProposal.getSender());
                    tb.setTargetAddress(owner.getAddress());
                    tb.setTarget(targetLocation);
                    tb.setStartTime(time);
                    tb.setTargetTime(time);
                    cfp.getTransportBatch().add(tb);
                    continue block2;
                }
                Message loadReq = Message.newInstance("REQUEST", owner.getAddress(), acceptedGoodsProposal.getSender());
                loadReq.setProtocol("REQUEST");
                Batch batch = new Batch();
                batch.setBatchid(b.getBatchid());
                batch.setComodityName(b.getComodityName());
                batch.setCount((long)Math.floor((double)b.getCount() * ic.getCoverage()));
                batch.setDeliveryTime(b.getDeliveryTime());
                loadReq.setContent(batch);
                try {
                    owner.sendMessage(loadReq);
                    owner.books.goodsReceived(b);
                }
                catch (InvisibleContainerException invisibleContainerException) {}
                continue block2;
            }
        }
        if (!cfp.getTransportBatch().isEmpty()) {
            return cfp;
        }
        return null;
    }

    public static TransportCfp prepareOutboundTransportCfp(Message cfpMessage, Proposal submitedProposal, long currentTime, String targetLocation, ConversationUnit owner) {
        return CNPTransportManagerTask.prepareTransportCfp((RequestList)cfpMessage.getContent(), submitedProposal, currentTime, owner.getConversationManager().getElementaryConversationEntity().getContainer().getContainerName(), owner.getConversationManager().getElementaryConversationEntity().getAddress(), targetLocation, cfpMessage.getSender());
    }

    public static TransportCfp prepareTransportCfp(RequestList goodsCfp, Proposal acceptedGoodsProposal, long time, String startLocation, Address startAddress, String targetLocation, Address targetAddress) {
        TransportCfp cfp = new TransportCfp();
        cfp.setRequestid(goodsCfp.getRequestid());
        cfp.setRequestTime(time);
        block0: for (Batch b : goodsCfp.getBatch()) {
            for (ItemCoverage ic : acceptedGoodsProposal.getItemCoverage()) {
                if (ic.getItemid() != b.getBatchid() || !(ic.getCoverage() > 0.0)) continue;
                TransportBatch tb = new TransportBatch();
                tb.setBatchid(b.getBatchid());
                tb.setComodityName(b.getComodityName());
                tb.setCount((long)Math.floor((double)b.getCount() * ic.getCoverage()));
                tb.setStart(startLocation);
                tb.setStartAddress(startAddress);
                tb.setTargetAddress(targetAddress);
                tb.setTarget(targetLocation);
                tb.setStartTime(time);
                tb.setTargetTime(time + 2L);
                cfp.getTransportBatch().add(tb);
                continue block0;
            }
        }
        if (!cfp.getTransportBatch().isEmpty()) {
            return cfp;
        }
        return null;
    }

    public static void requestLocalBatchLoading(LocationAgent owner, RequestList goodsCfp, Proposal acceptedGoodsProposal, Address targetAddress) {
        for (Batch b : goodsCfp.getBatch()) {
            for (ItemCoverage ic : acceptedGoodsProposal.getItemCoverage()) {
                if (ic.getItemid() != b.getBatchid() || !(ic.getCoverage() > 0.0)) continue;
                Message loadReq = Message.newInstance("REQUEST", owner.getAddress(), targetAddress);
                loadReq.setProtocol("REQUEST");
                Batch batch = new Batch();
                batch.setBatchid(b.getBatchid());
                batch.setComodityName(b.getComodityName());
                batch.setCount((long)Math.floor((double)b.getCount() * ic.getCoverage()));
                batch.setDeliveryTime(b.getDeliveryTime());
                loadReq.setContent(batch);
                try {
                    owner.sendMessage(loadReq);
                    owner.books.goodsReceived(b);
                }
                catch (InvisibleContainerException invisibleContainerException) {
                    // empty catch block
                }
            }
        }
    }
}

