/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.gui;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.accounts.StoreRec;
import across.agents.location.gui.GoodsTableModel;
import across.agents.location.gui.NewTransportRequestGUI;
import across.agents.location.gui.StatsTableModel;
import aglobe.container.Store;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;

public class LocationAgentGUI
extends JFrame {
    private final Store store;
    private static final String STORE_WINDOW_X = "gui/win_x";
    private static final String STORE_WINDOW_Y = "gui/win_y";
    private static final String STORE_WINDOW_WIDTH = "gui/win_width";
    private static final String STORE_WINDOW_HEIGHT = "gui/win_height";
    private LocationAgent owner = null;
    GoodsTableModel goodsTableModel = new GoodsTableModel();
    StatsTableModel statsTableModel = new StatsTableModel();
    DefaultTableModel locationsTableModel = new DefaultTableModel();
    DefaultTableModel transportersTableModel = new DefaultTableModel();
    private HashMap map = new HashMap();
    String[] goods = new String[]{"bread", "fish", "flour", "grain", "sheep", "water"};
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTable goodsTable = new JTable();
    JTree knownServiceProviders = new JTree();
    JScrollPane jScrollPane3 = new JScrollPane();
    JTable statsTable = new JTable();
    JTextField jTextField1 = new JTextField();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton newRequestButton = new JButton();

    public LocationAgentGUI(LocationAgent _owner) throws HeadlessException {
        this.owner = _owner;
        this.store = this.owner.getContainer().getAgentStore(this.owner.getName());
        try {
            this.jbInit();
            int i = 0;
            while (i < this.goods.length) {
                this.map.put(this.goods[i], new Integer(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jTextField1.setEditable(false);
        this.jTextField1.setSelectionStart(11);
        this.jTextField1.setText("mood:");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.newRequestButton.setText("New Request ...");
        this.newRequestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationAgentGUI.this.newRequestButton_actionPerformed(e);
            }
        });
        this.jTabbedPane1.add((Component)this.jScrollPane1, "Goods");
        this.jScrollPane1.getViewport().add((Component)this.goodsTable, null);
        this.jTabbedPane1.add((Component)this.jScrollPane2, "Known service providers");
        this.jTabbedPane1.add((Component)this.jScrollPane3, "stats");
        this.jScrollPane3.getViewport().add((Component)this.statsTable, null);
        this.jScrollPane2.getViewport().add((Component)this.knownServiceProviders, null);
        this.getContentPane().add((Component)this.jTextField1, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.newRequestButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jTabbedPane1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.knownServiceProviders.setModel(this.owner.community.getServiceProvidersTreeModel());
        this.knownServiceProviders.expandRow(0);
        this.goodsTable.setModel(this.goodsTableModel);
        this.statsTable.setModel(this.statsTableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(StockOfferDemand books) {
        StockOfferDemand stockOfferDemand = books;
        synchronized (stockOfferDemand) {
            this.goodsTableModel.putColumn(0, this.goods);
            this.goodsTableModel.putColumn(1, this.createColumn(books.getGoodsAvailable()));
            this.goodsTableModel.putColumn(2, this.createColumn(books.getGoodsPrivate()));
            this.goodsTableModel.putColumn(3, this.createColumn(books.getGoodsDemand()));
            this.goodsTableModel.putColumn(4, this.createColumn(books.getGoodsReserved()));
            this.goodsTableModel.putColumn(5, this.createColumn(books.getGoodsWaitingForPickUp()));
            this.goodsTableModel.putColumn(6, this.createColumn(books.getGoodsExpected()));
            this.statsTableModel.putColumn(0, this.goods);
            this.statsTableModel.putColumn(1, this.createColumn(books.getAgregateDemand()));
            this.statsTableModel.putColumn(2, this.createColumn(books.getAgregateReceived()));
            this.statsTableModel.putColumn(3, this.createColumn(books.getAgregateProduced()));
            this.statsTableModel.putColumn(4, this.createColumn(books.getAgregateSold()));
        }
        this.goodsTableModel.fireTableDataChanged();
        this.statsTableModel.fireTableDataChanged();
    }

    private String[] createColumn(Collection goodsColl) {
        String[] comodities = new String[this.goods.length];
        for (StoreRec sr : goodsColl) {
            int index = (Integer)this.map.get(sr.getCommodity());
            comodities[index] = Long.toString(sr.getCount());
        }
        return comodities;
    }

    public void setMood(double happy) {
        this.jTextField1.setText("happy: " + happy);
    }

    @Override
    public void setVisible(boolean parm1) {
        if (!parm1) {
            Point p = this.getLocation();
            this.store.putInt(STORE_WINDOW_X, p.x);
            this.store.putInt(STORE_WINDOW_Y, p.y);
            Dimension d = this.getSize();
            this.store.putInt(STORE_WINDOW_WIDTH, d.width);
            this.store.putInt(STORE_WINDOW_HEIGHT, d.height);
        } else if (this.store.exist(STORE_WINDOW_X)) {
            Point loc = this.getLocation();
            int x = this.store.getInt(STORE_WINDOW_X, loc.x);
            int y = this.store.getInt(STORE_WINDOW_Y, loc.y);
            this.setLocation(x, y);
            Dimension d = this.getPreferredSize();
            int w = this.store.getInt(STORE_WINDOW_WIDTH, d.width);
            int h = this.store.getInt(STORE_WINDOW_HEIGHT, d.height);
            this.setSize(w, h);
        }
        super.setVisible(parm1);
    }

    public void newRequestButton_actionPerformed(ActionEvent e) {
        String requestId = Long.toString(System.currentTimeMillis() % (long)this.owner.getAddress().hashCode() + (long)this.owner.hashCode());
        new NewTransportRequestGUI((Frame)this, true, requestId, this.owner).setVisible(true);
    }
}

