/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.generator;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.generator.Generator;

public class PopulationGenerator
extends Generator {
    public static final String NAME = "population";
    long popSize = 1000L;
    private double[] reqSatisfaction = new double[3];
    private int reqSatisfactionCurrentPos = 0;
    private static final int REQ_SAT_SIZE = 3;
    public long currentMood = 100L;
    public static final long MAX_MOOD = 100L;
    public static final long MIN_MOOD = 0L;
    public static final long DEADLY_MOOD = 50L;
    public static final long SUPERIOR_MOOD = 90L;
    private boolean goodsCommandMade = false;

    public PopulationGenerator(long popSize) {
        this.popSize = popSize;
    }

    @Override
    public long generationStep(Object weather, StockOfferDemand books, SimulationObjectsEffects effects) {
        double stepCoverage;
        if (!this.goodsCommandMade) {
            books.command("bread", 1L * this.popSize);
            books.command("water", 2L * this.popSize);
            books.command("fish", (long)(0.25 * (double)this.popSize));
            books.command("sheep", (long)(0.25 * (double)this.popSize));
            this.goodsCommandMade = true;
        }
        long breadDemand = 1L * this.popSize;
        long waterDemand = 2L * this.popSize;
        long fishDemand = (long)(0.25 * (double)this.popSize);
        long sheepDemand = (long)(0.25 * (double)this.popSize);
        double breadUnits = books.goodsRequired("bread", breadDemand);
        double waterUnits = books.goodsRequired("water", waterDemand);
        double fishUnits = books.goodsRequired("fish", fishDemand);
        double sheepUnits = books.goodsRequired("sheep", sheepDemand);
        this.reqSatisfaction[this.reqSatisfactionCurrentPos % 3] = stepCoverage = (breadUnits / (double)breadDemand + waterUnits / (double)waterDemand + fishUnits / (double)fishDemand + sheepUnits / (double)sheepDemand) / 4.0;
        ++this.reqSatisfactionCurrentPos;
        if (this.reqSatisfactionCurrentPos >= 2) {
            double avg = 0.0;
            int i = 0;
            while (i < this.reqSatisfaction.length) {
                avg += this.reqSatisfaction[i];
                ++i;
            }
            this.modifyMood(avg /= 3.0, books);
        }
        if (this.currentMood < 50L) {
            this.popSize = Math.max(1L, (long)Math.floor((double)this.popSize * 0.95 - 10.0));
        } else if (this.currentMood > 90L) {
            this.popSize = Math.min(20000L, (long)Math.floor((double)this.popSize * 1.05 + 10.0));
        }
        if (effects.getAggregateFire() > 0.0) {
            this.popSize /= 2L;
        }
        return this.popSize;
    }

    private void modifyMood(double avg, StockOfferDemand books) {
        if (avg > 0.9) {
            this.increaseMood(7L);
        } else if (avg > 0.8) {
            this.increaseMood(4L);
        } else if (!(avg > 0.6)) {
            if (avg > 0.3) {
                this.decreaseMood(3L);
            } else {
                this.decreaseMood(7L);
            }
        }
    }

    private void increaseMood(long i) {
        this.currentMood = Math.min(this.currentMood + i, 100L);
    }

    private void decreaseMood(long i) {
        this.currentMood = Math.max(this.currentMood - i, 0L);
    }

    public long getPopSize() {
        return this.popSize;
    }

    public long getCurrentMood() {
        return this.currentMood;
    }
}

