/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.generator;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.generator.Generator;
import across.data.Param;
import across.data.Weather;

public class MineGenerator
extends Generator {
    public static final String NAME = "mine";
    String commodity;
    long perStepQuantity = 1000L;

    public MineGenerator(String commodity, long perStepQuantity) {
        this.commodity = commodity;
        this.perStepQuantity = perStepQuantity;
    }

    @Override
    public long generationStep(Object weather, StockOfferDemand books, SimulationObjectsEffects effects) {
        long realQuant = this.perStepQuantity;
        if (weather != null && weather instanceof Weather) {
            Weather wea = (Weather)weather;
            for (Param wob : wea.getParam()) {
                Param wp = wob;
                if (!this.commodity.equalsIgnoreCase(wp.getName())) continue;
                double coeff = Double.parseDouble(wp.getValue());
                realQuant = (long)((double)realQuant * coeff);
            }
        }
        books.goodsCreated(this.commodity, realQuant);
        return realQuant;
    }
}

