/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.generator;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.generator.BakeryGenerator;
import across.agents.location.generator.MineGenerator;
import across.agents.location.generator.PopulationGenerator;
import across.data.Param;
import java.util.List;

public abstract class Generator {
    public abstract long generationStep(Object var1, StockOfferDemand var2, SimulationObjectsEffects var3);

    public static void initGenerators(List<Param> params, List<Generator> generators) {
        for (Param param : params) {
            if ("population".equalsIgnoreCase(param.getName())) {
                if (Integer.parseInt(param.getValue()) <= 0) continue;
                generators.add(new PopulationGenerator(Integer.parseInt(param.getValue())));
                continue;
            }
            if (param.getName().startsWith("mine")) {
                if (Integer.parseInt(param.getValue()) <= 0) continue;
                String com = param.getName().substring("mine".length());
                generators.add(new MineGenerator(com, Integer.parseInt(param.getValue())));
                continue;
            }
            if (!"bakery".equalsIgnoreCase(param.getName()) || Integer.parseInt(param.getValue()) <= 0) continue;
            generators.add(new BakeryGenerator(Integer.parseInt(param.getValue())));
        }
        if (generators.size() == 0) {
            generators.add(new PopulationGenerator(2000L));
            generators.add(new MineGenerator("water", 10000L));
            generators.add(new MineGenerator("grain", 1000L));
            generators.add(new MineGenerator("fish", 100L));
            generators.add(new BakeryGenerator(5000L));
        }
    }
}

