/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.generator;

import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.generator.Generator;

public class BakeryGenerator
extends Generator {
    public static final String NAME = "bakery";
    long nominalProductionCapacity;
    long currentCapacity;
    private boolean goodsCommandMade;

    public BakeryGenerator(long nominalProductionCapacity) {
        this.currentCapacity = this.nominalProductionCapacity = 1000L;
        this.goodsCommandMade = false;
        this.nominalProductionCapacity = nominalProductionCapacity;
        this.currentCapacity = nominalProductionCapacity;
    }

    @Override
    public long generationStep(Object weather, StockOfferDemand books, SimulationObjectsEffects effects) {
        long grain;
        long water;
        long quantity;
        if (!this.goodsCommandMade) {
            books.command("water", this.currentCapacity);
            books.command("grain", this.currentCapacity);
            this.goodsCommandMade = true;
        }
        if (books.getPrivateAndAvailableStock("bread") < this.currentCapacity * 10L && 0L < (quantity = Math.min(Math.min(water = books.getPrivateAndAvailableStock("water"), grain = books.getPrivateAndAvailableStock("grain")), this.currentCapacity))) {
            books.goodsConsumed("water", quantity);
            books.goodsConsumed("grain", quantity);
            books.goodsCreated("bread", (long)((double)quantity * 1.3));
        }
        return this.currentCapacity;
    }
}

