/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.accounts;

import across.agents.location.accounts.NegativeStockException;
import across.data.Batch;

public class StoreRec {
    private String commodity;
    private long count;

    protected StoreRec() {
    }

    public StoreRec(String commodity, long count) {
        this.commodity = commodity;
        this.count = count;
    }

    public long getCount() {
        return this.count;
    }

    public String getCommodity() {
        return this.commodity;
    }

    public void increase(long bcount) {
        this.count += bcount;
    }

    public void increase(Batch b) {
        this.count += b.getCount();
    }

    public boolean decrease(Batch b) {
        this.count -= Math.min(Math.max(0L, b.getCount()), this.count);
        return true;
    }

    public double decrease(Batch b, double requestedFill, boolean reallyUnload) {
        return 0.0;
    }

    public void decrease(long decr) {
        this.count -= decr;
    }

    public void decreaseNonNegative(Batch b) throws NegativeStockException {
        if (this.count >= b.getCount()) {
            this.count -= b.getCount();
        } else {
            throw new NegativeStockException("Received more goods than ordered.");
        }
    }

    public void decreaseNonNegative(Batch b, String error) throws NegativeStockException {
        if (this.count >= b.getCount()) {
            this.count -= b.getCount();
        } else {
            throw new NegativeStockException(error);
        }
    }

    public void decreaseNonNegative(long count) throws NegativeStockException {
        if (this.count >= count) {
            this.count -= count;
        } else {
            throw new NegativeStockException("Received more goods than ordered.");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.commodity);
        sb.append("\t");
        sb.append(this.count);
        return sb.toString();
    }
}

