/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.accounts;

import across.agents.location.LocationAgent;
import across.agents.location.accounts.DetailedStoreRec;
import across.agents.location.accounts.NegativeStockException;
import across.agents.location.accounts.StoreRec;
import across.agents.location.task.LocSubscribeParticipantTask;
import across.agents.location.util.LocationUtils;
import across.data.Batch;
import across.data.ItemCoverage;
import across.data.Proposal;
import across.data.RequestList;
import aglobe.container.transport.Address;
import aglobex.protocol.subscribe.SubscribeParticipantTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class StockOfferDemand {
    protected SimpleStore goodsDemand = new SimpleStore();
    protected SimpleStore privateStock = new SimpleStore();
    protected SimpleStore availableStock = new SimpleStore();
    protected DetailedStore reservedStock = new DetailedStore();
    protected DetailedStore waitingForPickUp = new DetailedStore();
    protected DetailedStore expectedGoods = new DetailedStore();
    protected SimpleStore agregateDemand = new SimpleStore();
    protected SimpleStore agregateReceived = new SimpleStore();
    protected SimpleStore agregateProduced = new SimpleStore();
    protected SimpleStore agregateSold = new SimpleStore();
    private long _id = System.currentTimeMillis();
    private HashMap<Long, LinkedHashMap<Address, LocSubscribeParticipantTask>> registeredBatches = null;
    private int minLotSize;

    public void setMinLotSize(int minLotSize) {
        this.minLotSize = minLotSize;
    }

    public synchronized List<RequestList> prepareSingleListGoodsDemand(LocationAgent agent, boolean dontMultiply) {
        LinkedList<RequestList> requestLists = new LinkedList<RequestList>();
        RequestList mainRequest = new RequestList();
        mainRequest.setDeliveryLocation(agent.getContainer().getContainerName());
        mainRequest.setDeliveryAddress(agent.getAddress());
        mainRequest.setRequestid(Long.toString(System.currentTimeMillis() % ((long)agent.getAddress().hashCode() * agent.getCurrentTime())));
        mainRequest.setRequestTime(agent.getCurrentTime());
        for (StoreRec lr : this.goodsDemand.values()) {
            long count = this.calcCommodityDemand(lr, dontMultiply);
            if (count < (long)this.minLotSize) continue;
            mainRequest.getBatch().add(LocationUtils.prepareGoodsCFPContent(agent, lr.getCommodity(), count));
        }
        requestLists.add(mainRequest);
        return requestLists;
    }

    public synchronized List prepareSingleBatchGoodsDemand(LocationAgent agent, boolean dontMultiply) {
        LinkedList<RequestList> requestLists = new LinkedList<RequestList>();
        for (StoreRec lr : this.goodsDemand.values()) {
            long count = this.calcCommodityDemand(lr, dontMultiply);
            if (count < (long)this.minLotSize) continue;
            RequestList req = new RequestList();
            req.setDeliveryLocation(agent.getContainer().getContainerName());
            req.setDeliveryAddress(agent.getAddress());
            req.setRequestid(Long.toString(System.currentTimeMillis() % ((long)agent.getAddress().hashCode() * agent.getCurrentTime()) + (long)lr.hashCode()));
            req.setRequestTime(agent.getCurrentTime());
            req.getBatch().add(LocationUtils.prepareGoodsCFPContent(agent, lr.getCommodity(), count));
            requestLists.add(req);
        }
        return requestLists;
    }

    private long calcCommodityDemand(StoreRec demandRec, boolean dontMultiply) {
        long count = demandRec.getCount();
        if (!dontMultiply) {
            if (count < (long)this.minLotSize) {
                count *= 10L;
            } else if (count < 10000L) {
                count *= 3L;
            }
            return count -= this.getPrivateAndAvailableStock(demandRec.getCommodity()) / 2L;
        }
        return count;
    }

    public synchronized void goodsAcquired(RequestList rl, Proposal prop) {
        for (Batch batch : rl.getBatch()) {
            Batch b = StockOfferDemand.getBatchCoverageFromProposal(batch, prop);
            if (b == null) continue;
            this.expectedGoods.increase(b);
        }
    }

    public synchronized void goodsAcquired(RequestList rl, Proposal prop1, Proposal prop2) {
        for (Batch batch : rl.getBatch()) {
            Proposal cprop;
            Batch b = StockOfferDemand.getBatchCoverageFromProposal(batch, cprop = StockOfferDemand.integrateTwoProposals(prop1, prop2));
            if (b == null) continue;
            this.expectedGoods.increase(b);
        }
    }

    public synchronized void acquisitionFailed(RequestList rl) {
        for (Batch batch : rl.getBatch()) {
            this.expectedGoods.decrease(batch);
        }
    }

    public synchronized void registerProposedGoods(RequestList rl, Proposal prop) throws NegativeStockException {
        for (Batch batch : rl.getBatch()) {
            Batch b = StockOfferDemand.getBatchCoverageFromProposal(batch, prop);
            if (b == null) continue;
            this.availableStock.decreaseNonNegative(b);
            this.reservedStock.increase(b);
        }
    }

    public synchronized void registerProposedBatch(Batch b) throws NegativeStockException {
        this.availableStock.decreaseNonNegative(b);
        this.reservedStock.increase(b);
    }

    public synchronized void reservedGoodsAccepted(RequestList rl, Proposal prop) throws NegativeStockException {
        for (Batch batch : rl.getBatch()) {
            Batch b = StockOfferDemand.getBatchCoverageFromProposal(batch, prop);
            if (b == null) continue;
            this.reservedStock.decreaseNonNegative(b);
            this.waitingForPickUp.increase(b);
            this.agregateSold.increase(b);
        }
    }

    public synchronized void reservedGoodsAccepted(RequestList rl, Proposal prop1, Proposal prop2) throws NegativeStockException {
        for (Batch batch : rl.getBatch()) {
            Proposal cprop = StockOfferDemand.integrateTwoProposals(prop1, prop2);
            Batch unreserve = StockOfferDemand.getBatchCoverageFromProposal(batch, prop1);
            Batch b = StockOfferDemand.getBatchCoverageFromProposal(batch, cprop);
            if (b == null) continue;
            this.reservedStock.decreaseNonNegative(unreserve);
            this.waitingForPickUp.increase(b);
            this.agregateSold.increase(b);
            this.availableStock.increase(b.getComodityName(), unreserve.getCount() - b.getCount());
        }
    }

    public synchronized void increaseWaitingForPickUp(Batch b) {
        this.waitingForPickUp.increase(b);
    }

    public synchronized void reservedGoodsRefused(RequestList rl, Proposal prop) throws NegativeStockException {
        for (Batch batch : rl.getBatch()) {
            Batch b = StockOfferDemand.getBatchCoverageFromProposal(batch, prop);
            if (b == null) continue;
            this.reservedStock.decreaseNonNegative(b);
            this.availableStock.increase(b);
        }
    }

    public synchronized void goodsReceived(Batch b) {
        if (this.expectedGoods.decrease(b)) {
            this.privateStock.increase(b);
            this.agregateReceived.increase(b);
        } else {
            this.waitingForPickUp.increase(b);
        }
        this.callRegistered(b, this.getIncreasedID());
    }

    public synchronized void goodsUnload(Batch b) {
        this.waitingForPickUp.decrease(b);
    }

    public synchronized double goodsUnload(Batch b, double wantedFill, boolean reallyUnload) {
        double successRate = this.waitingForPickUp.decrease(b, wantedFill, reallyUnload);
        return successRate;
    }

    public synchronized void goodsCreated(String comname, long count) {
        this.availableStock.increase(comname, count);
        this.agregateProduced.increase(comname, count);
    }

    public synchronized boolean goodsConsumed(String comname, long count) {
        if (count <= this.getPrivateAndAvailableStock(comname)) {
            this.goodsRequired(comname, count);
            return true;
        }
        return false;
    }

    public synchronized void command(String commodity, long count) {
        this.goodsDemand.increase(commodity, count);
        this.agregateDemand.increase(commodity, count);
    }

    public void cancelDemand(String comname, long countToCancel) {
        long count = Math.max(Math.min(countToCancel, this.goodsDemand.getCount(comname)), 0L);
        try {
            this.goodsDemand.decreaseNonNegative(comname, count);
        }
        catch (NegativeStockException negativeStockException) {
            // empty catch block
        }
    }

    public synchronized boolean goodsRequiredComplete(String comname, long count) {
        if (count <= this.getPrivateAndAvailableStock(comname)) {
            this.goodsRequired(comname, count);
            return true;
        }
        return false;
    }

    public synchronized long goodsRequired(String comname, long count) {
        long priv = this.privateStock.getCount(comname);
        long av = this.availableStock.getCount(comname);
        long privtake = Math.min(count, priv);
        long avtake = Math.min(count - privtake, av);
        if (0L < privtake) {
            this.privateStock.decrease(comname, privtake);
        }
        if (0L < avtake) {
            this.availableStock.decrease(comname, avtake);
        }
        return avtake + privtake;
    }

    public synchronized long getAvailableStock(String comodityname) {
        StoreRec sr = (StoreRec)this.availableStock.get(comodityname);
        if (sr != null) {
            return sr.getCount();
        }
        return 0L;
    }

    public synchronized long getPrivateAndAvailableStock(String comodityname) {
        long ar = this.availableStock.getCount(comodityname);
        long pr = this.privateStock.getCount(comodityname);
        return ar + pr;
    }

    public synchronized long getDemand(String commodityname) {
        return this.goodsDemand.getCount(commodityname);
    }

    public synchronized Collection getGoodsAvailable() {
        return this.availableStock.values();
    }

    public synchronized Collection getGoodsPrivate() {
        return this.privateStock.values();
    }

    public synchronized Collection getGoodsDemand() {
        return this.goodsDemand.values();
    }

    public synchronized Collection getGoodsReserved() {
        return this.reservedStock.values();
    }

    public synchronized Collection getGoodsWaitingForPickUp() {
        return this.waitingForPickUp.values();
    }

    public synchronized Collection getGoodsExpected() {
        return this.expectedGoods.values();
    }

    public synchronized Collection getAgregateDemand() {
        return this.agregateDemand.values();
    }

    public synchronized Collection getAgregateReceived() {
        return this.agregateReceived.values();
    }

    public synchronized Collection getAgregateProduced() {
        return this.agregateProduced.values();
    }

    public synchronized Collection getAgregateSold() {
        return this.agregateSold.values();
    }

    public synchronized StoreRec getGoodsAvailableComodity(String comodity) {
        return (StoreRec)this.availableStock.get(comodity);
    }

    public synchronized StoreRec getGoodsPrivateComodity(String comodity) {
        return (StoreRec)this.privateStock.get(comodity);
    }

    public synchronized StoreRec getGoodsDemandComodity(String comodity) {
        return (StoreRec)this.goodsDemand.get(comodity);
    }

    public synchronized DetailedStoreRec getGoodsReservedComodity(String comodity) {
        return (DetailedStoreRec)this.reservedStock.get(comodity);
    }

    public synchronized DetailedStoreRec getGoodsWaitingForPickUpComodity(String comodity) {
        return (DetailedStoreRec)this.waitingForPickUp.get(comodity);
    }

    public synchronized DetailedStoreRec getGoodsExpectedComodity(String comodity) {
        return (DetailedStoreRec)this.expectedGoods.get(comodity);
    }

    public synchronized StoreRec getAgregateDemandComodity(String comodity) {
        return (StoreRec)this.agregateDemand.get(comodity);
    }

    public synchronized StoreRec getAgregateReceivedComodity(String comodity) {
        return (StoreRec)this.agregateReceived.get(comodity);
    }

    public synchronized StoreRec getAgregateProducedComodity(String comodity) {
        return (StoreRec)this.agregateProduced.get(comodity);
    }

    public synchronized StoreRec getAgregateSoldComodity(String comodity) {
        return (StoreRec)this.agregateSold.get(comodity);
    }

    public String toString(String caption) {
        StringBuffer sb = new StringBuffer(String.valueOf(caption) + "\n");
        sb.append("Available\n");
        for (StoreRec storeRec : this.availableStock.values()) {
            sb.append(storeRec);
            sb.append("\n");
        }
        sb.append("Reserved\n");
        for (StoreRec storeRec : this.reservedStock.values()) {
            sb.append(storeRec);
            sb.append("\n");
        }
        sb.append("Waiting for pickup\n");
        for (StoreRec storeRec : this.waitingForPickUp.values()) {
            sb.append(storeRec);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Batch getBatchCoverageFromProposal(Batch requestBatch, Proposal prop) {
        for (ItemCoverage ic : prop.getItemCoverage()) {
            if (ic.getItemid() != requestBatch.getBatchid()) continue;
            Batch b = new Batch();
            b.setComodityName(requestBatch.getComodityName());
            b.setBatchid(requestBatch.getBatchid());
            b.setCount((long)Math.floor(ic.getCoverage() * (double)requestBatch.getCount()));
            return b;
        }
        return null;
    }

    public static Proposal integrateTwoProposals(Proposal prop1, Proposal prop2) {
        Proposal res = new Proposal();
        res.setRequestid(prop1.getRequestid());
        res.setTotalPrice(0L);
        block0: for (ItemCoverage ic : prop1.getItemCoverage()) {
            for (ItemCoverage ic2 : prop2.getItemCoverage()) {
                if (ic2.getItemid() != ic.getItemid()) continue;
                ItemCoverage nic = new ItemCoverage();
                nic.setItemid(ic.getItemid());
                nic.setCoverage(ic.getCoverage() * ic2.getCoverage());
                res.getItemCoverage().add(nic);
                continue block0;
            }
        }
        return res;
    }

    public synchronized boolean registerBatch(Batch b, Address listener, LocSubscribeParticipantTask task) {
        if (this.registeredBatches == null) {
            this.registeredBatches = new HashMap();
        }
        if (this.registeredBatches.get(b.getBatchid()) != null && this.registeredBatches.get(b.getBatchid()) instanceof LinkedHashMap) {
            LinkedHashMap<Address, LocSubscribeParticipantTask> batchList = this.registeredBatches.get(b.getBatchid());
            if (batchList.get(listener) != null) {
                return false;
            }
            batchList.put(listener, task);
            return true;
        }
        LinkedHashMap<Address, LocSubscribeParticipantTask> tasks = new LinkedHashMap<Address, LocSubscribeParticipantTask>();
        tasks.put(listener, task);
        this.registeredBatches.put(b.getBatchid(), tasks);
        return true;
    }

    public synchronized void deregisterBatch(Batch b, Address listener, SubscribeParticipantTask task) {
        if (this.registeredBatches != null) {
            if (this.registeredBatches.get(b.getBatchid()) != null && this.registeredBatches.get(b.getBatchid()) instanceof LinkedHashMap) {
                LinkedHashMap<Address, LocSubscribeParticipantTask> ll = this.registeredBatches.get(b.getBatchid());
                ll.remove(listener);
                this.registeredBatches.put(b.getBatchid(), ll);
            }
        } else {
            System.out.println("no registration to cancel error");
        }
    }

    private void callRegistered(Batch b, Long id) {
        LinkedHashMap<Address, LocSubscribeParticipantTask> ll;
        if (this.registeredBatches != null && (ll = this.registeredBatches.get(b.getBatchid())) != null) {
            for (LocSubscribeParticipantTask task : ll.values()) {
                if (task == null) continue;
                task.goodsDelivered(b, id);
            }
        }
    }

    private long getIncreasedID() {
        return this._id++;
    }

    static abstract class OneStore
    extends HashMap<String, StoreRec> {
        OneStore() {
        }

        abstract StoreRec getNewStoreRec(String var1, long var2);

        public abstract StoreRec getNewStoreRec(Batch var1);

        public synchronized long getCount(String comname) {
            StoreRec sr = (StoreRec)this.get(comname);
            if (sr != null) {
                return sr.getCount();
            }
            return 0L;
        }

        public synchronized StoreRec getRecord(String comname) {
            return (StoreRec)this.get(comname);
        }

        synchronized void increase(Batch b) {
            StoreRec sr = (StoreRec)this.get(b.getComodityName());
            if (sr != null) {
                sr.increase(b);
            } else {
                StoreRec nsr = this.getNewStoreRec(b);
                this.put(b.getComodityName(), nsr);
            }
        }

        synchronized void decreaseNonNegative(Batch b) throws NegativeStockException {
            StoreRec sr = (StoreRec)this.get(b.getComodityName());
            if (sr == null) {
                throw new NegativeStockException("Goods not found on stock. Commodity: " + b.getComodityName());
            }
            sr.decreaseNonNegative(b);
        }

        synchronized void decreaseNonNegative(Batch b, String error) throws NegativeStockException {
            StoreRec sr = (StoreRec)this.get(b.getComodityName());
            if (sr == null) {
                throw new NegativeStockException("Goods not found on stock.");
            }
            sr.decreaseNonNegative(b, error);
        }

        synchronized boolean decrease(Batch b) {
            StoreRec sr = (StoreRec)this.get(b.getComodityName());
            if (sr != null) {
                return sr.decrease(b);
            }
            return false;
        }

        synchronized double decrease(Batch b, double requestedFill, boolean reallyUnload) {
            StoreRec sr = (StoreRec)this.get(b.getComodityName());
            if (sr != null) {
                return sr.decrease(b, requestedFill, reallyUnload);
            }
            return 0.0;
        }
    }

    static class SimpleStore
    extends OneStore {
        SimpleStore() {
        }

        @Override
        public StoreRec getNewStoreRec(String comname, long count) {
            return new StoreRec(comname, count);
        }

        @Override
        public StoreRec getNewStoreRec(Batch b) {
            return new StoreRec(b.getComodityName(), b.getCount());
        }

        synchronized void increase(String comname, long count) {
            StoreRec sr = (StoreRec)this.get(comname);
            if (sr != null) {
                sr.increase(count);
            } else {
                StoreRec nsr = this.getNewStoreRec(comname, count);
                this.put(comname, nsr);
            }
        }

        synchronized void decreaseNonNegative(String comname, long count) throws NegativeStockException {
            StoreRec sr = (StoreRec)this.get(comname);
            if (sr == null) {
                throw new NegativeStockException("Goods not found on stock.");
            }
            sr.decreaseNonNegative(count);
        }

        synchronized void decrease(String comname, long count) {
            StoreRec sr = this.getRecord(comname);
            if (sr != null) {
                sr.decrease(count);
            }
        }
    }

    static class DetailedStore
    extends OneStore {
        DetailedStore() {
        }

        @Override
        public StoreRec getNewStoreRec(String comname, long count) {
            throw new UnsupportedOperationException("Use different operation for this type of Store.");
        }

        @Override
        public StoreRec getNewStoreRec(Batch b) {
            return new DetailedStoreRec(b);
        }
    }
}

