/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location.accounts;

import across.agents.location.accounts.NegativeStockException;
import across.agents.location.accounts.StoreRec;
import across.data.Batch;
import java.util.HashMap;

public class DetailedStoreRec
extends StoreRec {
    HashMap<Long, Batch> batches = new HashMap();

    public DetailedStoreRec(Batch b) {
        super(b.getComodityName(), 0L);
        this.increase(b);
    }

    @Override
    public void increase(long bcount) {
        throw new UnsupportedOperationException("Use batch operation only");
    }

    @Override
    public void increase(Batch b) {
        Batch inserted = this.batches.get(new Long(b.getBatchid()));
        if (inserted == null) {
            this.batches.put(new Long(b.getBatchid()), b);
        } else {
            inserted.setCount(inserted.getCount() + b.getCount());
        }
        super.increase(b);
    }

    @Override
    public boolean decrease(Batch b) {
        Batch victim = this.batches.get(new Long(b.getBatchid()));
        if (victim != null) {
            if (victim.getCount() < b.getCount()) {
                super.decrease(victim);
            } else {
                super.decrease(b);
            }
            victim.setCount(Math.max(victim.getCount() - b.getCount(), 0L));
            if (victim.getCount() == 0L) {
                this.batches.remove(new Long(b.getBatchid()));
            }
            return true;
        }
        return false;
    }

    @Override
    public double decrease(Batch b, double requestedFill, boolean reallyUnload) {
        double successRatio;
        if (b.getCount() == 0L) {
            return 1.0;
        }
        Batch victim = this.batches.get(new Long(b.getBatchid()));
        if (victim != null) {
            successRatio = (double)victim.getCount() / (double)b.getCount();
            if (successRatio >= requestedFill && reallyUnload) {
                this.decrease(b);
            }
        } else {
            successRatio = 0.0;
        }
        return successRatio;
    }

    @Override
    public void decreaseNonNegative(Batch b) throws NegativeStockException {
        this.decrease(b);
    }

    @Override
    public void decreaseNonNegative(long count) throws NegativeStockException {
        throw new UnsupportedOperationException("Use batch operation only");
    }

    @Override
    public void decrease(long decr) {
        super.decrease(decr);
    }

    public Batch get(Long batchid) {
        return this.batches.get(batchid);
    }
}

