/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location;

import across.agents.location.LocationAgent;
import across.agents.location.LocationAgentSimulationData;
import across.data.simulation.SimulationObjectDescription;
import aglobex.simulation.ontology.Sensor;
import aglobex.simulation.ontology.SensoryData;
import aglobex.simulation.ontology.SensoryDataRecord;
import java.util.HashMap;
import java.util.Map;

public class SimulationObjectsEffects {
    protected double aggregateFire = 0.0;
    protected int actualFire;
    protected double aggregateInsurgency = 0.0;
    protected int actualInsurgency;
    protected double aggregateConstructionDamage = 0.0;
    protected int actualConstructionDamage;
    protected int numberOfWounded = 0;
    protected long startTime;
    private long lastTimeStamp;
    private LocationAgent owner;
    private LocationAgentSimulationData ownerData;
    private Map<String, SimulationObjectDescription> activeObjects = new HashMap<String, SimulationObjectDescription>();

    public SimulationObjectsEffects(LocationAgent owner, LocationAgentSimulationData ownerData) {
        this.owner = owner;
        this.ownerData = ownerData;
    }

    public void parseSensoryData(SensoryData sd) {
        this.calculateAggregate(sd.simulationTimestamp - this.lastTimeStamp);
        this.lastTimeStamp = sd.simulationTimestamp;
        for (Sensor sensor : sd.sensor) {
            for (SensoryDataRecord sdr : sensor.sensoryDataRecord) {
                if (!sdr.targetEntityType.equals("SIMULATION_OBJECT_TYPE") || this.activeObjects.containsKey(sdr.targetContainerName) || !this.isInVincinity(sdr)) continue;
                this.activeObjects.put(sdr.targetContainerName, null);
            }
        }
        this.askObjectsDescription();
    }

    public void objectDescription(SimulationObjectDescription sod) {
        this.activeObjects.put(sod.getName(), sod);
    }

    public void startAggregation(long startTime) {
        this.startTime = startTime;
        this.aggregateConstructionDamage = 0.0;
        this.aggregateFire = 0.0;
        this.aggregateInsurgency = 0.0;
    }

    private void calculateAggregate(long effectPeriod) {
        this.numberOfWounded = 0;
        for (SimulationObjectDescription sod : this.activeObjects.values()) {
            if (sod == null) continue;
            this.aggregateConstructionDamage += (double)(effectPeriod * (long)sod.getConstructionDamage());
            this.aggregateFire += (double)(effectPeriod * (long)sod.getExtentOfFire());
            this.aggregateInsurgency += (double)(effectPeriod * (long)sod.getInsurgencyLevel());
            this.numberOfWounded += sod.getNumberOfWounded();
        }
    }

    private void askObjectsDescription() {
        for (String objName : this.activeObjects.keySet()) {
            this.owner.gisShell.submitTopicToServer("TOPIC_SIMULATION_OBJECT", objName, "SIMULATION_OBJECT_DESCRIPTION");
        }
    }

    private boolean isInVincinity(SensoryDataRecord sdr) {
        double diffX = sdr.ownerX - sdr.targetX;
        double diffY = sdr.ownerY - sdr.targetY;
        double diffZ = sdr.ownerZ - sdr.targetZ;
        double distance = diffX * diffX + diffY * diffY;
        return (distance = distance * distance + diffZ * diffZ) <= this.ownerData.locVicinity;
    }

    public double getAggregateConstructionDamage() {
        return this.aggregateConstructionDamage;
    }

    public double getAggregateFire() {
        return this.aggregateFire;
    }

    public double getAggregateInsurgency() {
        return this.aggregateInsurgency;
    }
}

