/*
 * Decompiled with CFR 0.152.
 */
package across.agents.location;

import across.agents.location.LocationAgentSimulationData;
import across.agents.location.SimulationObjectsEffects;
import across.agents.location.accounts.StockOfferDemand;
import across.agents.location.generator.Generator;
import across.agents.location.generator.PopulationGenerator;
import across.agents.location.gui.LocationAgentGUI;
import across.agents.location.task.LocAcquireGoodsTask;
import across.agents.location.task.LocIdleTask;
import across.agents.location.util.LocationUtils;
import across.data.Batch;
import across.data.Page;
import across.data.Param;
import across.data.PublicParams;
import across.data.RequestList;
import across.data.Weather;
import across.data.simulation.SimulationObjectDescription;
import across.util.skn.AgentKnowledge;
import across.util.skn.CommunityKnowledge;
import across.util.skn.ServiceKnowledge;
import across.util.skn.listeners.NewAgentRegisteredListener;
import across.util.skn.update.UpdateListener;
import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.AglobeParam;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.util.AglobeXMLtools;
import aglobe.visio3D.ontology.Chart;
import aglobe.visio3D.ontology.SimpleBar;
import aglobex.protocol.subscribe.SubscribeInitiatorTask;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.SensorDescription;
import aglobex.simulation.ontology.SensoryData;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.protocol.cnp.CNPTaskOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class LocationAgent
extends CMAgent
implements CNPTaskOwner,
GISTopicListener,
NewAgentRegisteredListener,
DirectoryListener,
ClientServerTopicConstants {
    public static final String TYPE = "Location";
    public StockOfferDemand books = new StockOfferDemand();
    protected List<Generator> generators = new LinkedList<Generator>();
    protected LocationAgentSimulationData mySimData = new LocationAgentSimulationData();
    protected SimulationObjectsEffects objEffects = new SimulationObjectsEffects(this, this.mySimData);
    public GISClientService.Shell gisShell;
    protected DirectoryService.Shell dsShell;
    protected GISTopicListener weatherListener;
    public int minLotSize;
    public Page page;
    public CommunityKnowledge community = new CommunityKnowledge(this);
    public LocationAgentGUI gui;
    public List<Param> commodityParam;
    public LocIdleTask idleTask = null;
    protected EntityDescriptor entityDescriptor;

    @Override
    public void init(AgentInfo ai, int initState) {
        super.init(ai, initState);
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
        this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
        this.gisShell.subscribeTopic("SENSORY_DATA", this);
        this.gisShell.subscribeTopic("TOPIC_SIMULATION_OBJECT", this);
        this.gui = new LocationAgentGUI(this);
        this.idleTask = new LocIdleTask(this);
        this.setIdleTask(this.idleTask);
        this.gui.setTitle(ai.getReadableName());
        this.gui.setBounds(0, 0, 500, 142);
        this.gui.setAll(this.books);
    }

    private void handleConfiguration(EntityDescriptor ed) {
        this.minLotSize = ed.typeDescriptor.userParamsInteger.get("LOCATION_MIN_LOT_SIZE");
        this.mySimData.secondsPerDay = ed.typeDescriptor.userParamsInteger.get("SECONDS_PER_DAY");
        this.mySimData.locVicinity = ed.typeDescriptor.userParamsDouble.get("LOCATION_VICINITY_RANGE");
        this.directoryRegisterAndSubscribe(ed);
        this.weatherInformationSubscribe();
        this.books.setMinLotSize(this.minLotSize);
        this.commodityParam = LocationUtils.getGeneratorParams(ed);
        Generator.initGenerators(this.commodityParam, this.generators);
        SensorDescription sd = new SensorDescription();
        double range = ed.typeDescriptor.userParamsDouble.get("LOCATION_SENSOR_RANGE");
        AglobeParam rangeParam = new AglobeParam();
        rangeParam.setValue(Double.toString(range));
        sd.setSensorType("spherical");
        sd.getAglobeParam().add(rangeParam);
        this.gisShell.submitTopicToServer("REGISTER_SENSOR", sd);
    }

    protected void directoryRegisterAndSubscribe(EntityDescriptor ed) {
        this.page = new Page();
        this.page.setAddress(this.getAddress());
        this.page.setName(this.getName());
        this.page.setPublicParams(new PublicParams());
        for (String key : ed.confParamsString.keySet()) {
            Param par = new Param();
            par.setName(key);
            String value = ed.confParamsString.get(key);
            par.setValue(value);
            this.page.getPublicParams().getParam().add(par);
            if ("region".equalsIgnoreCase(par.getName())) {
                this.mySimData.region = value;
                continue;
            }
            if (!"tribe".equalsIgnoreCase(par.getName())) continue;
            this.mySimData.tribe = value;
        }
        this.page.getPublicParams().setType(TYPE);
        this.community.subscribeNewAgentRegisteredListener(this);
        this.dsShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.dsShell != null) {
            ArrayList<String> locations = new ArrayList<String>();
            locations.add(TYPE);
            try {
                UpdateListener ulist = new UpdateListener(this.community, this);
                this.dsShell.register((ElementaryEntity)this, locations);
                this.dsShell.subscribe(ulist, TYPE);
                this.dsShell.subscribe(ulist, "Transporter");
            }
            catch (DirectoryException e) {
                this.logger.severe("Directory Service exception during registration.: " + e + e.getMessage() + e.getStackTrace());
            }
        } else {
            this.logger.severe("Directory Service not found on container: " + this.getContainer().getContainerName());
        }
    }

    private void weatherInformationSubscribe() {
        if (this.gisShell != null) {
            this.gisShell.subscribeTopic("TOPIC_WEATHER_UPDATE", this);
            this.gisShell.subscribeTopic("TOPIC_DISASTER_VISIBILITY", this);
            this.gisShell.submitTopicToServer("TOPIC_WEATHER_UPDATE_REQUEST", null);
            this.gisShell.submitTopic("VISIO_INFO", "<c00FF00>" + this.getContainer().getContainerName(), null);
            this.gisShell.submitTopic("PAGE_UPDATE", this.page, null);
        } else {
            this.logSevere("GISClient not found.");
        }
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION")) {
            if (content instanceof EntityDescriptor) {
                this.handleConfiguration((EntityDescriptor)content);
            }
        } else if (topic.equalsIgnoreCase("SIMULATION_TIME_UPDATE_1_SECOND")) {
            this.idleTask.handleTimeout();
            ++this.mySimData.simTime;
            if (this.mySimData.simTime % (long)this.mySimData.secondsPerDay == 0L) {
                long totPopSize = 0L;
                long totMood = 0L;
                for (Generator gen : this.generators) {
                    gen.generationStep(this.mySimData.weather, this.books, this.objEffects);
                    if (!(gen instanceof PopulationGenerator)) continue;
                    PopulationGenerator pg = (PopulationGenerator)gen;
                    totPopSize += pg.getPopSize();
                    totMood = pg.getCurrentMood();
                }
                this.objEffects.startAggregation(Long.parseLong((String)content));
                this.gisShell.submitTopicToServer("VISIO_INFO", "<c00FF00>" + this.getName() + "<cFF0000> " + totPopSize + "<cFF00FF> " + totMood, null);
                this.gisShell.submitTopicToServer("PAGE_UPDATE", this.page);
                this.gisShell.submitTopicToServer("VISIO_ACTION", "41", this.getAddress().toString());
                this.gui.setAll(this.books);
                this.updateBarsInVisio(this.mySimData.weather);
            }
            if (this.isDemand()) {
                this.startCNP();
            }
        } else if (!topic.equalsIgnoreCase("TOPIC_DISASTER_VISIBILITY")) {
            if (topic.equalsIgnoreCase("TOPIC_WEATHER_UPDATE")) {
                this.mySimData.weather = (Weather)content;
            } else if (topic.equalsIgnoreCase("SENSORY_DATA")) {
                this.objEffects.parseSensoryData((SensoryData)content);
            } else if (topic.equalsIgnoreCase("TOPIC_SIMULATION_OBJECT") && reason.equalsIgnoreCase("SIMULATION_OBJECT_DESCRIPTION")) {
                this.objEffects.objectDescription((SimulationObjectDescription)content);
            } else {
                this.logSevere("Unexpected topic!" + topic);
            }
        }
    }

    protected boolean isDemand() {
        Random rand = new Random();
        return this.mySimData.simTime % (long)(this.mySimData.secondsPerDay + rand.nextInt(5)) == 0L;
    }

    protected void startCNP() {
        List<RequestList> requestLists = this.books.prepareSingleListGoodsDemand(this, true);
        for (RequestList rl : requestLists) {
            if (rl.getBatch().size() <= 0) continue;
            Collection<Address> accessibleProviders = null;
            accessibleProviders = ((ServiceKnowledge)this.community.getServices().get(TYPE)).getAccessibleProviders(this.getAddress());
            if (accessibleProviders == null) {
                accessibleProviders = new LinkedList<Address>();
            }
            StringBuffer aps = new StringBuffer();
            for (Address address : accessibleProviders) {
                aps.append(address.getName());
                aps.append(";");
            }
            if (accessibleProviders.size() <= 0) continue;
            new LocAcquireGoodsTask(this, accessibleProviders, rl, 20000, aps.toString());
            this.gisShell.submitTopic("VISIO_ACTION", "11", this.getAddress().toString());
        }
    }

    public void startManualRequest(RequestList requestList) {
        for (Batch batch : requestList.getBatch()) {
            this.books.command(batch.getComodityName(), batch.getCount());
        }
        this.startCNP();
        this.gui.setAll(this.books);
        for (Batch batch : requestList.getBatch()) {
            this.books.cancelDemand(batch.getComodityName(), batch.getCount());
        }
    }

    @Override
    public void handleNewAgentRegistered(AgentKnowledge agent) {
        for (ServiceKnowledge serviceKnowledge : agent.servicesProvided) {
            if (!"Transporter".equalsIgnoreCase(serviceKnowledge.serviceName) || this.getAddress().equals(agent.address)) continue;
            SubscribeInitiatorTask task = new SubscribeInitiatorTask(this, agent.address, (Object)"PUBLIC_INFO_REQUEST", false){

                @Override
                protected void subscribeInformResult(Object object) {
                    Page page2 = (Page)object;
                    LocationAgent.this.community.agentPageUpdated(page2.getAddress(), page2.getPublicParams());
                }

                @Override
                protected void subscribeAgreed() {
                }

                @Override
                protected void subscribeRefused() {
                    LocationAgent.this.logger.severe(String.valueOf(LocationAgent.this.getName()) + ": Transporter " + this.subscribeContent + " has refused my subscribe.");
                }
            };
            task.start();
        }
    }

    @Override
    public final void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public final void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public final void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public final void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    public void updateBarsInVisio(Weather wea) {
        if (wea == null) {
            return;
        }
        Chart chart = new Chart();
        for (Param param : this.commodityParam) {
            SimpleBar bar = AglobeXMLtools.makeSimpleBar("null", (byte)1, (byte)0);
            Iterator<Param> iterator = wea.getParam().iterator();
            while (iterator.hasNext()) {
                Param wob;
                Param wp = wob = iterator.next();
                if (!param.getName().startsWith(wp.getName(), 4)) continue;
                byte value = Byte.parseByte(String.valueOf(Math.round(Double.parseDouble(wp.getValue()) * 127.0)));
                bar = Double.parseDouble(wp.getValue()) < 0.33 ? AglobeXMLtools.makeSimpleBar(wp.getName(), (byte)1, (byte)(value * 2)) : (Double.parseDouble(wp.getValue()) < 0.66 ? AglobeXMLtools.makeSimpleBar(wp.getName(), (byte)5, (byte)(value * 2)) : AglobeXMLtools.makeSimpleBar(wp.getName(), (byte)2, (byte)(value * 2)));
            }
            if (bar.getName().compareToIgnoreCase("null") == 0) continue;
            chart.getContent().add(bar);
        }
        if (chart.getContent().size() != 0) {
            this.gisShell.submitTopic("SET_CHART", chart, this.getContainer().getContainerName());
        }
    }

    public long getCurrentTime() {
        return this.mySimData.simTime;
    }
}

