/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.storage;

import across.data.Batch;
import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.protocol.request.RequestParticipantTask;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

public class EmergencyStorageAgent
extends CMAgent
implements ClientServerTopicConstants,
GISTopicListener {
    public static final String TYPE = "EmergencyStorageAgent";
    protected GISClientService.Shell gisShell;
    protected DirectoryService.Shell dirShell;
    protected String location;

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.gisShell != null && this.dirShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
            this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
            this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
            this.gisShell.subscribeTopic("SENSORY_DATA", this);
            this.gisShell.subscribeTopic("TOPIC_SIMULATION_OBJECT", this);
        } else {
            this.logSevere("Unable to locate GIS!");
            this.stop();
        }
        try {
            this.dirShell.register((ElementaryEntity)this, new LinkedList<String>((Collection)Arrays.asList(TYPE)));
        }
        catch (DirectoryException e) {
            e.printStackTrace();
        }
        this.setIdleTask(new EmergencyStorageAgentIdleTask(this));
    }

    protected void handleStorageRequest(Message m) {
        new RequestParticipantTask(this, m){

            @Override
            protected void processRequest(Message requestMessage) {
                Batch b = (Batch)requestMessage.getContent();
                this.informDone();
            }
        };
    }

    protected void handleStorageCNP(Message m) {
        new CNPParticipantTask(this, 10000, m){

            @Override
            protected void prepareProposal() {
                this.sendProposal(EmergencyStorageAgent.this.location);
            }

            @Override
            protected void proposalAccepted(Message acceptMessage) {
            }

            @Override
            protected void proposalRefused(Message refuseMessage) {
            }

            @Override
            protected void timeout() {
            }
        };
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION") && content instanceof EntityDescriptor) {
            this.handleConfiguration((EntityDescriptor)content);
        }
    }

    private void handleConfiguration(EntityDescriptor ed) {
        this.location = ed.confParamsString.get("ENTITY_START_NODE");
        String visioInfo = "<b>" + this.getName();
        this.gisShell.submitTopicToServer("VISIO_INFO", visioInfo);
    }

    protected class EmergencyStorageAgentIdleTask
    extends Task
    implements MessageConstants {
        public EmergencyStorageAgentIdleTask(ConversationUnit cu) {
            super(cu);
        }

        @Override
        protected void handleIncomingMessage(Message m) {
            if (m.getPerformative().equals("REQUEST")) {
                EmergencyStorageAgent.this.handleStorageRequest(m);
            } else if (m.getProtocol().equals("CONTRACT-NET")) {
                EmergencyStorageAgent.this.handleStorageCNP(m);
            }
        }
    }
}

