/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.repair;

import across.agents.driver.data.RoadInfo;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.agents.emergency.repair.RepairVehicleAgent;
import across.data.AcrossMapArcs;
import across.data.AcrossMapDistances;
import across.data.AcrossMapNodes;
import across.data.Arc;
import across.data.Node;
import across.data.Waypoint;
import across.util.pathfinding.AStarModPathfinding;
import across.util.pathfinding.Pathfinding;
import across.util.pathfinding.RoadEvaluator;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class RepairVehicleMovement
implements ClientServerTopicConstants {
    protected RepairVehicleAgent owner;
    protected Pathfinding pathfinding;
    protected LinkedList<String> locNames = new LinkedList();
    protected RoadInfo[][] roads;
    protected String actualLoc;
    protected String headingTo;
    protected LinkedList<Waypoint> waypoints = new LinkedList();
    protected double[] position;

    public RepairVehicleMovement(RepairVehicleAgent owner) {
        this.owner = owner;
    }

    public void handleMovementTopic(Object content, String reason) {
        if (reason.equalsIgnoreCase("CONTROL_RESPONSE_BAD_NODE")) {
            this.owner.logSevere("Bad node chosen!");
        } else if (reason.equalsIgnoreCase("CONTROL_RESPONSE_FAILURE")) {
            this.owner.logSevere("Movement failure!");
        } else if (reason.equalsIgnoreCase("CONTROL_RESPONSE_STOPPED") && content instanceof String) {
            this.actualLoc = (String)content;
            if (this.waypoints.size() == 0) {
                return;
            }
            Waypoint wp = this.waypoints.getFirst();
            if (wp.getLocationName().equals(this.actualLoc)) {
                this.waypoints.removeFirst();
            }
            this.move();
        } else if (reason.equalsIgnoreCase("CONTROL_RESPONSE_STOPPED") && content instanceof double[]) {
            this.position = (double[])content;
        }
    }

    public void handleConfiguration(EntityDescriptor ed, final double velocity, final double consumption) {
        this.actualLoc = ed.confParamsString.get("ENTITY_START_NODE");
        AcrossMapNodes amn = (AcrossMapNodes)ed.typeDescriptor.userObjects.get("MAP_NODES");
        AcrossMapArcs ama = (AcrossMapArcs)ed.typeDescriptor.userObjects.get("MAP_ARCS");
        AcrossMapDistances amd = (AcrossMapDistances)ed.typeDescriptor.userObjects.get("MAP_DISTANCES");
        this.locNames.clear();
        for (Node node : amn.getNode()) {
            this.locNames.add(node.getName());
        }
        RoadEvaluator re = new RoadEvaluator(){

            @Override
            public double getPrice(Arc arc) {
                return 1.0 / arc.getQuality() * arc.getLength() * consumption / 100.0;
            }

            @Override
            public double getTime(Arc arc) {
                return 10.0 * arc.getLength() / velocity;
            }
        };
        this.pathfinding = new AStarModPathfinding(amn.getNode(), ama.getArc(), amd.getDistance(), re, new LinkedList<Arc>());
    }

    public boolean isOnRoute() {
        return this.waypoints.size() != 0;
    }

    public double[] getPosition() {
        return this.position;
    }

    public boolean goToRandomLocation() {
        Random rand = new Random(System.currentTimeMillis());
        int locNum = this.locNames.size();
        String randLoc = this.locNames.get(rand.nextInt(locNum));
        Waypoint wp = new Waypoint(randLoc);
        Route route = this.planRoute(new LinkedList<Waypoint>((Collection)Arrays.asList(wp)), true);
        return this.moveAlongRoute(route);
    }

    public boolean goToLocation(String location) {
        Waypoint locWay = new Waypoint(location);
        Route route = this.planRoute(new LinkedList<Waypoint>((Collection)Arrays.asList(locWay)), true);
        return this.moveAlongRoute(route);
    }

    public boolean driveThroughRoad(String startLoc, String endLoc) {
        Waypoint startWaypoint = new Waypoint(startLoc);
        Waypoint endWaypoint = new Waypoint(endLoc);
        Route route = this.planRoute(new LinkedList<Waypoint>((Collection)Arrays.asList(startWaypoint)), true);
        route.getWaypoints().add(endWaypoint);
        return this.moveAlongRoute(route);
    }

    public void stopMovement() {
        this.controlStop();
    }

    public void cancelMovement() {
        this.stopMovement();
        this.waypoints.clear();
    }

    public Route getRoute(List<Waypoint> wpList, boolean byPrice) {
        Route route = this.planRoute(wpList, byPrice);
        if (route != null && route.getWaypoints().size() != 0) {
            return route;
        }
        return null;
    }

    protected boolean moveAlongRoute(Route route) {
        if (route != null) {
            this.waypoints.addAll(route.getWaypoints());
            Waypoint actWay = new Waypoint(this.actualLoc);
            this.waypoints.addFirst(actWay);
            this.move();
            return true;
        }
        return false;
    }

    protected Route planRoute(List<Waypoint> wpList, boolean byPrice) {
        Route route = new Route();
        String startPoint = this.waypoints.size() == 0 ? new String(this.actualLoc) : new String(this.waypoints.getLast().getLocationName());
        double taskTime = 0.0;
        double taskPrice = 0.0;
        for (Waypoint wp : wpList) {
            Route oneRoute = byPrice ? this.pathfinding.planRoute(startPoint, wp.getLocationName(), 0.0, 1.0) : this.pathfinding.planRoute(startPoint, wp.getLocationName(), 1.0, 0.0);
            if (oneRoute == null) continue;
            taskTime += oneRoute.getRouteInfo().routeTime;
            taskPrice += oneRoute.getRouteInfo().routePrice;
            startPoint = wp.getLocationName();
            route.addWaypoints(oneRoute.getWaypoints());
            route.addWaypoint(wp);
        }
        route.setRouteInfo(new RouteInfo(taskTime, taskPrice));
        return route;
    }

    protected void move() {
        String waypointName;
        if (!this.isOnRoute()) {
            this.headingTo = null;
            return;
        }
        Waypoint wp = this.waypoints.getFirst();
        this.headingTo = waypointName = wp.getLocationName();
        this.controlMoveTo(waypointName);
    }

    protected void controlMoveTo(String waypointName) {
        this.owner.gisShell.submitTopic("ENTITY_CONTROL", waypointName, "CONTROL_MOVE_TO");
    }

    protected void controlStop() {
        this.owner.gisShell.submitTopicToServer("ENTITY_CONTROL", null, "CONTROL_STOP");
    }
}

