/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.repair;

import across.agents.driver.data.Route;
import across.agents.emergency.centre.AcrossActivity;
import across.agents.emergency.repair.RepairRequestParticipantTask;
import across.agents.emergency.repair.RepairVehicleActivityHandler;
import across.agents.emergency.repair.RepairVehicleMovement;
import across.agents.emergency.repair.RepairVehicleSensors;
import across.data.Waypoint;
import across.data.simulation.EffectOnSimulationObject;
import across.data.simulation.SimulationObjectDescription;
import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.protocol.request.RequestParticipantTask;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import aglobex.simulation.protocol.cnp.CNPParticipantTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class RepairVehicleAgent
extends CMAgent
implements GISTopicListener,
ClientServerTopicConstants,
DirectoryListener {
    public static final String TYPE = "Repair";
    protected int simulationTimePeriod = 50;
    protected double consumption;
    protected double velocity;
    protected EffectOnSimulationObject myEffect;
    protected int effectSpeed;
    protected GISClientService.Shell gisShell;
    protected DirectoryService.Shell dirShell;
    protected RepairVehicleMovement myMovement = new RepairVehicleMovement(this);
    protected RepairVehicleActivityHandler myActivityHandler = new RepairVehicleActivityHandler(this);
    protected RepairVehicleSensors mySensors = new RepairVehicleSensors(this);
    protected boolean onMission = false;
    protected List<Address> emergencyAgents = new ArrayList<Address>();

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.gisShell != null && this.dirShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
            this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
            this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
            this.gisShell.subscribeTopic("SENSORY_DATA", this);
        } else {
            this.logSevere("Unable to locate GIS or Directory Service!");
            this.stop();
        }
        try {
            this.dirShell.register((ElementaryEntity)this, new LinkedList<String>((Collection)Arrays.asList(TYPE)));
        }
        catch (DirectoryException e) {
            e.printStackTrace();
        }
        this.dirShell.subscribe(this, "EmergencyCentre");
        this.setIdleTask(new RepairVehicleIdleTask(this));
    }

    private void cnpForAccidentHandlingObtained(final Message mes) {
        new CNPParticipantTask(this, 1000, mes){

            @Override
            protected void prepareProposal() {
                if (!RepairVehicleAgent.this.onMission) {
                    String location = (String)mes.getContent();
                    Waypoint locWay = new Waypoint(location);
                    ArrayList<Waypoint> wayList = new ArrayList<Waypoint>();
                    wayList.add(locWay);
                    Route r = RepairVehicleAgent.this.myMovement.planRoute(wayList, true);
                    Double routePrice = r.getRouteInfo().routePrice;
                    this.sendProposal(routePrice);
                } else {
                    this.sendProposal(null);
                }
            }

            @Override
            protected void proposalAccepted(Message acceptMessage) {
                RepairVehicleAgent.this.displayVisioAction((byte)82);
                RepairVehicleAgent.this.onMission = true;
                RepairVehicleAgent.this.myMovement.cancelMovement();
                this.cancelTask();
            }

            @Override
            protected void proposalRefused(Message refuseMessage) {
                this.cancelTask();
            }

            @Override
            protected void timeout() {
            }
        };
    }

    private void freeDriverRequestObtained(Message mes) {
        this.displayVisioAction((byte)72);
        new RequestParticipantTask(this, mes){

            @Override
            protected void processRequest(Message requestMessage) {
                String what = (String)requestMessage.getContent();
                if (what.equalsIgnoreCase("CANCEL_DRIVER_SCHEDULE")) {
                    RepairVehicleAgent.this.onMission = false;
                    RepairVehicleAgent.this.myMovement.cancelMovement();
                    RepairVehicleAgent.this.displayNameInVisio();
                }
            }
        };
    }

    private void newActivityRequestObtained(Message mes) {
        this.displayVisioAction((byte)73);
        new RepairRequestParticipantTask(this, mes){

            @Override
            protected void processRequest(Message requestMessage) {
                AcrossActivity act = (AcrossActivity)requestMessage.getContent();
                RepairVehicleAgent.this.myActivityHandler.handleActivity(act, this);
                RepairVehicleAgent.this.displayActivityInVisio(act);
            }
        };
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        block6: {
            block8: {
                block9: {
                    block7: {
                        block5: {
                            if (!topic.equalsIgnoreCase("ENTITY_CONNECTION")) break block5;
                            if (!(content instanceof EntityDescriptor)) break block6;
                            this.handleConfiguration((EntityDescriptor)content);
                            break block6;
                        }
                        if (!topic.equalsIgnoreCase("ENTITY_CONTROL")) break block7;
                        this.myMovement.handleMovementTopic(content, reason);
                        break block6;
                    }
                    if (!topic.equalsIgnoreCase("SIMULATION_TIME_UPDATE_1_SECOND")) break block8;
                    if (this.onMission || this.myMovement.isOnRoute()) break block9;
                    if (!this.amICop()) break block6;
                    this.myMovement.goToRandomLocation();
                    break block6;
                }
                this.myActivityHandler.run();
                break block6;
            }
            if (topic.equalsIgnoreCase("SENSORY_DATA")) {
                this.myActivityHandler.run();
                this.mySensors.processSensorTopic(content);
                List<String> accidentsInSight = this.mySensors.getObjectsInSight();
                if (accidentsInSight.size() > 0) {
                    this.reportAccidents(accidentsInSight);
                }
                if (!this.onMission && this.amICop() && this.mySensors.isEntityTypeInSight("TERRORIST_DRIVER_ENTITY_TYPE")) {
                    ArrayList<String> terroristsInSight = new ArrayList<String>(this.mySensors.getEntitiesOfTypeInSight("TERRORIST_DRIVER_ENTITY_TYPE"));
                    Random r = new Random(System.currentTimeMillis());
                    if (r.nextInt(100) < 100) {
                        for (String string : terroristsInSight) {
                            if (string.equals("Terrorist")) continue;
                            this.destroyEntity(string);
                            break;
                        }
                    }
                }
            }
        }
    }

    private boolean amICop() {
        return this.getName().indexOf("police-team") != -1;
    }

    protected void reportAccidents(List<String> listOfAccidents) {
        for (Address adr : this.emergencyAgents) {
            for (String objId : listOfAccidents) {
                SimulationObjectDescription sod = this.mySensors.getObjectsDescription(objId);
                if (sod == null) continue;
                Message mes = Message.newInstance();
                mes.setPerformative("INFORM");
                mes.setContent(sod);
                mes.setReceiver(adr);
                mes.setSender(this.getAddress());
                try {
                    this.sendMessage(mes);
                }
                catch (InvisibleContainerException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void handleConfiguration(EntityDescriptor ed) {
        this.consumption = Double.parseDouble(ed.confParamsString.get("VEHICLE_CONSUMPTION"));
        this.velocity = Double.parseDouble(ed.confParamsString.get("VEHICLE_VELOCITY"));
        this.effectSpeed = Integer.parseInt(ed.confParamsString.get("VEHICLE_EFFECT_SPEED"));
        this.myEffect = (EffectOnSimulationObject)ed.confObjects.get("VEHICLE_EFFECT");
        this.myMovement.handleConfiguration(ed, this.velocity, this.consumption);
        this.mySensors.handleConfiguration(ed);
        this.displayNameInVisio();
    }

    protected void displayNameInVisio() {
        String visioInfo = "<b>" + this.getName();
        this.gisShell.submitTopicToServer("VISIO_INFO", visioInfo);
    }

    protected void displayActivityInVisio(AcrossActivity aa) {
        if (aa == null) {
            this.displayNameInVisio();
        } else {
            String visioInfo = "<b>" + this.getName() + " <c00FF00>" + aa;
            this.gisShell.submitTopicToServer("VISIO_INFO", visioInfo);
        }
    }

    protected void displayVisioAction(byte action) {
        this.gisShell.submitTopicToServer("VISIO_ACTION", "" + action, this.getAddress().toString());
    }

    @Override
    public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
        if (matchingFilter.equals("EmergencyCentre")) {
            int i = 0;
            while (i < records.length) {
                DirectoryRecord record = records[i];
                this.emergencyAgents.add(record.address);
                ++i;
            }
        }
    }

    public void destroyEntity(String contName) {
        this.displayVisioAction((byte)52);
        this.gisShell.submitTopicToServer("TOPIC_AGENT", contName, "REMOVE_AGENT");
    }

    public class RepairVehicleIdleTask
    extends Task
    implements MessageConstants {
        public RepairVehicleIdleTask(ConversationUnit cu) {
            super(cu);
        }

        @Override
        public void handleIncomingMessage(Message mes) {
            if (mes.getPerformative().equalsIgnoreCase("REQUEST")) {
                Object content = mes.getContent();
                if (content instanceof AcrossActivity) {
                    RepairVehicleAgent.this.newActivityRequestObtained(mes);
                } else if (content instanceof String) {
                    RepairVehicleAgent.this.freeDriverRequestObtained(mes);
                }
            } else if (mes.getProtocol().equalsIgnoreCase("CONTRACT-NET")) {
                RepairVehicleAgent.this.cnpForAccidentHandlingObtained(mes);
            }
        }
    }
}

