/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.repair;

import across.agents.emergency.centre.AcrossActivity;
import across.agents.emergency.repair.RepairRequestParticipantTask;
import across.agents.emergency.repair.RepairVehicleActivities;
import across.agents.emergency.repair.RepairVehicleAgent;
import across.data.simulation.EffectOnSimulationObject;
import across.data.simulation.SimulationObjectDescription;
import aglobe.ontology.Message;
import aglobex.simulation.utils.timer.SimulationTimeoutTask;

public class RepairVehicleActivityHandler
implements RepairVehicleActivities {
    private boolean running = false;
    private RepairVehicleAgent owner;
    private AcrossActivity currentActivity;
    private ActivityEndCondition currentActivityEndCondition;
    private RepairRequestParticipantTask reportTask;

    public RepairVehicleActivityHandler(RepairVehicleAgent owner) {
        this.owner = owner;
    }

    public void handleActivity(AcrossActivity act, RepairRequestParticipantTask rpt) {
        this.currentActivity = act;
        this.reportTask = rpt;
        this.running = true;
        this.startActivity();
    }

    public void run() {
        if (this.running && this.currentActivityEndCondition.isDone()) {
            System.out.println(String.valueOf(this.owner.getName()) + "- Activity done: " + this.currentActivity.getActivityType());
            this.currentActivityEndCondition.finishActivity();
            this.reportTask.sendInformResult(new Boolean(!this.currentActivityEndCondition.isFailed()));
            this.running = false;
        }
    }

    private void startActivity() {
        String activityType = this.currentActivity.getActivityType();
        if (activityType.equalsIgnoreCase("ACTIVITY_GOTO")) {
            System.out.println("Starting activity: " + activityType + " to " + this.currentActivity.getParams().get("TO") + " for object: " + this.currentActivity.getParams().get("OBJECT"));
            this.handleGOTOActivity();
        } else if (activityType.equalsIgnoreCase("ACTIVITY_PICKUP")) {
            System.out.println("Starting activity: " + activityType);
            this.handlePickupActivity();
        } else if (activityType.equalsIgnoreCase("ACTIVITY_DROP")) {
            System.out.println("Starting activity: " + activityType);
            this.handleDropActivity();
        } else if (activityType.equalsIgnoreCase("ACTIVITY_EFFECT")) {
            System.out.println("Starting activity: " + activityType);
            this.handleEffectActivity();
        } else {
            this.owner.logSevere("Unknown activity specified");
        }
    }

    private void handleDropActivity() {
        this.currentActivityEndCondition = new ActivityEndCondition(){

            @Override
            public void finishActivity() {
                RepairVehicleActivityHandler.this.owner.displayVisioAction((byte)1);
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public boolean isFailed() {
                return false;
            }
        };
    }

    private void handlePickupActivity() {
        this.currentActivityEndCondition = new ActivityEndCondition(){

            @Override
            public void finishActivity() {
                RepairVehicleActivityHandler.this.owner.displayVisioAction((byte)2);
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public boolean isFailed() {
                return false;
            }
        };
    }

    private void handleEffectActivity() {
        final String where = (String)this.currentActivity.getParams().get("WHERE");
        if (where != null) {
            this.owner.myEffect = EffectOnSimulationObject.getEffectForObjectAndDefaultEffect(where, this.owner.myEffect);
            final SimulationTimeoutTask stt = new SimulationTimeoutTask(this.owner, this.owner.effectSpeed){

                @Override
                protected void timeout() {
                    if (((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.mySensors.isObjectInSight(where)) {
                        ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.gisShell.submitTopicToServer("TOPIC_SIMULATION_OBJECT", ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myEffect, "CONTROL_CHANGE_SIMULATION_OBJECT");
                    }
                    this.rescheduleTimer(((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.effectSpeed);
                }

                @Override
                protected void handleIncomingMessage(Message m) {
                }
            };
            this.currentActivityEndCondition = new ActivityEndCondition(){

                @Override
                public void finishActivity() {
                    stt.cancelTask();
                }

                @Override
                public boolean isDone() {
                    if (!((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.mySensors.isObjectInSight(where)) {
                        return true;
                    }
                    SimulationObjectDescription sod = ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.mySensors.getObjectsDescription(where);
                    if (sod == null) {
                        return false;
                    }
                    if (((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myEffect.constructionDamageDiff < 0 && sod.getConstructionDamage() > 0) {
                        return false;
                    }
                    if (((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myEffect.fireDiff < 0 && sod.getExtentOfFire() > 0) {
                        return false;
                    }
                    if (((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myEffect.insurgencyDiff < 0 && sod.getInsurgencyLevel() > 0) {
                        return false;
                    }
                    return ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myEffect.woundedDiff >= 0 || sod.getNumberOfWounded() <= 0;
                }

                @Override
                public boolean isFailed() {
                    return false;
                }
            };
        } else {
            this.owner.logSevere("Target object not specified");
        }
    }

    private void handleGOTOActivity() {
        final String to = (String)this.currentActivity.getParams().get("TO");
        String from = null;
        if (this.currentActivity.getParams().containsKey("FROM")) {
            from = (String)this.currentActivity.getParams().get("FROM");
        }
        final String objectId = (String)this.currentActivity.getParams().get("OBJECT");
        this.currentActivityEndCondition = new ActivityEndCondition(){

            @Override
            public boolean isDone() {
                if (objectId != null) {
                    return ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.mySensors.isObjectInSight(objectId) || !((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myMovement.isOnRoute() && ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myMovement.actualLoc.equals(to);
                }
                return ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myMovement.actualLoc.equals(to);
            }

            @Override
            public boolean isFailed() {
                return false;
            }

            @Override
            public void finishActivity() {
                ((RepairVehicleActivityHandler)RepairVehicleActivityHandler.this).owner.myMovement.stopMovement();
            }
        };
        if (from == null) {
            this.owner.myMovement.goToLocation(to);
        } else {
            this.owner.myMovement.driveThroughRoad(from, to);
        }
    }

    public static interface ActivityEndCondition {
        public boolean isDone();

        public boolean isFailed();

        public void finishActivity();
    }
}

