/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.planner;

import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.protocol.request.RequestParticipantTask;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import iglobe.plan.OrderConstraint;
import iglobe.plan.PlanConstraint;
import iglobe.plan.RescueActivity;
import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import iglobe.plan.TransportActivity;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;

public class IXPlannerAgent
extends CMAgent
implements ClientServerTopicConstants,
GISTopicListener {
    public static final String TYPE = "IXPlanner";
    protected GISClientService.Shell gisShell;
    protected DirectoryService.Shell dirShell;

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.gisShell != null && this.dirShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
            this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
            this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
            this.gisShell.subscribeTopic("SENSORY_DATA", this);
            this.gisShell.subscribeTopic("TOPIC_SIMULATION_OBJECT", this);
        } else {
            this.logSevere("Unable to locate GIS!");
            this.stop();
        }
        try {
            this.dirShell.register((ElementaryEntity)this, new LinkedList<String>((Collection)Arrays.asList(TYPE)));
        }
        catch (DirectoryException e) {
            e.printStackTrace();
        }
        this.setIdleTask(new IXPlannerIdleTask(this));
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION") && content instanceof EntityDescriptor) {
            this.handleConfiguration((EntityDescriptor)content);
        }
    }

    private void handleConfiguration(EntityDescriptor ed) {
    }

    protected class IXPlannerIdleTask
    extends Task
    implements MessageConstants {
        public IXPlannerIdleTask(ConversationUnit cu) {
            super(cu);
        }

        @Override
        protected void handleIncomingMessage(Message m) {
            final Object content = m.getContent();
            if (m.getPerformative().equalsIgnoreCase("REQUEST") && content instanceof RescueTask) {
                new RequestParticipantTask(this, m){

                    @Override
                    protected void processRequest(Message requestMessage) {
                        RescueTask rt = (RescueTask)content;
                        RescuePlan rp = new RescuePlan();
                        LinkedList<RescueActivity> raList = new LinkedList<RescueActivity>();
                        LinkedList<PlanConstraint> pcList = new LinkedList<PlanConstraint>();
                        TransportActivity taGoToPlace = new TransportActivity();
                        taGoToPlace.setId("1");
                        taGoToPlace.setDestination(rt.getLocation());
                        taGoToPlace.setDescription("TRANSPORT");
                        taGoToPlace.setResource("Repair");
                        TransportActivity taUseEffect = new TransportActivity();
                        taUseEffect.setId("2");
                        taUseEffect.setDestination(rt.getLocation());
                        taUseEffect.setDescription("EFFECT");
                        taUseEffect.setResource("Repair");
                        raList.add(taGoToPlace);
                        raList.add(taUseEffect);
                        TransportActivity taGoToPlaceAmb = new TransportActivity();
                        taGoToPlaceAmb.setId("4");
                        taGoToPlaceAmb.setDestination(rt.getLocation());
                        taGoToPlaceAmb.setDescription("TRANSPORT");
                        taGoToPlaceAmb.setResource("Ambulance");
                        TransportActivity taHeal = new TransportActivity();
                        taHeal.setId("5");
                        taHeal.setDestination(rt.getLocation());
                        taHeal.setDescription("EFFECT");
                        taHeal.setResource("Ambulance");
                        raList.add(taGoToPlaceAmb);
                        raList.add(taHeal);
                        OrderConstraint pc12 = new OrderConstraint();
                        pc12.setFromId(taGoToPlace.getId());
                        pc12.setToId(taUseEffect.getId());
                        pcList.add(pc12);
                        OrderConstraint pc45 = new OrderConstraint();
                        pc45.setFromId(taGoToPlaceAmb.getId());
                        pc45.setToId(taHeal.getId());
                        pcList.add(pc45);
                        OrderConstraint pc25 = new OrderConstraint();
                        pc25.setFromId(taUseEffect.getId());
                        pc25.setToId(taHeal.getId());
                        pcList.add(pc25);
                        rp.setActivities(raList);
                        rp.setConstraints(pcList);
                        this.informResult(rp);
                    }
                };
            }
        }
    }
}

