/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.centre;

import across.agents.emergency.centre.AcrossActivity;
import across.agents.emergency.centre.AcrossPlan;
import across.agents.emergency.centre.EmergencyAgent;
import across.agents.emergency.centre.SchedulingKnowledge;
import across.data.RequestList;
import aglobe.container.transport.Address;
import aglobe.ontology.Message;
import aglobex.protocol.request.RequestInitiatorTask;
import aglobex.simulation.protocol.cnp.CNPInitiatorTask;
import iglobe.plan.RescuePlan;
import iglobe.plan.RescueTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class EventHandlingTransaction {
    protected SchedulingKnowledge schedulingKnowledge;
    protected EmergencyAgent owner;
    protected TransactionState state;
    protected RescueTask rescueTask;
    protected RescuePlan ixPlan;
    protected AcrossPlan acrossPlan;
    protected Map<String, Address> scheduledDrivers = new HashMap<String, Address>();
    protected List<String> driversFailedToSchedule = new ArrayList<String>();
    protected Map<String, Address> scheduledMaterial = new HashMap<String, Address>();
    protected Map<String, String> scheduledMaterialLocation = new HashMap<String, String>();
    protected List<String> materialFailedToSchedule = new ArrayList<String>();
    protected Map<AcrossActivity, AcrossActivity.ActivityState> activityStates = new HashMap<AcrossActivity, AcrossActivity.ActivityState>();

    public EventHandlingTransaction(RescueTask event, EmergencyAgent owner, SchedulingKnowledge schedulingKnowledge) {
        this.rescueTask = event;
        this.owner = owner;
        this.schedulingKnowledge = schedulingKnowledge;
        this.state = TransactionState.NOT_PLANNED;
    }

    public void run() {
        switch (this.state) {
            case NOT_PLANNED: {
                this.plan(this.rescueTask, this.driversFailedToSchedule, this.materialFailedToSchedule);
                break;
            }
            case PLANNING: {
                return;
            }
            case NOT_SCHEDULED: {
                this.acrossPlan = this.schedulingKnowledge.ixToAcrossPlanParser.ixToAcrossPlan(this.ixPlan);
                this.schedulePlan(this.acrossPlan);
                break;
            }
            case SCHEDULING: {
                if (!this.checkSchedulingDone()) break;
                if (this.checkSchedulingSuccess()) {
                    this.state = TransactionState.NOT_EXECUTED;
                    break;
                }
                this.flushScheduled();
                this.state = TransactionState.NOT_PLANNED;
                break;
            }
            case NOT_EXECUTED: {
                this.prepareExecution();
                break;
            }
            case EXECUTING: {
                this.executeReady();
                if (!this.checkExecutingDone()) break;
                this.flushScheduled();
                this.state = TransactionState.DONE;
                break;
            }
            case DONE: {
                break;
            }
            case FAILED: {
                break;
            }
            default: {
                this.owner.logSevere("Unknown state of transaction: " + (Object)((Object)this.state));
            }
        }
    }

    public boolean finished() {
        return this.state == TransactionState.DONE || this.state == TransactionState.FAILED;
    }

    public boolean failed() {
        return this.state == TransactionState.FAILED;
    }

    public void restart() {
        this.state = TransactionState.NOT_PLANNED;
        this.flushScheduled();
        this.materialFailedToSchedule.clear();
        this.driversFailedToSchedule.clear();
    }

    private void plan(RescueTask rt, List<String> driverNAConstraints, List<String> materialNAConstraints) {
        this.rescueTask.getUnavailableResources().addAll(driverNAConstraints);
        this.state = TransactionState.PLANNING;
        new RequestInitiatorTask(this.owner, this.schedulingKnowledge.plannerAddress, rt){

            @Override
            protected void informDone() {
            }

            @Override
            protected void informResult(final Object result) {
                EventHandlingTransaction.this.owner.addEvent(new Runnable(){

                    @Override
                    public void run() {
                        if (result == null) {
                            (this).EventHandlingTransaction.this.state = TransactionState.FAILED;
                        } else {
                            (this).EventHandlingTransaction.this.ixPlan = (RescuePlan)result;
                            (this).EventHandlingTransaction.this.state = TransactionState.NOT_SCHEDULED;
                        }
                    }
                });
            }
        };
    }

    private void schedulePlan(AcrossPlan ap) {
        this.state = TransactionState.SCHEDULING;
        for (String driverId : ap.drivers.keySet()) {
            this.scheduledDrivers.put(driverId, null);
        }
        this.driversFailedToSchedule.clear();
        for (String materialId : ap.material.keySet()) {
            this.scheduledMaterial.put(materialId, null);
        }
        this.materialFailedToSchedule.clear();
        this.cnpForDrivers(ap);
        this.cnpForMaterial(ap);
    }

    private void cnpForMaterial(AcrossPlan ap) {
        for (final String materialId : ap.material.keySet()) {
            new CNPInitiatorTask(this.owner, this.schedulingKnowledge.storageAddresses, new RequestList(), 1000, "SCHEDULE_EMERGENCY_MATERIAL"){

                @Override
                protected boolean evaluateAcceptReply(Message m) {
                    return false;
                }

                @Override
                protected void evaluateAcceptTimeout() {
                }

                @Override
                protected List<Address> evaluateReplies() {
                    LinkedList<Address> oneMaterial = new LinkedList<Address>();
                    String location = null;
                    if (this.receivedOffers.size() > 0) {
                        Random r = new Random();
                        int ind = r.nextInt(this.receivedOffers.size());
                        ArrayList adrList = new ArrayList(this.receivedOffers.keySet());
                        Address address = (Address)adrList.get(ind);
                        Message mes = (Message)this.receivedOffers.get(address);
                        oneMaterial.add(address);
                        location = (String)mes.getContent();
                    }
                    if (oneMaterial.size() == 0) {
                        EventHandlingTransaction.this.materialFailedToSchedule.add(materialId);
                    } else {
                        EventHandlingTransaction.this.scheduledMaterial.put(materialId, (Address)oneMaterial.get(0));
                        EventHandlingTransaction.this.scheduledMaterialLocation.put(materialId, location);
                    }
                    return oneMaterial;
                }
            };
        }
    }

    private void cnpForDrivers(AcrossPlan ap) {
        for (final String driverId : ap.drivers.keySet()) {
            ArrayList<Address> resAddr = new ArrayList<Address>();
            for (Address address : this.schedulingKnowledge.driversAddresses) {
                if (address.getContainerName().indexOf(driverId) == -1) continue;
                resAddr.add(address);
            }
            if (resAddr.size() == 0) {
                this.driversFailedToSchedule.add(driverId);
                continue;
            }
            new CNPInitiatorTask(this.owner, resAddr, this.rescueTask.getLocation(), 10000, "SCHEDULE_EMERGENCY_DRIVER"){

                @Override
                protected List<Address> evaluateReplies() {
                    LinkedList<Address> driverList = new LinkedList<Address>();
                    Address oneDriver = null;
                    if (this.receivedOffers.size() > 0) {
                        double lowestTime = Double.MAX_VALUE;
                        for (Address address : this.receivedOffers.keySet()) {
                            Message mes = (Message)this.receivedOffers.get(address);
                            Double timeToPlace = (Double)mes.getContent();
                            if (timeToPlace == null || !(timeToPlace < lowestTime)) continue;
                            lowestTime = timeToPlace;
                            oneDriver = mes.getSender();
                        }
                        if (oneDriver == null) {
                            EventHandlingTransaction.this.driversFailedToSchedule.add(driverId);
                        } else {
                            driverList.add(oneDriver);
                            EventHandlingTransaction.this.scheduledDrivers.put(driverId, oneDriver);
                        }
                    }
                    return driverList;
                }

                @Override
                protected boolean evaluateAcceptReply(Message m) {
                    return false;
                }

                @Override
                protected void evaluateAcceptTimeout() {
                }
            };
        }
    }

    private void flushScheduled() {
        if (this.scheduledDrivers.size() > 0) {
            for (Address address : this.scheduledDrivers.values()) {
                if (address == null) continue;
                new RequestInitiatorTask(this.owner, address, "CANCEL_DRIVER_SCHEDULE"){

                    @Override
                    protected void informDone() {
                    }

                    @Override
                    protected void informResult(Object result) {
                    }
                };
            }
        }
        this.scheduledDrivers.clear();
        this.scheduledMaterial.clear();
    }

    private boolean checkSchedulingDone() {
        for (String driverId : this.scheduledDrivers.keySet()) {
            if (this.scheduledDrivers.get(driverId) != null || this.driversFailedToSchedule.contains(driverId)) continue;
            return false;
        }
        for (String materialId : this.scheduledMaterial.keySet()) {
            if (this.scheduledMaterial.get(materialId) != null || this.materialFailedToSchedule.contains(materialId)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSchedulingSuccess() {
        return this.driversFailedToSchedule.size() == 0 && this.materialFailedToSchedule.size() == 0;
    }

    private void prepareExecution() {
        for (AcrossActivity aa : this.acrossPlan.activitiesHandlers.keySet()) {
            this.activityStates.put(aa, AcrossActivity.ActivityState.WAITING);
            for (String storage : this.scheduledMaterial.keySet()) {
                aa.replaceStringInParams(storage, this.scheduledMaterial.get(storage).getContainerName());
                aa.replaceStringInParams(String.valueOf(storage) + "LOCATION", this.scheduledMaterialLocation.get(storage));
            }
        }
        this.state = TransactionState.EXECUTING;
    }

    private void executeReady() {
        for (final AcrossActivity act : this.activityStates.keySet()) {
            if (this.activityStates.get(act) != AcrossActivity.ActivityState.WAITING) continue;
            boolean precOk = true;
            List<AcrossActivity> precActList = this.acrossPlan.precedences.get(act);
            if (precActList != null && precActList.size() != 0) {
                for (AcrossActivity precAct : precActList) {
                    if (this.activityStates.get(precAct) == AcrossActivity.ActivityState.DONE) continue;
                    precOk = false;
                    break;
                }
            }
            if (!precOk) continue;
            this.activityStates.put(act, AcrossActivity.ActivityState.EXECUTING);
            new RequestInitiatorTask(this.owner, this.scheduledDrivers.get(this.acrossPlan.activitiesHandlers.get(act)), act){

                @Override
                protected void informDone() {
                }

                @Override
                protected void informResult(Object result) {
                    Boolean done = (Boolean)result;
                    if (done.booleanValue()) {
                        System.out.println("Acitivity done: " + act.activityType + " by " + EventHandlingTransaction.this.scheduledDrivers.get(EventHandlingTransaction.this.acrossPlan.activitiesHandlers.get(act)).getName());
                        EventHandlingTransaction.this.activityStates.put(act, AcrossActivity.ActivityState.DONE);
                    } else {
                        EventHandlingTransaction.this.activityStates.put(act, AcrossActivity.ActivityState.FAILED);
                    }
                }
            };
        }
    }

    protected boolean checkExecutingDone() {
        boolean done = true;
        for (AcrossActivity.ActivityState act : this.activityStates.values()) {
            if (act == AcrossActivity.ActivityState.DONE || act == AcrossActivity.ActivityState.FAILED) continue;
            done = false;
            break;
        }
        return done;
    }

    protected static enum TransactionState {
        NOT_PLANNED,
        PLANNING,
        NOT_SCHEDULED,
        SCHEDULING,
        NOT_EXECUTED,
        EXECUTING,
        DONE,
        FAILED;

    }
}

