/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.centre;

import across.agents.emergency.centre.AccidentsHandlingResolver;
import across.agents.emergency.centre.EventHandlingTransaction;
import across.agents.emergency.centre.SchedulingKnowledge;
import across.data.simulation.SimulationObjectDescription;
import across.util.ixplanparser.IxPlanParser;
import across.util.ixplanparser.ParserKnowledge;
import aglobe.container.ElementaryEntity;
import aglobe.container.agent.CMAgent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobe.util.AglobeXMLtools;
import aglobe.visio3D.ontology.Chart;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import iglobe.plan.RescueTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EmergencyAgent
extends CMAgent
implements ClientServerTopicConstants,
GISTopicListener,
DirectoryListener {
    public static final String TYPE = "EmergencyCentre";
    protected GISClientService.Shell gisShell;
    protected DirectoryService.Shell dirShell;
    protected SchedulingKnowledge schedulingKnowledge = new SchedulingKnowledge();
    protected Map<String, EventHandlingTransaction> rescueActions = new HashMap<String, EventHandlingTransaction>();
    protected List<String> registeredAccidents = new LinkedList<String>();
    protected String plannerName;
    protected List<Address> otherEmergencyAgents = new ArrayList<Address>();
    protected AccidentsHandlingResolver handlingResolver;

    @Override
    public void init(AgentInfo ai, int initState) {
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        this.dirShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.gisShell != null && this.dirShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
            this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
            this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
        } else {
            this.logSevere("Unable to locate GIS!");
            this.stop();
        }
        try {
            this.dirShell.register((ElementaryEntity)this, new ArrayList<String>((Collection)Arrays.asList(TYPE)));
        }
        catch (DirectoryException e) {
            e.printStackTrace();
        }
        this.dirShell.subscribe(this, "Repair");
        this.dirShell.subscribe(this, "EmergencyStorageAgent");
        this.dirShell.subscribe(this, TYPE);
        this.setIdleTask(new EmergencyAgentIdleTask(this));
        this.handlingResolver = new AccidentsHandlingResolver(this){

            @Override
            public int getPriority(SimulationObjectDescription sod) {
                if (EmergencyAgent.this.rescueActions.get(sod.getName()) != null) {
                    return Integer.MAX_VALUE;
                }
                return this.hashCode() % 10000 - 10000 * EmergencyAgent.this.rescueActions.size();
            }

            @Override
            public void readyForHandling(SimulationObjectDescription sod) {
                EmergencyAgent.this.handleAccident(sod);
            }
        };
    }

    public void handleAccident(SimulationObjectDescription sod) {
        if (!this.rescueActions.keySet().contains(sod.getName())) {
            RescueTask rt = new RescueTask(String.valueOf(sod.getName()) + "@" + sod.getLocation().startLocation + "<->" + sod.getLocation().endLocation, sod.getNumberOfWounded());
            rt.setId(sod.getName());
            rt.setUnavailableResources(new LinkedList<String>());
            EventHandlingTransaction trans = new EventHandlingTransaction(rt, this, this.schedulingKnowledge);
            this.rescueActions.put(sod.getName(), trans);
        }
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("ENTITY_CONNECTION")) {
            if (content instanceof EntityDescriptor) {
                EntityDescriptor ed = (EntityDescriptor)content;
                this.handleConfiguration(ed);
            }
        } else if (topic.equalsIgnoreCase("SIMULATION_TIME_UPDATE_1_SECOND")) {
            this.displayEventsChart();
            Iterator<Map.Entry<String, EventHandlingTransaction>> iter = this.rescueActions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, EventHandlingTransaction> eventEntry = iter.next();
                EventHandlingTransaction eht = eventEntry.getValue();
                if (eht.finished()) {
                    if (eht.failed()) {
                        eht.restart();
                        continue;
                    }
                    this.registeredAccidents.remove(eventEntry.getKey());
                    iter.remove();
                    continue;
                }
                eht.run();
            }
        }
    }

    protected void handleConfiguration(EntityDescriptor ed) {
        String visioInfo = "<b>" + this.getName();
        this.gisShell.submitTopicToServer("VISIO_INFO", visioInfo);
        this.plannerName = ed.confParamsString.get("EMERGENCY_CENTRE_PLANNER_NAME");
        this.dirShell.subscribe(this, this.plannerName);
        ParserKnowledge pk = new ParserKnowledge();
        pk.getVehicles().addAll(new ArrayList(Arrays.asList("ambulance", "truck", "police-team")));
        ArrayList docPickupMaterials = new ArrayList(Arrays.asList("doctor", "paramedic"));
        ArrayList docDropMaterials = new ArrayList(Arrays.asList("injured-person"));
        pk.getPickupMaterials().addAll(docPickupMaterials);
        pk.getDropMaterials().addAll(docDropMaterials);
        ArrayList docTransportMaterials = new ArrayList();
        docTransportMaterials.addAll(docPickupMaterials);
        docTransportMaterials.addAll(docDropMaterials);
        pk.getWhichVehicleTransportWhichMaterial().put("ambulance", docTransportMaterials);
        pk.getWhichVehicleTransportWhichMaterial().put("truck", docTransportMaterials);
        pk.getWhichVehicleTransportWhichMaterial().put("police-team", null);
        pk.getTemplatePlaces().put("hospital", "Storage");
        this.schedulingKnowledge.ixToAcrossPlanParser = new IxPlanParser(pk);
    }

    protected void displayEventsChart() {
        if (this.rescueActions.size() == 0) {
            return;
        }
        Chart chart = new Chart();
        for (EventHandlingTransaction eht : this.rescueActions.values()) {
            String objId = eht.rescueTask.getLocation();
            objId = objId.substring(0, objId.indexOf("@"));
            chart.getContent().add(AglobeXMLtools.makeSimpleBar(objId, this.getColorForState(eht.state), (byte)-1));
        }
        this.gisShell.submitTopicToServer("SET_CHART", chart, this.getContainer().getContainerName());
    }

    private byte getColorForState(EventHandlingTransaction.TransactionState state) {
        if (state == EventHandlingTransaction.TransactionState.NOT_PLANNED || state == EventHandlingTransaction.TransactionState.PLANNING) {
            return 3;
        }
        if (state == EventHandlingTransaction.TransactionState.NOT_SCHEDULED || state == EventHandlingTransaction.TransactionState.SCHEDULING) {
            return 5;
        }
        if (state == EventHandlingTransaction.TransactionState.NOT_EXECUTED || state == EventHandlingTransaction.TransactionState.EXECUTING) {
            return 7;
        }
        if (state == EventHandlingTransaction.TransactionState.DONE) {
            return 2;
        }
        return 1;
    }

    protected void displayVisioAction(byte action) {
        this.gisShell.submitTopicToServer("VISIO_ACTION", "" + action, this.getAddress().toString());
    }

    @Override
    public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        if (!matchingFilter.equalsIgnoreCase("Repair")) break block6;
                        int i = 0;
                        while (i < records.length) {
                            this.schedulingKnowledge.driversAddresses.add(records[i].address);
                            ++i;
                        }
                        break block7;
                    }
                    if (!matchingFilter.equalsIgnoreCase("EmergencyStorageAgent")) break block8;
                    int i = 0;
                    while (i < records.length) {
                        this.schedulingKnowledge.storageAddresses.add(records[i].address);
                        ++i;
                    }
                    break block7;
                }
                if (!matchingFilter.equalsIgnoreCase(this.plannerName)) break block9;
                int i = 0;
                while (i < records.length) {
                    if (records[i].containerName.equals(this.getContainer().getContainerName())) {
                        this.schedulingKnowledge.plannerAddress = records[i].address;
                    }
                    ++i;
                }
                break block7;
            }
            if (!matchingFilter.equalsIgnoreCase(TYPE)) break block7;
            int i = 0;
            while (i < records.length) {
                if (!records[i].address.equals(this.getAddress())) {
                    this.otherEmergencyAgents.add(records[i].address);
                }
                ++i;
            }
        }
    }

    public class EmergencyAgentIdleTask
    extends Task
    implements MessageConstants {
        public EmergencyAgentIdleTask(ConversationUnit cu) {
            super(cu);
        }

        @Override
        protected void handleIncomingMessage(Message m) {
            SimulationObjectDescription sod;
            if (m.getProtocol() != null && m.getProtocol().equals("ACCIDENT_HANDLING_RESOLUTION_PROTOCOL")) {
                EmergencyAgent.this.handlingResolver.incomingMessage(m);
            } else if (m.getPerformative().equals("INFORM") && !EmergencyAgent.this.registeredAccidents.contains((sod = (SimulationObjectDescription)m.getContent()).getName())) {
                EmergencyAgent.this.registeredAccidents.add(sod.getName());
                EmergencyAgent.this.handlingResolver.startResolution(sod, EmergencyAgent.this.otherEmergencyAgents);
            }
        }
    }
}

