/*
 * Decompiled with CFR 0.152.
 */
package across.agents.emergency.centre;

import across.agents.emergency.centre.AccidentsHandlingProtocolData;
import across.data.simulation.SimulationObjectDescription;
import aglobe.container.task.ConversationUnit;
import aglobe.container.task.Task;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.Message;
import aglobe.ontology.MessageConstants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AccidentsHandlingResolver {
    protected ConversationUnit cu;
    protected Map<String, Integer> priorityMap = new HashMap<String, Integer>();

    public AccidentsHandlingResolver(ConversationUnit cu) {
        this.cu = cu;
    }

    public void startResolution(SimulationObjectDescription sod, List<Address> adrList) {
        new AccidentHandlingResolutionProtocolInitiator(this.cu, sod, adrList);
    }

    public void incomingMessage(Message mes) {
        new AccidentHandlingResolutionProtocolParticipant(this.cu, mes);
    }

    public abstract void readyForHandling(SimulationObjectDescription var1);

    public abstract int getPriority(SimulationObjectDescription var1);

    protected class AccidentHandlingResolutionProtocolInitiator
    extends Task
    implements MessageConstants {
        private SimulationObjectDescription sod;
        private List<Address> addList;
        private Map<Message, AccidentsHandlingProtocolData> replies;

        public AccidentHandlingResolutionProtocolInitiator(ConversationUnit cu, SimulationObjectDescription sod, List<Address> otherCentres) {
            super(cu);
            this.replies = new HashMap<Message, AccidentsHandlingProtocolData>();
            this.sod = sod;
            this.addList = otherCentres;
            AccidentsHandlingResolver.this.priorityMap.put(sod.getName(), AccidentsHandlingResolver.this.getPriority(sod));
            for (Address address : otherCentres) {
                Message mes = Message.newInstance("INFORM");
                mes.setProtocol("ACCIDENT_HANDLING_RESOLUTION_PROTOCOL");
                mes.setReceiver(address);
                mes.setSender(this.getAddress());
                AccidentsHandlingProtocolData content = new AccidentsHandlingProtocolData();
                content.priority = AccidentsHandlingResolver.this.priorityMap.get(sod.getName());
                content.sod = sod;
                mes.setContent(content);
                try {
                    this.sendMessage(mes);
                }
                catch (InvisibleContainerException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        protected void handleIncomingMessage(Message m) {
            this.replies.put(m, (AccidentsHandlingProtocolData)m.getContent());
            if (this.replies.size() == this.addList.size()) {
                boolean handle = true;
                int highest = AccidentsHandlingResolver.this.priorityMap.get(this.sod.getName());
                Address highestAddr = null;
                for (Message mes : this.replies.keySet()) {
                    AccidentsHandlingProtocolData pd = this.replies.get(mes);
                    if (pd.priority < highest) continue;
                    handle = false;
                    highest = pd.priority;
                    highestAddr = mes.getSender();
                }
                if (!handle && highest == AccidentsHandlingResolver.this.priorityMap.get(this.sod.getName()) && highestAddr.hashCode() < this.getAddress().hashCode()) {
                    AccidentsHandlingResolver.this.priorityMap.put(this.sod.getName(), highest += this.getAddress().hashCode());
                    handle = true;
                }
                AccidentsHandlingProtocolData pd = new AccidentsHandlingProtocolData();
                pd.sod = this.sod;
                pd.priority = highest;
                for (Message mes : this.replies.keySet()) {
                    Message rep = mes.getReply();
                    rep.setContent(pd);
                    try {
                        this.sendMessage(rep);
                    }
                    catch (InvisibleContainerException e) {
                        e.printStackTrace();
                    }
                }
                if (handle) {
                    AccidentsHandlingResolver.this.priorityMap.remove(this.sod);
                    AccidentsHandlingResolver.this.readyForHandling(this.sod);
                }
            }
        }
    }

    protected class AccidentHandlingResolutionProtocolParticipant
    extends Task
    implements MessageConstants {
        public AccidentHandlingResolutionProtocolParticipant(ConversationUnit cu, Message mes) {
            super(cu);
            Message rep = mes.getReply();
            AccidentsHandlingProtocolData pd = (AccidentsHandlingProtocolData)mes.getContent();
            AccidentsHandlingResolver.this.priorityMap.put(pd.sod.getName(), AccidentsHandlingResolver.this.getPriority(pd.sod));
            AccidentsHandlingProtocolData myPd = new AccidentsHandlingProtocolData();
            myPd.sod = pd.sod;
            myPd.priority = AccidentsHandlingResolver.this.priorityMap.get(pd.sod.getName());
            rep.setContent(myPd);
            try {
                this.sendMessage(rep);
            }
            catch (InvisibleContainerException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void handleIncomingMessage(Message m) {
            AccidentsHandlingProtocolData pd = (AccidentsHandlingProtocolData)m.getContent();
            if (AccidentsHandlingResolver.this.priorityMap.get(pd.sod) != null && pd.priority == AccidentsHandlingResolver.this.priorityMap.get(pd.sod)) {
                AccidentsHandlingResolver.this.priorityMap.remove(pd.sod);
                AccidentsHandlingResolver.this.readyForHandling(pd.sod);
            }
        }
    }
}

