/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver.gui;

import across.agents.driver.data.RoadInfo;
import across.agents.driver.gui.DriverGUIInterface;
import across.data.Batch;
import across.data.RequestList;
import across.data.Waypoint;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RouteTabModel
extends AbstractTableModel {
    DriverGUIInterface core;
    final String[] names = new String[]{"From", "To", "Time", "Price", "Goal"};

    public RouteTabModel(DriverGUIInterface core) {
        this.core = core;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public int getRowCount() {
        return this.core.getWaypoints().size();
    }

    @Override
    public String getColumnName(int col) {
        return this.names[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Waypoint toWP;
        String from;
        if (row == 0) {
            from = this.core.getActualNode();
            toWP = (Waypoint)this.core.getWaypoints().getFirst();
        } else {
            from = ((Waypoint)this.core.getWaypoints().get(row - 1)).getLocationName();
            toWP = (Waypoint)this.core.getWaypoints().get(row);
        }
        String to = toWP.getLocationName();
        int fromIndex = this.core.getNodeNames().indexOf(from);
        int toIndex = this.core.getNodeNames().indexOf(to);
        RoadInfo arcValue = this.core.getArcs()[fromIndex][toIndex];
        switch (col) {
            case 0: {
                return from;
            }
            case 1: {
                return to;
            }
            case 2: {
                if (arcValue == null) {
                    return new Integer(0);
                }
                return new Double((double)((int)(100.0 * arcValue.time)) / 100.0);
            }
            case 3: {
                if (arcValue == null) {
                    return new Integer(0);
                }
                return new Double((double)((int)(100.0 * arcValue.price)) / 100.0);
            }
            case 4: {
                List<RequestList> rl = toWP.getRequestList();
                if (rl.size() == 0) {
                    return "Pass";
                }
                String s = "";
                for (RequestList r : rl) {
                    for (Batch b : r.getBatch()) {
                        s = String.valueOf(s) + "(" + b.getComodityName() + "/" + b.getCount() + ") ";
                    }
                }
                return s;
            }
        }
        return "";
    }
}

