/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver.gui;

import across.data.Batch;
import across.data.RequestList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RequestTabModel
extends AbstractTableModel {
    List requests;
    final String[] names = new String[]{"Delivery Agent", "Commodity", "Count", "Time", "BatchID"};

    public RequestTabModel(List requests) {
        this.requests = requests;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public int getRowCount() {
        int i = 0;
        for (RequestList rl : this.requests) {
            i += rl.getBatch().size();
        }
        return i;
    }

    @Override
    public String getColumnName(int col) {
        return this.names[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        int i = 0;
        Batch selectedBatch = null;
        String agentName = "";
        for (RequestList rl : this.requests) {
            for (Batch batch : rl.getBatch()) {
                if (i == row) {
                    selectedBatch = batch;
                    break;
                }
                ++i;
            }
            if (selectedBatch == null) continue;
            agentName = rl.getDeliveryAddress().getName();
            break;
        }
        switch (col) {
            case 0: {
                return agentName;
            }
            case 1: {
                return selectedBatch.getComodityName();
            }
            case 2: {
                return new Long(selectedBatch.getCount());
            }
            case 3: {
                return new Long(selectedBatch.getDeliveryTime());
            }
            case 4: {
                return new Long(selectedBatch.getBatchid());
            }
        }
        return "";
    }
}

