/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver.gui;

import across.agents.driver.gui.DriverAgentGUI_jButtonGo_actionAdapter;
import across.agents.driver.gui.DriverAgentGUI_routeTable_mouseAdapter;
import across.agents.driver.gui.DriverGUIInterface;
import across.agents.driver.gui.RequestTabModel;
import across.agents.driver.gui.RouteTabModel;
import across.data.Waypoint;
import aglobe.container.Store;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DriverAgentGUI
extends JFrame {
    private final DriverGUIInterface owner;
    private final Store store;
    private static final String GUI_X = "gui/x";
    private static final String GUI_Y = "gui/y";
    private static final String GUI_W = "gui/w";
    private static final String GUI_H = "gui/h";
    public int routeTabSelectedRow = 0;
    TitledBorder bordInfo = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Info");
    TitledBorder bordRoute = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Route");
    TitledBorder bordRequest = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Requests");
    TitledBorder bordManual = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Manual Command");
    JTextArea jTextAreaTopic = new JTextArea();
    JPanel jPanel1 = new JPanel();
    JComboBox jComboBoxWP = new JComboBox();
    JButton jButtonGo = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    public RouteTabModel routeTabModel;
    public JTable routeTable;
    public RequestTabModel requestTabModel;
    public JTable requestTable;
    public JScrollPane jScrollPaneRoute = new JScrollPane();
    public JScrollPane jScrollPaneRequest = new JScrollPane();
    public JPanel jPanelManual = new JPanel();
    public JPanel jPanelInfo = new JPanel();
    public GridBagLayout gridBagLayout1 = new GridBagLayout();
    public JLabel jLabelPosition = new JLabel();
    public JLabel jLabelCapacity = new JLabel();
    public JTextField jTextFieldPosition = new JTextField();
    public JProgressBar jProgressBarCapacity = new JProgressBar();
    public JLabel jLabelTransporter = new JLabel();
    public JLabel jLabelConsumption = new JLabel();
    public JLabel jLabelSpeed = new JLabel();
    public JLabel jLabelTaskTime = new JLabel();
    public JTextField jTextFieldTransporter = new JTextField();
    public JTextField jTextFieldTaskTime = new JTextField();
    public JTextField jTextFieldConsumption = new JTextField();
    public JTextField jTextFieldSpeed = new JTextField();
    public GridBagLayout gridBagLayout2 = new GridBagLayout();
    public BorderLayout borderLayout1 = new BorderLayout();

    public DriverAgentGUI(DriverGUIInterface owner) {
        this.owner = owner;
        this.store = owner.getContainer().getAgentStore(owner.getName());
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addToCombo(String text) {
        this.jComboBoxWP.addItem(text);
    }

    public void addToTextArea(String text) {
        if (this.jTextAreaTopic.getText().length() > 1000) {
            this.jTextAreaTopic.setText("");
        }
        this.jTextAreaTopic.append(String.valueOf(text) + "\n");
    }

    private void jbInit() throws Exception {
        this.setTitle("DriverAgent " + this.owner.getName());
        this.setSize(new Dimension(580, 600));
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.routeTabModel = new RouteTabModel(this.owner);
        this.routeTable = new JTable(this.routeTabModel);
        this.routeTable.setRowSelectionAllowed(true);
        this.requestTabModel = new RequestTabModel(new ArrayList(0));
        this.requestTable = new JTable(this.requestTabModel);
        this.jButtonGo.setMaximumSize(new Dimension(75, 25));
        this.jButtonGo.setMinimumSize(new Dimension(75, 25));
        this.jButtonGo.setPreferredSize(new Dimension(75, 25));
        this.jButtonGo.setMnemonic('M');
        this.jButtonGo.setText("Move");
        this.jButtonGo.addActionListener(new DriverAgentGUI_jButtonGo_actionAdapter(this));
        this.jTextAreaTopic.setLineWrap(true);
        this.jScrollPaneRoute.setBorder(this.bordRoute);
        this.jScrollPaneRequest.setBorder(this.bordRequest);
        this.jPanelManual.setBorder(this.bordManual);
        this.jPanelManual.setMaximumSize(new Dimension(60, 40));
        this.jPanelManual.setMinimumSize(new Dimension(60, 40));
        this.jPanelManual.setPreferredSize(new Dimension(60, 40));
        this.jPanelManual.setLayout(this.borderLayout1);
        this.jPanelInfo.setBorder(this.bordInfo);
        this.jPanelInfo.setLayout(this.gridBagLayout2);
        this.jLabelPosition.setText("Position:");
        this.jLabelCapacity.setText("Capacity:");
        this.jTextFieldPosition.setEditable(false);
        this.jTextFieldPosition.setText("");
        this.jLabelTransporter.setText("Transporter:");
        this.jLabelConsumption.setText("Consumption:");
        this.jLabelSpeed.setText("Speed:");
        this.jLabelTaskTime.setText("Task Time:");
        this.jTextFieldTransporter.setEditable(false);
        this.jTextFieldTransporter.setText("");
        this.jTextFieldTaskTime.setEditable(false);
        this.jTextFieldTaskTime.setText("0");
        this.jTextFieldConsumption.setEditable(false);
        this.jTextFieldConsumption.setText("");
        this.jTextFieldSpeed.setEditable(false);
        this.jTextFieldSpeed.setText("");
        this.routeTable.addMouseListener(new DriverAgentGUI_routeTable_mouseAdapter(this));
        this.jProgressBarCapacity.setStringPainted(true);
        this.getContentPane().add((Component)this.jPanelInfo, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 1, 0, 1), 435, 0));
        this.jPanelInfo.add((Component)this.jLabelPosition, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(-8, 0, 0, 118), 12, 6));
        this.getContentPane().add((Component)this.jScrollPaneRoute, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 1, 0, 1), 100, 80));
        this.jScrollPaneRoute.getViewport().add((Component)this.routeTable, null);
        this.jPanel1.add((Component)this.jComboBoxWP, null);
        this.jPanel1.add((Component)this.jButtonGo, null);
        this.jPanelManual.add((Component)this.jScrollPane1, "Center");
        this.jPanelManual.add((Component)this.jPanel1, "North");
        this.jScrollPane1.getViewport().add((Component)this.jTextAreaTopic, null);
        this.getContentPane().add((Component)this.jScrollPaneRequest, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 3, 0, 3), -12, -351));
        this.getContentPane().add((Component)this.jPanelManual, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 2, 3), 438, 110));
        this.jScrollPaneRequest.getViewport().add((Component)this.requestTable, null);
        this.jPanelInfo.add((Component)this.jTextFieldTaskTime, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(-8, 0, 0, 2), 34, 0));
        this.jPanelInfo.add((Component)this.jLabelCapacity, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 4, 118), 7, 0));
        this.jPanelInfo.add((Component)this.jTextFieldSpeed, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 4, 2), 34, 0));
        this.jPanelInfo.add((Component)this.jTextFieldPosition, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(-8, 56, 0, 0), 118, 0));
        this.jPanelInfo.add((Component)this.jProgressBarCapacity, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(6, 56, 4, 0), -26, 0));
        this.jPanelInfo.add((Component)this.jLabelConsumption, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 7, 4, 107), 9, 0));
        this.jPanelInfo.add((Component)this.jTextFieldTransporter, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(-8, 90, 0, 0), 107, 0));
        this.jPanelInfo.add((Component)this.jTextFieldConsumption, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 89, 4, 73), 34, 0));
        this.jPanelInfo.add((Component)this.jLabelTransporter, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(-8, 6, 0, 108), 13, 6));
        this.jPanelInfo.add((Component)this.jLabelTaskTime, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(-8, 4, 0, 0), 1, 6));
        this.jPanelInfo.add((Component)this.jLabelSpeed, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 4, 18), 0, 0));
    }

    @Override
    public void setVisible(boolean parm1) {
        if (!parm1) {
            Point p = this.getLocation();
            this.store.putInt(GUI_X, p.x);
            this.store.putInt(GUI_Y, p.y);
            Dimension d = this.getSize();
            this.store.putInt(GUI_W, d.width);
            this.store.putInt(GUI_H, d.height);
        } else if (this.store.exist(GUI_X)) {
            Point loc = this.getLocation();
            int x = this.store.getInt(GUI_X, loc.x);
            int y = this.store.getInt(GUI_Y, loc.y);
            this.setLocation(x, y);
            Dimension d = this.getPreferredSize();
            int w = this.store.getInt(GUI_W, d.width);
            int h = this.store.getInt(GUI_H, d.height);
            this.setSize(w, h);
        }
        super.setVisible(parm1);
    }

    void jButtonGo_actionPerformed(ActionEvent e) {
        this.owner.sendRequest((String)this.jComboBoxWP.getSelectedItem());
    }

    void routeTable_mouseClicked(MouseEvent e) {
        this.routeTabSelectedRow = this.routeTable.getSelectedRow();
        Waypoint wp = (Waypoint)this.owner.getWaypoints().get(this.routeTabSelectedRow);
        this.requestTabModel = new RequestTabModel(wp.getRequestList());
        this.requestTable.setModel(this.requestTabModel);
    }

    public void clearRequestTable() {
        this.requestTabModel = new RequestTabModel(new ArrayList(0));
        this.requestTable.setModel(this.requestTabModel);
    }

    public void decreaseRouteTableSelection() {
        --this.routeTabSelectedRow;
        this.routeTable.setRowSelectionInterval(this.routeTabSelectedRow, this.routeTabSelectedRow);
    }
}

