/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver;

import across.agents.driver.DriverAgent;
import across.data.simulation.SimulationObjectDescription;
import aglobe.ontology.AglobeParam;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.simulation.ontology.Sensor;
import aglobex.simulation.ontology.SensorDescription;
import aglobex.simulation.ontology.SensoryData;
import aglobex.simulation.ontology.SensoryDataRecord;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DriverSensors
implements GISTopicListener {
    protected DriverAgent owner;
    protected SensoryData currentSensoryData;
    protected Map<String, SensoryDataRecord> entitiesInSight = new HashMap<String, SensoryDataRecord>();
    protected Map<String, Set<String>> entitiesInSightByType = new HashMap<String, Set<String>>();
    protected Map<String, SimulationObjectDescription> objectsInSight = new HashMap<String, SimulationObjectDescription>();

    public DriverSensors(DriverAgent owner) {
        this.owner = owner;
    }

    public void processSensorTopic(Object content) {
        this.currentSensoryData = (SensoryData)content;
        this.parseSensoryData(this.currentSensoryData);
    }

    public void handleConfiguration(EntityDescriptor ed) {
        SensorDescription sd = new SensorDescription();
        double range = ed.typeDescriptor.userParamsDouble.get("DRIVER_SENSOR_RANGE");
        AglobeParam rangeParam = new AglobeParam();
        rangeParam.setValue(Double.toString(range));
        sd.setSensorType("spherical");
        sd.getAglobeParam().add(rangeParam);
        this.owner.gisShell.submitTopicToServer("REGISTER_SENSOR", sd);
        this.owner.gisShell.subscribeTopic("TOPIC_SIMULATION_OBJECT", this);
    }

    public boolean isEntityInSight(String entId) {
        return this.entitiesInSight.containsKey(entId);
    }

    public boolean isObjectInSight(String objId) {
        return this.objectsInSight.containsKey(objId);
    }

    public boolean isEntityTypeInSight(String entType) {
        return this.entitiesInSightByType.get(entType) != null && this.entitiesInSightByType.get(entType).size() != 0;
    }

    public List<String> getObjectsInSight() {
        return new ArrayList<String>((Collection)this.objectsInSight.keySet());
    }

    public Set<String> getEntitiesOfTypeInSight(String entType) {
        Set<String> entInSigh = this.entitiesInSightByType.get(entType);
        if (entInSigh == null) {
            return new HashSet<String>();
        }
        return entInSigh;
    }

    public SensoryDataRecord getSDROfEntity(String entId) {
        if (!this.isEntityInSight(entId)) {
            return null;
        }
        return this.entitiesInSight.get(entId);
    }

    public SimulationObjectDescription getObjectsDescription(String objId) {
        if (!this.isObjectInSight(objId)) {
            return null;
        }
        return this.objectsInSight.get(objId);
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equalsIgnoreCase("TOPIC_SIMULATION_OBJECT")) {
            SimulationObjectDescription sod = (SimulationObjectDescription)content;
            this.objectsInSight.put(sod.getName(), sod);
        }
    }

    @Override
    public void addEvent(Runnable e) {
        this.owner.addEvent(e);
    }

    protected void parseSensoryData(SensoryData sd) {
        LinkedList<String> currentEntities = new LinkedList<String>();
        for (Sensor sen : sd.sensor) {
            if (sen.sensoryDataRecord.size() <= 0) continue;
            for (SensoryDataRecord sdr : sen.sensoryDataRecord) {
                currentEntities.add(sdr.targetContainerName);
                this.entitiesInSight.put(sdr.targetContainerName, sdr);
                Set<String> entitiesOfOneType = this.entitiesInSightByType.get(sdr.targetEntityType);
                if (entitiesOfOneType == null) {
                    entitiesOfOneType = new HashSet<String>();
                    this.entitiesInSightByType.put(sdr.targetEntityType, entitiesOfOneType);
                }
                entitiesOfOneType.add(sdr.targetContainerName);
                if (!sdr.targetEntityType.equalsIgnoreCase("SIMULATION_OBJECT_TYPE")) continue;
                String objId = sdr.targetContainerName;
                if (!this.objectsInSight.containsKey(objId)) {
                    this.objectsInSight.put(objId, null);
                }
                this.askForObjectDescription(objId);
            }
        }
        this.removeEntitiesOutOfSight(currentEntities);
    }

    protected void removeEntitiesOutOfSight(List<String> currentEntities) {
        Iterator<Map.Entry<String, SensoryDataRecord>> iter = this.entitiesInSight.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, SensoryDataRecord> element = iter.next();
            String entId = element.getKey();
            SensoryDataRecord sdr = element.getValue();
            if (currentEntities.contains(entId)) continue;
            this.entitiesInSightByType.get(sdr.targetEntityType).remove(entId);
            this.objectsInSight.remove(entId);
            iter.remove();
        }
    }

    protected void askForObjectDescription(String objId) {
        this.owner.gisShell.submitTopicToServer("TOPIC_SIMULATION_OBJECT", objId, "SIMULATION_OBJECT_DESCRIPTION");
    }
}

