/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver;

import across.agents.driver.DriverAgent;
import across.agents.driver.DriverAgentSimulationData;
import across.agents.driver.data.Route;
import across.agents.driver.data.RouteInfo;
import across.agents.driver.data.TransportRoute;
import across.data.AcrossMapArcs;
import across.data.AcrossMapDistances;
import across.data.AcrossMapNodes;
import across.data.Arc;
import across.data.Batch;
import across.data.Node;
import across.data.RequestList;
import across.data.TransportOrder;
import across.data.Waypoint;
import across.data.simulation.SimulationObjectDescription;
import across.util.pathfinding.AStarModPathfinding;
import across.util.pathfinding.Pathfinding;
import across.util.pathfinding.RoadEvaluator;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DriverMovement {
    protected List<Node> mapNodes;
    protected List<Arc> mapArcs;
    protected Pathfinding pathfinding;
    protected RoadEvaluator roadEval;
    protected DriverAgent owner;
    protected DriverAgentSimulationData ownerData;
    protected LinkedList<Waypoint> waypoints = new LinkedList();
    protected String actualLoc;
    protected String headingTo;
    protected String homeLoc = null;
    protected TransportOrder commitedTransports = new TransportOrder();
    protected boolean retreating = false;
    private int counterToRefresh = 50;
    protected LinkedList<Arc> barredRoads = new LinkedList();

    public DriverMovement(DriverAgent owner) {
        this.owner = owner;
    }

    public void handleMovementTopic(Object content, String reason) {
        if (this.counterToRefresh == 0) {
            this.counterToRefresh = 50;
            this.refreshBarred();
        } else {
            --this.counterToRefresh;
        }
        if (reason.equalsIgnoreCase("CONTROL_RESPONSE_BAD_NODE")) {
            this.owner.gui.addToTextArea("Content: RESPONSE_FAILED");
            this.owner.gui.addToTextArea("Reason: " + reason);
            this.owner.logSevere("Bad node chosen!");
        } else if (reason.equalsIgnoreCase("CONTROL_RESPONSE_FAILURE")) {
            this.owner.gui.addToTextArea("Content: RESPONSE_FAILED");
            this.owner.gui.addToTextArea("Reason: " + reason);
            this.owner.logSevere("Movement failure!");
        } else if (reason.equalsIgnoreCase("CONTROL_RESPONSE_STOPPED") && content instanceof String) {
            if (!content.equals(this.actualLoc)) {
                double time = 0.0;
                for (Arc arc : this.mapArcs) {
                    if (arc.getFrom() == this.actualLoc && arc.getTo() == content) {
                        time = this.roadEval.getTime(arc);
                        continue;
                    }
                    if (arc.getTo() != this.actualLoc || arc.getFrom() != content) continue;
                    time = this.roadEval.getTime(arc);
                }
                this.owner.totalTaskTime -= time;
            }
            this.actualLoc = (String)content;
            this.retreating = false;
            if (this.waypoints.size() == 0) {
                return;
            }
            Waypoint wp = this.waypoints.getFirst();
            if (wp.getLocationName().equals(this.actualLoc)) {
                this.waypoints.removeFirst();
            }
            if (wp.getRequestList().size() > 0) {
                this.owner.loadAndUnload(wp.getRequestList());
                this.removeDoneWaypointFromTransportOrder(wp.getRequestList());
            }
            this.owner.gui.jTextFieldPosition.setText("-> " + this.actualLoc);
            this.owner.gui.routeTabModel.fireTableDataChanged();
            if (this.owner.gui.routeTabSelectedRow == 0) {
                this.owner.gui.clearRequestTable();
            } else {
                this.owner.gui.decreaseRouteTableSelection();
            }
            this.owner.gui.addToTextArea("Content: RESPONSE_ARRIVED");
            this.owner.gui.addToTextArea("Reason: " + reason);
            this.owner.gui.jTextFieldPosition.setText(this.actualLoc);
            this.owner.gui.jTextFieldTaskTime.setText(Double.toString((double)((int)(100.0 * this.owner.totalTaskTime)) / 100.0));
            this.owner.gui.routeTabModel.fireTableDataChanged();
            if (this.owner.gui.routeTabSelectedRow == 0) {
                this.owner.gui.clearRequestTable();
            } else {
                this.owner.gui.decreaseRouteTableSelection();
            }
            this.move();
        }
    }

    protected void move() {
        String waypointName;
        if (!this.isOnRoute()) {
            if (!this.owner.sendAvailable()) {
                this.goHome();
            }
            return;
        }
        Waypoint wp = this.waypoints.getFirst();
        this.headingTo = waypointName = wp.getLocationName();
        this.owner.gisShell.submitTopic("ENTITY_CONTROL", waypointName, "CONTROL_MOVE_TO");
    }

    protected void goHome() {
        if (this.homeLoc == null) {
            return;
        }
        if (!this.actualLoc.equalsIgnoreCase(this.homeLoc)) {
            TransportOrder to = new TransportOrder();
            to.getWaypoint().add(new Waypoint(this.homeLoc));
            TransportRoute route = this.planRoute(to, false);
            this.waypoints.addAll(route.getRoute().getWaypoints());
            double totalTaskTime = route.getRoute().getRouteInfo().routeTime;
            this.owner.gui.jTextFieldTaskTime.setText(Double.toString((double)((int)(100.0 * totalTaskTime)) / 100.0));
            this.owner.gui.addToTextArea("Current plan: " + this.waypoints);
            this.owner.gui.routeTabModel.fireTableDataChanged();
            this.move();
        } else {
            this.owner.logSevere(" ++++ Driver can not communicate locally. Driver: " + this.owner.getAddress().getName() + " loc: " + this.actualLoc + " home: " + this.homeLoc);
        }
    }

    public void handleConfiguration(EntityDescriptor ed, DriverAgentSimulationData data) {
        RoadEvaluator re;
        this.ownerData = data;
        this.actualLoc = ed.confParamsString.get("ENTITY_START_NODE");
        this.mapNodes = ((AcrossMapNodes)ed.typeDescriptor.userObjects.get("MAP_NODES")).getNode();
        this.mapArcs = ((AcrossMapArcs)ed.typeDescriptor.userObjects.get("MAP_ARCS")).getArc();
        double[][] mapDistances = ((AcrossMapDistances)ed.typeDescriptor.userObjects.get("MAP_DISTANCES")).getDistance();
        this.roadEval = re = new RoadEvaluator(){

            @Override
            public double getPrice(Arc arc) {
                return 1.0 / arc.getQuality() * arc.getLength() * DriverMovement.this.ownerData.consumption / 100.0;
            }

            @Override
            public double getTime(Arc arc) {
                return 10.0 * arc.getLength() / DriverMovement.this.ownerData.velocity;
            }
        };
        this.pathfinding = new AStarModPathfinding(this.mapNodes, this.mapArcs, mapDistances, re, this.barredRoads);
    }

    public void setHomeNode(String node) {
        this.homeLoc = node;
    }

    public boolean isOnRoute() {
        return this.waypoints.size() != 0;
    }

    public boolean isHome() {
        return this.actualLoc.equals(this.homeLoc) && !this.isOnRoute();
    }

    public boolean isVehicleGoingThroughRoad(String node1, String node2) {
        if (node1.equals(this.actualLoc) && node2.equals(this.headingTo) || node1.equals(this.headingTo) && node2.equals(this.actualLoc)) {
            return true;
        }
        return !this.isOnRoute() && node1.equals(this.actualLoc) && node1.equals(node2);
    }

    public RouteInfo getRouteInformation(TransportOrder to, boolean byPrice) {
        TransportRoute route = this.planRoute(to, byPrice);
        if (route != null && route.getPlanned().getWaypoint().size() != 0) {
            return route.getRoute().getRouteInfo();
        }
        return null;
    }

    public RouteInfo carryOutRoute(TransportOrder to, boolean byPrice) {
        TransportRoute route = this.planRoute(to, byPrice);
        if (route != null && route.getPlanned().getWaypoint().size() != 0) {
            this.commitedTransports.getWaypoint().addAll(route.getPlanned().getWaypoint());
            this.waypoints.addAll(route.getRoute().getWaypoints());
            this.move();
            return route.getRoute().getRouteInfo();
        }
        return null;
    }

    public void obstacleDetected(SimulationObjectDescription sod) {
        if (!this.retreating) {
            this.controlStop();
        }
        this.replanRouteRoadBarred(sod);
    }

    protected void replanRouteRoadBarred(SimulationObjectDescription sod) {
        if (this.retreating) {
            return;
        }
        this.retreating = true;
        this.waypoints.clear();
        Waypoint actWaypoint = new Waypoint(this.actualLoc);
        this.waypoints.add(actWaypoint);
        String barredNode = this.headingTo;
        for (Arc arc : this.mapArcs) {
            if ((!arc.getFrom().equals(this.actualLoc) || !arc.getTo().equals(barredNode)) && (!arc.getTo().equals(this.actualLoc) || !arc.getFrom().equals(barredNode))) continue;
            this.barredRoads.add(arc);
            break;
        }
        TransportRoute r = this.planRoute(this.commitedTransports, true);
        if (r == null || r.getPlanned().getWaypoint().size() == 0) {
            r = this.planRoute(this.commitedTransports, false);
        }
        this.waypoints.addAll(r.getRoute().getWaypoints());
        this.move();
    }

    protected TransportRoute planRoute(TransportOrder to, boolean byPrice) {
        TransportRoute tr = new TransportRoute();
        tr.setNotPlanned(new TransportOrder());
        tr.setPlanned(new TransportOrder());
        Route route = new Route();
        String startPoint = this.waypoints.size() == 0 ? new String(this.actualLoc) : new String(this.waypoints.getLast().getLocationName());
        double taskTime = 0.0;
        double taskPrice = 0.0;
        for (Waypoint wp : to.getWaypoint()) {
            long lowestTime = this.getLowestDeliveryTime(wp);
            Route oneRoute = byPrice ? this.pathfinding.planRoute(startPoint, wp.getLocationName(), 0.0, 1.0) : this.pathfinding.planRoute(startPoint, wp.getLocationName(), 1.0, 0.0);
            if (oneRoute == null) {
                tr.getNotPlanned().getWaypoint().add(wp);
                continue;
            }
            if (byPrice && taskTime + oneRoute.getRouteInfo().routeTime > (double)lowestTime) {
                tr.getNotPlanned().getWaypoint().add(wp);
                continue;
            }
            taskTime += oneRoute.getRouteInfo().routeTime;
            taskPrice += oneRoute.getRouteInfo().routePrice;
            startPoint = wp.getLocationName();
            route.addWaypoints(oneRoute.getWaypoints());
            route.addWaypoint(wp);
            tr.getPlanned().getWaypoint().add(wp);
        }
        route.setRouteInfo(new RouteInfo(taskTime, taskPrice));
        tr.setRoute(route);
        return tr;
    }

    private void removeDoneWaypointFromTransportOrder(List<RequestList> requestList) {
        Iterator<Waypoint> iter = this.commitedTransports.getWaypoint().iterator();
        while (iter.hasNext()) {
            Waypoint way = iter.next();
            Iterator<RequestList> iterator = way.getRequestList().iterator();
            while (iterator.hasNext()) {
                RequestList rl = iterator.next();
                if (!requestList.contains(rl)) continue;
                iterator.remove();
            }
            if (way.getRequestList() == null || way.getRequestList().size() != 0) continue;
            iter.remove();
        }
    }

    protected long getLowestDeliveryTime(Waypoint wp) {
        long lowestTime = Long.MAX_VALUE;
        for (RequestList rl : wp.getRequestList()) {
            for (Batch batch : rl.getBatch()) {
                if (batch.getDeliveryTime() >= lowestTime) continue;
                lowestTime = batch.getDeliveryTime();
            }
        }
        return lowestTime;
    }

    private void refreshBarred() {
        this.barredRoads.clear();
    }

    protected void controlStop() {
        this.owner.gisShell.submitTopicToServer("ENTITY_CONTROL", null, "CONTROL_STOP");
    }
}

