/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver;

import across.data.AcrossMapArcs;
import across.data.AcrossMapNodes;
import across.data.Arc;
import across.data.Node;
import aglobe.visio3D.PlanUpdate;
import aglobex.simulation.entitysimulator.ControlLink;
import aglobex.simulation.entitysimulator.EntityBehaviour;
import aglobex.simulation.entitysimulator.EntityState;
import aglobex.simulation.global.EntityRecord;
import aglobex.simulation.ontology.WorldDimension;
import aglobex.vecmath.Point3d;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DriverBehaviour
implements EntityBehaviour {
    private double[][] arcLengths;
    private HashMap<String, Integer> nodeNamesToNumbers;
    private List<Node> mapNodes;
    private String startNode;
    private String endNode;
    private boolean moving = false;
    private ControlLink myControl;
    private EntityRecord entityRec;
    private WorldDimension worldDim;
    private double[] movementVector;
    private double[] position;
    private double velocity;
    private double lengthToGo = 0.0;
    private EntityState es = new EntityState();
    private boolean active = true;
    private double simulationCyclePeriod = 100.0;

    @Override
    public void control(Object content, String reason) {
        if (reason == null) {
            this.myControl.getClass();
        }
        if (content instanceof String && reason.equalsIgnoreCase("CONTROL_MOVE_TO")) {
            this.endNode = (String)content;
            if (!this.moving) {
                double[] endNodePosition = this.getPositionFromNode(this.endNode);
                this.movementVector = new double[]{endNodePosition[0] - this.position[0], endNodePosition[1] - this.position[1]};
                double length = Math.sqrt(Math.pow(this.movementVector[0], 2.0) + Math.pow(this.movementVector[1], 2.0));
                if (length > 0.0 || this.arcLengths[this.nodeNamesToNumbers.get(this.startNode)][this.nodeNamesToNumbers.get(this.endNode)] == -1.0) {
                    this.moving = true;
                    this.lengthToGo = length;
                } else {
                    this.myControl.sendControlResponse(null, "CONTROL_RESPONSE_BAD_NODE");
                }
            }
        } else if (reason.equalsIgnoreCase("CONTROL_STOP")) {
            this.moving = false;
        } else {
            this.myControl.sendControlResponse(null, "CONTROL_RESPONSE_FAILURE");
        }
    }

    private double[] getPositionFromNode(String node) {
        int ind = this.nodeNamesToNumbers.get(node);
        Node n = this.mapNodes.get(ind);
        return new double[]{n.getX(), n.getY()};
    }

    @Override
    public void dispose() {
        this.active = false;
    }

    @Override
    public void entityCrashed(EntityBehaviour otherObject, long fromTime) {
        this.myControl.destroyEntity();
    }

    @Override
    public PlanUpdate getPlanUpdate(boolean removeOld) {
        return null;
    }

    @Override
    public void init(ControlLink controlLink, EntityRecord entityRecord, WorldDimension worldDimension) throws Exception {
        AcrossMapNodes amn = (AcrossMapNodes)entityRecord.entityDescriptor.typeDescriptor.userObjects.get("MAP_NODES");
        AcrossMapArcs ama = (AcrossMapArcs)entityRecord.entityDescriptor.typeDescriptor.userObjects.get("MAP_ARCS");
        this.mapNodes = amn.getNode();
        this.nodeNamesToNumbers = this.getNodeNamesToNumbersMap(this.mapNodes);
        this.arcLengths = this.getConnectedNodes(ama.getArc());
        this.myControl = controlLink;
        this.entityRec = entityRecord;
        this.worldDim = worldDimension;
        this.velocity = Double.parseDouble(entityRecord.entityDescriptor.confParamsString.get("VEHICLE_VELOCITY"));
        this.startNode = entityRecord.entityDescriptor.confParamsString.get("ENTITY_START_NODE");
        this.position = this.getPositionFromNode(this.startNode);
        this.es.position = new Point3d(this.position[0], this.position[1], 0.0);
    }

    private HashMap<String, Integer> getNodeNamesToNumbersMap(List<Node> nodes) {
        HashMap<String, Integer> namesToNums = new HashMap<String, Integer>();
        int counter = 0;
        for (Node node : nodes) {
            String name = node.getName();
            if (namesToNums.containsKey(name)) continue;
            namesToNums.put(name, counter);
            ++counter;
        }
        return namesToNums;
    }

    private double[][] getConnectedNodes(List<Arc> arcs) {
        double[][] retVal;
        int size = this.nodeNamesToNumbers.size();
        double[][] dArray = retVal = new double[size][size];
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            double[] bs = dArray[n];
            Arrays.fill(bs, -1.0);
            ++n;
        }
        for (Arc arc : arcs) {
            double length;
            int x = this.nodeNamesToNumbers.get(arc.getFrom());
            int y = this.nodeNamesToNumbers.get(arc.getTo());
            retVal[x][y] = length = arc.getLength();
            retVal[y][x] = length;
        }
        return retVal;
    }

    @Override
    public EntityState updateEntityState(long timeStep, long currentSimulationTimestamp) {
        if (this.moving && this.active) {
            double diff = timeStep;
            double diffLength = diff * this.velocity / this.simulationCyclePeriod;
            if (diffLength >= this.lengthToGo) {
                this.moving = false;
                this.startNode = this.endNode;
                this.myControl.sendControlResponse(this.endNode, "CONTROL_RESPONSE_STOPPED");
                diffLength = this.lengthToGo;
                double[] endNodePos = this.getPositionFromNode(this.endNode);
                this.es.position = new Point3d(endNodePos[0], endNodePos[1], 0.0);
            } else {
                this.lengthToGo -= diffLength;
                double angle = Math.atan2(this.movementVector[1], this.movementVector[0]);
                this.position[0] = this.position[0] + Math.cos(angle) * diffLength;
                this.position[1] = this.position[1] + Math.sin(angle) * diffLength;
                this.es.position = new Point3d(this.position[0], this.position[1], 0.0);
                if (this.entityRec.entityDescriptor.typeDescriptor.typeName.equals("TERRORIST_DRIVER_ENTITY_TYPE")) {
                    this.myControl.sendControlResponse(this.position, "CONTROL_RESPONSE_STOPPED");
                }
            }
        }
        return this.es;
    }
}

