/*
 * Decompiled with CFR 0.152.
 */
package across.agents.driver;

import across.agents.driver.DriverAgentSimulationData;
import across.agents.driver.DriverMovement;
import across.agents.driver.DriverSensors;
import across.agents.driver.data.RoadInfo;
import across.agents.driver.data.RouteInfo;
import across.agents.driver.gui.DriverAgentGUI;
import across.agents.driver.gui.DriverGUIInterface;
import across.agents.driver.util.UpdateTransporter;
import across.data.Batch;
import across.data.Page;
import across.data.Param;
import across.data.Proposal;
import across.data.PublicParams;
import across.data.RequestList;
import across.data.TransportOrder;
import across.data.Waypoint;
import across.data.simulation.SimulationObjectDescription;
import across.data.simulation.SimulationObjectLocation;
import aglobe.container.ElementaryEntity;
import aglobe.container.agent.Agent;
import aglobe.container.sysservice.directory.DirectoryException;
import aglobe.container.sysservice.directory.DirectoryListener;
import aglobe.container.sysservice.directory.DirectoryRecord;
import aglobe.container.sysservice.directory.DirectoryService;
import aglobe.container.transport.Address;
import aglobe.container.transport.InvisibleContainerException;
import aglobe.ontology.AgentInfo;
import aglobe.ontology.Message;
import aglobe.service.gis.client.GISClientService;
import aglobe.service.gis.client.GISTopicListener;
import aglobex.simulation.global.ClientServerTopicConstants;
import aglobex.simulation.ontology.entity.EntityDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DriverAgent
extends Agent
implements GISTopicListener,
DirectoryListener,
DriverGUIInterface,
ClientServerTopicConstants {
    public static String MY_TRANSPORTER = "MY-TRANSPORTER";
    public static final String TYPE = "Driver";
    protected DriverAgentSimulationData mySimData = new DriverAgentSimulationData();
    protected DriverMovement myMovement = new DriverMovement(this);
    protected DriverSensors mySensors = new DriverSensors(this);
    protected GISClientService.Shell gisShell;
    private DirectoryService.Shell dsShell;
    public DriverAgentGUI gui;
    protected Address transporter = null;
    protected List<Address> emergencyCentres = new ArrayList<Address>();
    private EntityDescriptor entityDescriptor;
    protected Message subscribe = null;
    protected LinkedList<Message> undeliveredMessages = new LinkedList();
    protected Map<String, Message> doneMessageMap = new HashMap<String, Message>();
    protected String visioInfo = "";
    protected boolean visioInfoShown = false;
    private Page page;
    protected double totalTaskTime = 0.0;

    @Override
    public void init(AgentInfo ai, int initState) {
        super.init(ai, initState);
        this.gui = new DriverAgentGUI(this);
        UpdateTransporter utrans = new UpdateTransporter(this, this.transporter);
        this.gisShell = (GISClientService.Shell)this.getContainer().getServiceManager().getService(this, "gis/client");
        if (this.gisShell != null) {
            this.gisShell.subscribeTopic("ENTITY_CONNECTION", this);
            this.gisShell.subscribeTopic("ENTITY_CONTROL", this);
            this.gisShell.subscribeTopic("SIMULATION_TIME_UPDATE_1_SECOND", this);
            this.gisShell.subscribeTopic("SENSORY_DATA", this);
        } else {
            this.logger.warning("Driver Agent error: GISClientService isn't running on this container");
        }
        this.dsShell = (DirectoryService.Shell)this.getContainer().getServiceManager().getService(this, "container/directory");
        if (this.dsShell != null) {
            LinkedList<String> driv = new LinkedList<String>();
            driv.add(TYPE);
            try {
                this.dsShell.register((ElementaryEntity)this, driv);
                this.dsShell.subscribe(utrans, "Transporter");
                this.dsShell.subscribe(this, "EmergencyCentre");
            }
            catch (DirectoryException e) {
                this.logger.warning("Driver Agent error: Directory service exception: " + e);
            }
        } else {
            this.logger.warning("Driver Agent error: DirectoryService isn't running on this container");
        }
    }

    private void handleConfiguration(EntityDescriptor ed) {
        this.entityDescriptor = ed;
        this.mySimData.capacity = Double.parseDouble(ed.confParamsString.get("VEHICLE_CAPACITY"));
        this.mySimData.consumption = Double.parseDouble(ed.confParamsString.get("VEHICLE_CONSUMPTION"));
        this.mySimData.velocity = Double.parseDouble(ed.confParamsString.get("VEHICLE_VELOCITY"));
        this.myMovement.handleConfiguration(ed, this.mySimData);
        this.mySensors.handleConfiguration(ed);
        this.updatePage();
        this.showConfInGui();
    }

    private void updateInfoInVisio() {
        this.updatePage();
        this.gisShell.submitTopicToServer("PAGE_UPDATE", this.page);
    }

    private void updatePage() {
        this.page = new Page();
        this.page.setAddress(this.getAddress());
        this.page.setName(this.getName());
        this.page.setPublicParams(new PublicParams());
        this.page.getPublicParams().setType(TYPE);
    }

    @Override
    protected void finish() {
        this.gui.dispose();
        super.finish();
    }

    @Override
    protected void handleIncomingMessage(Message m) {
        RouteInfo ri;
        if (m.getPerformative().equals("SUBSCRIBE")) {
            if (this.transporter == null) {
                this.transporter = m.getSender();
                this.subscribe = m;
                this.myMovement.setHomeNode((String)m.getContent());
                int i = this.transporter.getName().indexOf("Transporter");
                this.visioInfo = "<b>" + this.transporter.getName().substring(0, i);
                this.visioInfo = String.valueOf(this.visioInfo) + " ";
                this.visioInfo = String.valueOf(this.visioInfo) + this.getName();
                String info = String.valueOf(this.visioInfo) + " (" + this.mySimData.loadedCapacity + "/" + (long)this.mySimData.capacity + ")";
                this.gisShell.submitTopicToServer("VISIO_INFO", info);
                Byte load = new Byte((byte)((double)this.mySimData.loadedCapacity / this.mySimData.capacity * 255.0));
                this.gisShell.submitTopicToServer("LOAD_STATUS", load.toString());
                this.visioInfoShown = true;
                this.gui.jTextFieldTransporter.setText(this.transporter.getName());
                Message reply = m.getReply();
                reply.setPerformative("AGREE");
                this.send(reply);
                Param param = new Param();
                param.setName(MY_TRANSPORTER);
                param.setValue(this.transporter.getName());
                this.page.getPublicParams().getParam().add(param);
                this.gisShell.submitTopic("PAGE_UPDATE", this.page);
            } else {
                Message reply = m.getReply();
                reply.setPerformative("REFUSE");
                this.send(reply);
            }
        }
        if (m.getPerformative().equals("QUERY-REF")) {
            TransportOrder to = (TransportOrder)m.getContent();
            ri = this.myMovement.getRouteInformation(to, true);
            if (ri == null) {
                ri = this.myMovement.getRouteInformation(to, false);
            }
            if (ri == null) {
                return;
            }
            Message proposal = m.getReply();
            proposal.setPerformative("INFORM-RESULT");
            Proposal p = new Proposal();
            p.setProposalTime((long)ri.routeTime);
            p.setRequestid("" + (long)this.hashCode() * System.currentTimeMillis());
            p.setTotalPrice((long)ri.routePrice);
            proposal.setContent(p);
            this.send(proposal);
        }
        if (m.getPerformative().equals("REQUEST")) {
            TransportOrder to = (TransportOrder)m.getContent();
            if (to.getWaypoint().size() == 2) {
                String requestid = to.getWaypoint().get(1).getRequestList().get(0).getRequestid();
                this.doneMessageMap.put(requestid, (Message)m.clone());
            }
            if ((ri = this.myMovement.carryOutRoute(to, true)) == null) {
                ri = this.myMovement.carryOutRoute(to, false);
            }
            if (ri == null) {
                return;
            }
            this.totalTaskTime += ri.routeTime;
            this.gui.jTextFieldTaskTime.setText(Double.toString((double)((int)(100.0 * this.totalTaskTime)) / 100.0));
            this.gui.addToTextArea("Current plan: " + this.myMovement.waypoints);
            this.gui.routeTabModel.fireTableDataChanged();
        }
    }

    @Override
    public void handleTopic(String topic, Object content, String reason) {
        if (topic.equals("ENTITY_CONNECTION")) {
            if (content instanceof EntityDescriptor) {
                this.handleConfiguration((EntityDescriptor)content);
            }
        } else if (topic.equalsIgnoreCase("SIMULATION_TIME_UPDATE_1_SECOND")) {
            this.updateInfoInVisio();
            this.myMovement.move();
            if (!this.myMovement.isHome() && !this.myMovement.isOnRoute()) {
                this.myMovement.goHome();
            }
        } else if (topic.equalsIgnoreCase("ENTITY_CONTROL")) {
            this.myMovement.handleMovementTopic(content, reason);
            if (!this.visioInfoShown) {
                String info = String.valueOf(this.visioInfo) + " (" + this.mySimData.loadedCapacity + "/" + (long)this.mySimData.capacity + ")";
                this.gisShell.submitTopicToServer("VISIO_INFO", info);
                Byte load = new Byte((byte)((double)this.mySimData.loadedCapacity / this.mySimData.capacity * 255.0));
                this.gisShell.submitTopicToServer("LOAD_STATUS", load.toString());
                this.visioInfoShown = true;
            }
        } else if (topic.equalsIgnoreCase("SENSORY_DATA")) {
            this.mySensors.processSensorTopic(content);
            for (String objId : this.mySensors.getObjectsInSight()) {
                SimulationObjectDescription sod = this.mySensors.getObjectsDescription(objId);
                if (sod == null) continue;
                SimulationObjectLocation sol = sod.getLocation();
                if (!this.myMovement.isVehicleGoingThroughRoad(sol.startLocation, sol.endLocation)) continue;
                this.myMovement.obstacleDetected(sod);
                this.reportObstacle(sod);
            }
        } else {
            this.logger.severe("Unexpected topic: " + topic);
        }
    }

    protected void reportObstacle(SimulationObjectDescription sod) {
        for (Address adr : this.emergencyCentres) {
            Message mes = Message.newInstance("INFORM");
            mes.setContent(sod);
            mes.setReceiver(adr);
            mes.setSender(this.getAddress());
            try {
                this.sendMessage(mes);
            }
            catch (InvisibleContainerException e) {
                e.printStackTrace();
            }
        }
    }

    private void showConfInGui() {
        this.gui.jTextFieldSpeed.setText("" + this.mySimData.velocity);
        this.gui.jTextFieldConsumption.setText(Integer.toString((int)this.mySimData.consumption));
        this.gui.jProgressBarCapacity.setMaximum((int)this.mySimData.capacity);
        this.gui.jProgressBarCapacity.setValue(0);
        this.gui.jTextFieldPosition.setText(this.myMovement.actualLoc);
    }

    protected boolean sendAvailable() {
        if (this.subscribe != null) {
            Message reply = this.subscribe.getReply();
            reply.setPerformative("INFORM-RESULT");
            reply.setContent(this.myMovement.actualLoc);
            try {
                this.sendMessage(reply);
                return true;
            }
            catch (InvisibleContainerException e) {
                return false;
            }
        }
        return false;
    }

    protected void loadAndUnload(List<RequestList> l) {
        boolean unloading = true;
        for (RequestList rl : l) {
            Address locationAddress = rl.getDeliveryAddress();
            for (Batch batch : rl.getBatch()) {
                String content;
                long diff = this.mySimData.loadedCapacity + batch.getCount();
                if (diff < 0L) {
                    batch.setCount(-this.mySimData.loadedCapacity);
                } else if ((double)diff > this.mySimData.capacity) {
                    batch.setCount((long)(this.mySimData.capacity - (double)this.mySimData.loadedCapacity));
                }
                this.mySimData.loadedCapacity += batch.getCount();
                Message m = Message.newInstance("REQUEST", this.getAddress(), locationAddress);
                m.setProtocol("REQUEST");
                m.setContent(batch);
                this.send(m);
                if (batch.getCount() > 0L) {
                    content = Byte.toString((byte)1);
                    unloading = false;
                } else {
                    content = Byte.toString((byte)2);
                }
                this.gisShell.submitTopicToServer("VISIO_ACTION", content, this.getAddress().toString());
                this.scheduleEvent(new Runnable(){

                    @Override
                    public void run() {
                        String info = String.valueOf(DriverAgent.this.visioInfo) + " (" + DriverAgent.this.mySimData.loadedCapacity + "/" + (long)DriverAgent.this.mySimData.capacity + ")";
                        DriverAgent.this.gisShell.submitTopicToServer("VISIO_INFO", info);
                        Byte load = new Byte((byte)((double)DriverAgent.this.mySimData.loadedCapacity / DriverAgent.this.mySimData.capacity * 255.0));
                        DriverAgent.this.gisShell.submitTopicToServer("LOAD_STATUS", load.toString());
                        DriverAgent.this.gui.jProgressBarCapacity.setValue((int)DriverAgent.this.mySimData.loadedCapacity);
                    }
                }, 200L);
            }
            if (!unloading) continue;
            this.sendDone(rl.getRequestid());
        }
    }

    private void send(Message m) {
        try {
            this.sendMessage(m);
        }
        catch (InvisibleContainerException e) {
            this.logger.info("Target platform inaccessible:" + m.getReceiver().toString());
        }
    }

    protected void sendDone(String requestid) {
        Message reply = Message.newInstance("INFORM-DONE", this.getAddress(), this.transporter);
        reply.setProtocol("REQUEST");
        if (this.doneMessageMap.get(requestid) == null) {
            System.out.println("ERROR - double use of requestid");
            return;
        }
        TransportOrder t = (TransportOrder)this.doneMessageMap.get(requestid).getContent();
        Waypoint w = t.getWaypoint().get(1);
        RequestList r = w.getRequestList().get(0);
        reply.setContent(r);
        this.doneMessageMap.remove(requestid);
        try {
            this.sendMessage(reply);
        }
        catch (InvisibleContainerException e) {
            this.undeliveredMessages.add(reply);
        }
    }

    public void resendMessages() {
        if (this.undeliveredMessages.size() > 0) {
            System.out.println(String.valueOf(this.getName()) + " - resending " + this.undeliveredMessages.size() + " message(s) to transporter");
            LinkedList<Message> aux = new LinkedList<Message>();
            for (Message m : this.undeliveredMessages) {
                try {
                    this.sendMessage(m);
                }
                catch (InvisibleContainerException e) {
                    aux.add(m);
                }
            }
            this.undeliveredMessages = aux;
        }
    }

    @Override
    public LinkedList getWaypoints() {
        return this.myMovement.waypoints;
    }

    @Override
    public String getActualNode() {
        return this.myMovement.actualLoc;
    }

    @Override
    public LinkedList getNodeNames() {
        return null;
    }

    @Override
    public RoadInfo[][] getArcs() {
        return null;
    }

    @Override
    public void sendRequest(String request) {
    }

    @Override
    public void handleDeregister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleInvisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleNewRegister(String containerName, DirectoryRecord[] records, String matchingFilter) {
    }

    @Override
    public void handleVisible(String containerName, DirectoryRecord[] records, String matchingFilter) {
        if (matchingFilter.equals("EmergencyCentre")) {
            int i = 0;
            while (i < records.length) {
                DirectoryRecord record = records[i];
                this.emergencyCentres.add(record.address);
                ++i;
            }
        }
    }
}

